/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class NodeTableModel
extends AbstractTableModel {
    private static final String ATTR_INVISIBLE = "InvisibleInTreeTableView";
    static final String ATTR_COMPARABLE_COLUMN = "ComparableColumnTTV";
    static final String ATTR_SORTING_COLUMN = "SortingColumnTTV";
    static final String ATTR_DESCENDING_ORDER = "DescendingOrderTTV";
    private static final String ATTR_ORDER_NUMBER = "OrderNumberTTV";
    private static final String ATTR_TREE_COLUMN = "TreeColumnTTV";
    private static final String ATTR_MNEMONIC_CHAR = "ColumnMnemonicCharTTV";
    private static final String ATTR_DISPLAY_NAME_WITH_MNEMONIC = "ColumnDisplayNameWithMnemonicTTV";
    ArrayColumn[] allPropertyColumns = new ArrayColumn[0];
    private int[] propertyColumns = new int[0];
    private Node[] nodeRows = new Node[0];
    private int sortColumn = -1;
    private boolean existsComparableColumn = false;
    private Node.Property treeColumnProperty = null;
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            int n = NodeTableModel.this.rowForNode((Node)propertyChangeEvent.getSource());
            if (n == -1) {
                return;
            }
            int n2 = NodeTableModel.this.columnForProperty(propertyChangeEvent.getPropertyName());
            if (n2 == -1) {
                NodeTableModel.this.fireTableRowsUpdated(n, n);
            } else {
                NodeTableModel.this.fireTableCellUpdated(n, n2);
            }
        }
    };

    public void setNodes(Node[] nodeArray) {
        int n;
        for (n = 0; n < this.nodeRows.length; ++n) {
            this.nodeRows[n].removePropertyChangeListener(this.pcl);
        }
        this.nodeRows = nodeArray;
        for (n = 0; n < this.nodeRows.length; ++n) {
            this.nodeRows[n].addPropertyChangeListener(this.pcl);
        }
        this.fireTableDataChanged();
    }

    public void setProperties(Node.Property[] propertyArray) {
        int n;
        TreeMap<Double, Integer> treeMap;
        int n2;
        int n3 = propertyArray.length;
        this.sortColumn = -1;
        int n4 = -1;
        for (n2 = 0; n2 < propertyArray.length; ++n2) {
            treeMap = propertyArray[n2].getValue(ATTR_TREE_COLUMN);
            if (treeMap == null || !(treeMap instanceof Boolean) || !((Boolean)((Object)treeMap)).booleanValue()) continue;
            this.treeColumnProperty = propertyArray[n2];
            --n3;
            n4 = n2;
        }
        this.allPropertyColumns = new ArrayColumn[n3];
        n2 = 0;
        this.existsComparableColumn = false;
        treeMap = new TreeMap<Double, Integer>();
        int n5 = 0;
        for (n = 0; n < propertyArray.length; ++n) {
            Object object;
            if (n == n4) continue;
            this.allPropertyColumns[n5] = new ArrayColumn();
            this.allPropertyColumns[n5].setProperty(propertyArray[n]);
            if (this.isVisible(propertyArray[n])) {
                ++n2;
                object = propertyArray[n].getValue(ATTR_ORDER_NUMBER);
                if (object != null && object instanceof Integer) {
                    treeMap.put(new Double(((Integer)object).doubleValue()), n5);
                } else {
                    treeMap.put(new Double((double)n5 + 0.1), new Integer(n5));
                }
            } else {
                this.allPropertyColumns[n5].setVisibleIndex(-1);
                object = propertyArray[n].getValue(ATTR_SORTING_COLUMN);
                if (object != null && object instanceof Boolean) {
                    propertyArray[n].setValue(ATTR_SORTING_COLUMN, (Object)Boolean.FALSE);
                }
            }
            if (!this.existsComparableColumn && (object = propertyArray[n].getValue(ATTR_COMPARABLE_COLUMN)) != null && object instanceof Boolean) {
                this.existsComparableColumn = (Boolean)object;
            }
            ++n5;
        }
        this.propertyColumns = new int[n2];
        int n6 = 0;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            n = (Integer)iterator.next();
            this.allPropertyColumns[n].setVisibleIndex(n6);
            this.propertyColumns[n6] = n;
            ++n6;
        }
        this.fireTableStructureChanged();
    }

    private void computeVisiblePorperties(int n) {
        int n2;
        this.propertyColumns = new int[n];
        TreeMap<Double, Integer> treeMap = new TreeMap<Double, Integer>();
        for (n2 = 0; n2 < this.allPropertyColumns.length; ++n2) {
            int n3 = this.allPropertyColumns[n2].getVisibleIndex();
            if (n3 == -1) {
                treeMap.put(new Double((double)n2 - 0.1), n2);
                continue;
            }
            treeMap.put(new Double(n3), n2);
        }
        n2 = 0;
        Iterator iterator = treeMap.values().iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            Node.Property property = this.allPropertyColumns[n4].getProperty();
            if (this.isVisible(property)) {
                this.propertyColumns[n2] = n4;
                this.allPropertyColumns[n4].setVisibleIndex(n2);
                ++n2;
                continue;
            }
            this.allPropertyColumns[n4].setVisibleIndex(-1);
            Object object = property.getValue(ATTR_SORTING_COLUMN);
            if (object == null || !(object instanceof Boolean) || !((Boolean)object).booleanValue()) continue;
            property.setValue(ATTR_SORTING_COLUMN, (Object)Boolean.FALSE);
            property.setValue(ATTR_DESCENDING_ORDER, (Object)Boolean.FALSE);
        }
        this.fireTableStructureChanged();
    }

    int getVisibleColumnWidth(int n) {
        return this.allPropertyColumns[this.propertyColumns[n]].getWidth();
    }

    int getArrayColumnWidth(int n) {
        return this.allPropertyColumns[n].getWidth();
    }

    void setVisibleColumnWidth(int n, int n2) {
        this.allPropertyColumns[this.propertyColumns[n]].setWidth(n2);
    }

    void setArrayColumnWidth(int n, int n2) {
        this.allPropertyColumns[n].setWidth(n2);
    }

    int getVisibleIndex(int n) {
        return this.allPropertyColumns[n].getVisibleIndex();
    }

    int getArrayIndex(int n) {
        for (int i = 0; i < this.allPropertyColumns.length; ++i) {
            if (this.allPropertyColumns[i].getVisibleIndex() != n) continue;
            return i;
        }
        return -1;
    }

    boolean isComparableColumn(int n) {
        return this.isComparableColumnEx(this.propertyColumns[n]);
    }

    boolean isComparableColumnEx(int n) {
        Node.Property property = this.allPropertyColumns[n].getProperty();
        Object object = property.getValue(ATTR_COMPARABLE_COLUMN);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    boolean isVisibleColumnEx(int n) {
        for (int i = 0; i < this.propertyColumns.length; ++i) {
            if (n != this.propertyColumns[i]) continue;
            return true;
        }
        return false;
    }

    boolean existsComparableColumn() {
        return this.existsComparableColumn;
    }

    boolean isSortingColumnEx(int n) {
        Node.Property property = this.allPropertyColumns[n].getProperty();
        Object object = property.getValue(ATTR_SORTING_COLUMN);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    void setSortingColumnEx(int n) {
        Node.Property property;
        if (this.sortColumn != -1) {
            property = this.allPropertyColumns[this.sortColumn].getProperty();
            property.setValue(ATTR_SORTING_COLUMN, (Object)Boolean.FALSE);
            property.setValue(ATTR_DESCENDING_ORDER, (Object)Boolean.FALSE);
        }
        if (n != -1) {
            this.sortColumn = n;
            property = this.allPropertyColumns[this.sortColumn].getProperty();
            property.setValue(ATTR_SORTING_COLUMN, (Object)Boolean.TRUE);
        } else {
            this.sortColumn = -1;
        }
    }

    int translateVisibleColumnIndex(int n) {
        if (n < 0) {
            return n;
        }
        return this.propertyColumns[n];
    }

    int getVisibleSortingColumn() {
        if (this.sortColumn == -1) {
            for (int i = 0; i < this.propertyColumns.length; ++i) {
                if (!this.isSortingColumnEx(this.propertyColumns[i])) continue;
                this.sortColumn = this.propertyColumns[i];
                return i;
            }
        } else if (this.isVisible(this.allPropertyColumns[this.sortColumn].getProperty())) {
            return this.getVisibleIndex(this.sortColumn);
        }
        return -1;
    }

    int getSortingColumn() {
        if (this.sortColumn == -1) {
            for (int i = 0; i < this.allPropertyColumns.length; ++i) {
                if (!this.isSortingColumnEx(i)) continue;
                this.sortColumn = i;
                return i;
            }
        } else {
            return this.sortColumn;
        }
        return -1;
    }

    boolean isSortOrderDescending() {
        if (this.sortColumn == -1) {
            return false;
        }
        Node.Property property = this.allPropertyColumns[this.sortColumn].getProperty();
        Object object = property.getValue(ATTR_DESCENDING_ORDER);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    void setSortOrderDescending(boolean bl) {
        if (this.sortColumn != -1) {
            Node.Property property = this.allPropertyColumns[this.sortColumn].getProperty();
            property.setValue(ATTR_DESCENDING_ORDER, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected Node.Property getPropertyFor(Node node, Node.Property property) {
        Node.PropertySet[] propertySetArray = node.getPropertySets();
        for (int i = 0; i < propertySetArray.length; ++i) {
            Node.Property[] propertyArray = propertySetArray[i].getProperties();
            for (int j = 0; j < propertyArray.length; ++j) {
                if (!property.equals((Object)propertyArray[j])) continue;
                return propertyArray[j];
            }
        }
        return null;
    }

    Node nodeForRow(int n) {
        return this.nodeRows[n];
    }

    Node.Property propertyForColumn(int n) {
        if (n >= 0) {
            n = this.propertyColumns[n];
        }
        return this.propertyForColumnEx(n);
    }

    Node.Property propertyForColumnEx(int n) {
        if (n == -1) {
            return this.treeColumnProperty;
        }
        return this.allPropertyColumns[n].getProperty();
    }

    int getColumnCountEx() {
        return this.allPropertyColumns.length;
    }

    private int rowForNode(Node node) {
        for (int i = 0; i < this.nodeRows.length; ++i) {
            if (!node.equals((Object)this.nodeRows[i])) continue;
            return i;
        }
        return -1;
    }

    private int columnForProperty(String string) {
        for (int i = 0; i < this.propertyColumns.length; ++i) {
            if (!this.allPropertyColumns[this.propertyColumns[i]].getProperty().getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private boolean isVisible(Node.Property property) {
        Object object = property.getValue(ATTR_INVISIBLE);
        if (object != null && object instanceof Boolean) {
            return (Boolean)object == false;
        }
        return true;
    }

    private void setVisible(Node.Property property, boolean bl) {
        property.setValue(ATTR_INVISIBLE, (Object)(!bl ? Boolean.TRUE : Boolean.FALSE));
    }

    @Override
    public int getRowCount() {
        return this.nodeRows.length;
    }

    @Override
    public int getColumnCount() {
        return this.propertyColumns.length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.getPropertyFor(this.nodeRows[n], this.allPropertyColumns[this.propertyColumns[n2]].getProperty());
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.getValueAt(n, n2) != null;
    }

    public Class getColumnClass(int n) {
        return Node.Property.class;
    }

    @Override
    public String getColumnName(int n) {
        return this.getColumnNameEx(this.propertyColumns[n]);
    }

    String getColumnNameEx(int n) {
        return this.allPropertyColumns[n].getProperty().getDisplayName();
    }

    boolean selectVisibleColumns(String string, String string2, String string3) {
        JCheckBox jCheckBox;
        String string4;
        boolean bl = false;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.getAccessibleContext().setAccessibleName(NbBundle.getBundle(NodeTableModel.class).getString("ACSN_ColumnDialog"));
        jPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NodeTableModel.class).getString("ACSD_ColumnDialog"));
        ArrayList<JCheckBox> arrayList = new ArrayList<JCheckBox>(this.allPropertyColumns.length);
        boolean[] blArray = new boolean[this.allPropertyColumns.length];
        int[] nArray = new int[this.allPropertyColumns.length];
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        JLabel jLabel = new JLabel(NbBundle.getBundle(NodeTableModel.class).getString("LBL_ColumnDialogDesc"));
        jPanel.add((Component)jLabel, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        JCheckBox jCheckBox2 = new JCheckBox(string2 + ": " + string3, true);
        jCheckBox2.setEnabled(false);
        jPanel.add((Component)jCheckBox2, gridBagConstraints3);
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        for (int i = 0; i < this.allPropertyColumns.length; ++i) {
            blArray[i] = this.isVisible(this.allPropertyColumns[i].getProperty());
            string4 = this.getDisplayNameWithMnemonic(this.allPropertyColumns[i].getProperty()) + ": " + this.allPropertyColumns[i].getProperty().getShortDescription();
            treeMap.put(string4, i);
        }
        Iterator iterator = treeMap.keySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            string4 = (String)iterator.next();
            int n2 = (Integer)treeMap.get(string4);
            jCheckBox = new JCheckBox(string4, blArray[n2]);
            Mnemonics.setLocalizedText((AbstractButton)jCheckBox, (String)string4);
            this.makeAccessibleCheckBox(jCheckBox, this.allPropertyColumns[n2].getProperty());
            nArray[n] = n2;
            jPanel.add((Component)jCheckBox, gridBagConstraints);
            arrayList.add(jCheckBox);
            ++n;
        }
        String string5 = NbBundle.getMessage(NodeTableModel.class, (String)"LBL_ColumnDialogTitle");
        if (string != null && string.length() > 0) {
            string5 = string + " - " + string5;
        }
        jCheckBox = new DialogDescriptor((Object)jPanel, string5, true, 2, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)jCheckBox);
        dialog.setVisible(true);
        if (jCheckBox.getValue().equals(DialogDescriptor.OK_OPTION)) {
            int n3 = arrayList.size();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                JCheckBox jCheckBox3 = (JCheckBox)arrayList.get(i);
                n = nArray[i];
                if (jCheckBox3.isSelected() != blArray[n]) {
                    this.setVisible(this.allPropertyColumns[n].getProperty(), jCheckBox3.isSelected());
                    bl = true;
                }
                if (!jCheckBox3.isSelected()) continue;
                ++n4;
            }
            if (bl) {
                this.computeVisiblePorperties(n4);
            }
        }
        return bl;
    }

    String getDisplayNameWithMnemonic(Node.Property property) {
        String string = null;
        Object object = property.getValue(ATTR_DISPLAY_NAME_WITH_MNEMONIC);
        string = null != object && object.toString().length() > 0 ? object.toString() : property.getDisplayName();
        return string;
    }

    void makeAccessibleCheckBox(JCheckBox jCheckBox, Node.Property property) {
        jCheckBox.getAccessibleContext().setAccessibleName(property.getDisplayName());
        jCheckBox.getAccessibleContext().setAccessibleDescription(property.getShortDescription());
        Object object = property.getValue(ATTR_MNEMONIC_CHAR);
        if (null != object && object.toString().length() > 0) {
            jCheckBox.setMnemonic(object.toString().charAt(0));
        }
    }

    void moveColumn(int n, int n2) {
        int n3;
        int n4 = this.propertyColumns[n];
        this.propertyColumns[n] = n3 = this.propertyColumns[n2];
        this.propertyColumns[n2] = n4;
        this.allPropertyColumns[n4].setVisibleIndex(n2);
        this.allPropertyColumns[n3].setVisibleIndex(n);
        this.sortColumn = -1;
    }

    static class ArrayColumn {
        private Node.Property property;
        private int width;

        ArrayColumn() {
        }

        public Node.Property getProperty() {
            return this.property;
        }

        public void setProperty(Node.Property property) {
            this.property = property;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int n) {
            this.width = n;
        }

        public int getVisibleIndex() {
            Integer n = (Integer)this.property.getValue(NodeTableModel.ATTR_ORDER_NUMBER);
            if (n == null) {
                return -1;
            }
            return n;
        }

        public void setVisibleIndex(int n) {
            this.property.setValue(NodeTableModel.ATTR_ORDER_NUMBER, (Object)new Integer(n));
        }
    }
}

