/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.sampler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.management.ThreadInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.management.openmbean.CompositeData;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.util.NbBundle;

class SamplesOutputStream {
    private static final String[][] methods = new String[][]{{"sun.management.ThreadInfoCompositeData", "toCompositeData"}, {"com.ibm.lang.management.ManagementUtils", "toThreadInfoCompositeData"}};
    static final String ID = "NPSS";
    static final String FILE_EXT = ".npss";
    static final int RESET_THRESHOLD = 5000;
    static final int STEPS = 1000;
    static byte version = 1;
    private static Method toCompositeDataMethod;
    OutputStream outStream;
    Map<Long, ThreadInfo> lastThreadInfos;
    Map<StackTraceElement, StackTraceElement> steCache;
    List<Sample> samples;
    volatile ProgressHandle progress;

    static boolean isSupported() {
        return toCompositeDataMethod != null;
    }

    SamplesOutputStream(OutputStream outputStream) throws IOException {
        this.outStream = outputStream;
        this.writeHeader(outputStream);
        this.lastThreadInfos = new HashMap<Long, ThreadInfo>();
        this.steCache = new HashMap<StackTraceElement, StackTraceElement>(8192);
        this.samples = new ArrayList<Sample>(1024);
    }

    SamplesOutputStream(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    void writeSample(ThreadInfo[] threadInfoArray, long l, long l2) throws IOException {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<ThreadInfo> arrayList2 = new ArrayList<ThreadInfo>();
        ArrayList<Long> arrayList3 = new ArrayList<Long>();
        for (ThreadInfo threadInfo : threadInfoArray) {
            Object[] objectArray;
            Object[] objectArray2;
            long l3;
            if (threadInfo == null || (l3 = threadInfo.getThreadId()) == l2) continue;
            Long l4 = threadInfo.getThreadId();
            ThreadInfo threadInfo2 = this.lastThreadInfos.get(l4);
            arrayList3.add(l4);
            if (threadInfo2 != null && threadInfo2.getThreadState().equals((Object)threadInfo.getThreadState()) && Arrays.deepEquals(objectArray2 = threadInfo2.getStackTrace(), objectArray = threadInfo.getStackTrace())) {
                arrayList.add(l4);
                continue;
            }
            this.internStackTrace(threadInfo);
            arrayList2.add(threadInfo);
            this.lastThreadInfos.put(l4, threadInfo);
        }
        this.samples.add(new Sample(l, arrayList, arrayList2));
        HashSet<Long> hashSet = new HashSet<Long>(this.lastThreadInfos.keySet());
        hashSet.removeAll(arrayList3);
        this.lastThreadInfos.keySet().removeAll(hashSet);
    }

    private static CompositeData toCompositeData(ThreadInfo threadInfo) {
        try {
            return (CompositeData)toCompositeDataMethod.invoke(null, threadInfo);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    void close() throws IOException {
        this.steCache = null;
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(this.outStream, 65536);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
        int n = this.samples.size();
        this.openProgress();
        for (int i = 0; i < n; ++i) {
            Sample sample = this.samples.get(i);
            this.samples.set(i, null);
            if (i > 0 && i % 5000 == 0) {
                objectOutputStream.reset();
            }
            sample.writeToStream(objectOutputStream);
            if ((i + 40) % 50 != 0) continue;
            this.step(1000 * i / n);
        }
        this.step(1000);
        objectOutputStream.close();
        this.closeProgress();
    }

    private void writeHeader(OutputStream outputStream) throws IOException {
        outputStream.write(ID.getBytes());
        outputStream.write(version);
    }

    private void internStackTrace(ThreadInfo threadInfo) {
        StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            StackTraceElement stackTraceElement2 = this.steCache.get(stackTraceElement);
            if (stackTraceElement2 != null) {
                stackTraceElementArray[i] = stackTraceElement2;
                continue;
            }
            this.steCache.put(stackTraceElement, stackTraceElement);
        }
    }

    private void openProgress() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SamplesOutputStream.this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SamplesOutputStream.class, (String)"Save_Progress"));
                SamplesOutputStream.this.progress.start(1000);
            }
        });
    }

    private void closeProgress() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SamplesOutputStream.this.progress.finish();
                SamplesOutputStream.this.progress = null;
            }
        });
    }

    private void step(int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.progress != null) {
            this.progress.progress(n);
        }
    }

    static {
        for (String[] stringArray : methods) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            try {
                Class<?> clazz = Class.forName(string);
                toCompositeDataMethod = clazz.getMethod(string2, ThreadInfo.class);
                if (toCompositeDataMethod == null) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private static class Sample {
        private final long time;
        private final List<Long> sameThread;
        private final List<ThreadInfo> newThreads;

        Sample(long l, List<Long> list, List<ThreadInfo> list2) {
            this.time = l;
            this.sameThread = list;
            this.newThreads = list2;
        }

        private long getTime() {
            return this.time;
        }

        private List<Long> getSameThread() {
            return this.sameThread;
        }

        private List<ThreadInfo> getNewThreads() {
            return this.newThreads;
        }

        private void writeToStream(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeLong(this.time);
            objectOutputStream.writeInt(this.sameThread.size());
            for (Long object : this.sameThread) {
                objectOutputStream.writeLong(object);
            }
            objectOutputStream.writeInt(this.newThreads.size());
            for (ThreadInfo threadInfo : this.newThreads) {
                objectOutputStream.writeObject(SamplesOutputStream.toCompositeData(threadInfo));
            }
        }
    }
}

