/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

abstract class DefaultParser
extends DefaultHandler {
    protected FileObject fo;
    private Locator locator = null;
    protected short state = 0;
    protected static final short PARSED = 1000;
    protected static final short ERROR = -1;
    protected static final short INIT = 0;

    protected DefaultParser() {
    }

    protected DefaultParser(FileObject fileObject) {
        this.fo = fileObject;
    }

    protected XMLReader createXMLReader() throws IOException, SAXException {
        return XMLUtil.createXMLReader((boolean)false);
    }

    protected boolean isStopException(Exception exception) {
        return false;
    }

    protected short getState() {
        return this.state;
    }

    protected final Locator getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(FileObject fileObject) {
        this.state = 0;
        InputStream inputStream = null;
        this.fo = fileObject;
        try {
            XMLReader xMLReader = this.createXMLReader();
            xMLReader.setEntityResolver(this);
            xMLReader.setErrorHandler(this);
            xMLReader.setContentHandler(this);
            try {
                xMLReader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            InputSource inputSource = new InputSource();
            inputStream = fileObject.getInputStream();
            inputSource.setByteStream(inputStream);
            inputSource.setSystemId(fileObject.getURL().toExternalForm());
            this.customizeInputSource(inputSource);
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            if (!this.isStopException(iOException) && fileObject.isValid() && fileObject.canRead()) {
                Exceptions.attachMessage((Throwable)iOException, (String)("While parsing: " + fileObject));
                Logger.getLogger(DefaultParser.class.getName()).log(Level.INFO, null, iOException);
                this.state = (short)-1;
            }
        }
        catch (SAXException sAXException) {
            if (!this.isStopException(sAXException)) {
                Exceptions.attachMessage((Throwable)sAXException, (String)("While parsing: " + fileObject));
                Logger.getLogger(DefaultParser.class.getName()).log(Level.INFO, null, sAXException);
                this.state = (short)-1;
            }
        }
        catch (NullPointerException nullPointerException) {
            if (!this.isStopException(nullPointerException)) {
                this.state = (short)-1;
                StackTraceElement[] stackTraceElementArray = nullPointerException.getStackTrace();
                if (stackTraceElementArray.length == 0 || !stackTraceElementArray[0].getMethodName().equals("skipChar")) {
                    Exceptions.attachMessage((Throwable)nullPointerException, (String)("While parsing: " + fileObject));
                    Logger.getLogger(DefaultParser.class.getName()).log(Level.INFO, null, nullPointerException);
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void customizeInputSource(InputSource inputSource) {
    }

    protected final void parse() {
        if (this.fo == null) {
            throw new NullPointerException();
        }
        this.parse(this.fo);
    }

    protected void error() throws SAXException {
        String string = NbBundle.getMessage(DefaultParser.class, (String)"Invalid_XML_document");
        this.error(string);
    }

    protected void error(String string) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer(string).append(": ").append(this.fo.toString());
        if (this.locator != null) {
            stringBuffer.append(" line: ").append(this.locator.getLineNumber());
            stringBuffer.append(" column: ").append(this.locator.getColumnNumber());
        }
        String string2 = stringBuffer.toString();
        SAXException sAXException = new SAXException(string2);
        throw sAXException;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void endDocument() throws SAXException {
        this.state = (short)1000;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }
}

