/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.filesystems.declmime;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.filesystems.declmime.DefaultParser;
import org.netbeans.modules.openide.filesystems.declmime.MIMEComponent;
import org.netbeans.modules.openide.filesystems.declmime.Util;
import org.netbeans.modules.openide.filesystems.declmime.XMLMIMEComponent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MIMEResolver;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MIMEResolverImpl {
    private static final Logger ERR = Logger.getLogger(MIMEResolverImpl.class.getName());
    private static final boolean CASE_INSENSITIVE = Utilities.getOperatingSystem() == 16384;
    private static final int READ_LIMIT = 4000;
    private static Set<String> readLimitReported = new HashSet<String>();
    private static final String MIME_RESOLVERS_PATH = "Services/MIMEResolver";
    private static final String USER_DEFINED_MIME_RESOLVER = "user-defined-mime-resolver";
    private static final int USER_DEFINED_MIME_RESOLVER_POSITION = 10;

    public static MIMEResolver forDescriptor(FileObject fileObject) {
        return new Impl(fileObject);
    }

    public static boolean isDeclarative(MIMEResolver mIMEResolver) {
        return mIMEResolver instanceof Impl;
    }

    public static String[] getMIMETypes(MIMEResolver mIMEResolver) {
        ((Impl)mIMEResolver).init();
        return ((Impl)mIMEResolver).implResolvableMIMETypes;
    }

    public static boolean isUserDefined(FileObject fileObject) {
        return fileObject.getAttribute(USER_DEFINED_MIME_RESOLVER) != null;
    }

    public static Map<String, Set<String>> getMIMEToExtensions(FileObject fileObject) {
        if (!fileObject.hasExt("xml")) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        Impl impl = new Impl(fileObject);
        impl.parseDesc();
        FileElement[] fileElementArray = impl.smell;
        if (fileElementArray != null) {
            for (FileElement fileElement : fileElementArray) {
                Object object;
                String string = fileElement.getMimeType();
                if (string == null) continue;
                String[] stringArray = fileElement.getExtensions();
                HashSet<String> hashSet = new HashSet<String>();
                if (stringArray != null) {
                    object = stringArray;
                    int n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = object[i];
                        if (string2.length() <= 0) continue;
                        hashSet.add(string2);
                    }
                }
                if ((object = (Set)hashMap.get(string)) != null) {
                    hashSet.addAll((Collection<String>)object);
                }
                hashMap.put(string, hashSet);
            }
        }
        return hashMap;
    }

    public static FileObject getUserDefinedResolver() {
        FileObject fileObject = FileUtil.getConfigFile(MIME_RESOLVERS_PATH);
        if (fileObject != null) {
            FileObject[] fileObjectArray;
            for (FileObject fileObject2 : fileObjectArray = fileObject.getChildren()) {
                if (fileObject2.getAttribute(USER_DEFINED_MIME_RESOLVER) == null) continue;
                return fileObject2;
            }
        }
        return null;
    }

    public static void storeUserDefinedResolver(final Map<String, Set<String>> map) {
        Parameters.notNull((CharSequence)"mimeToExtensions", map);
        FileObject fileObject = MIMEResolverImpl.getUserDefinedResolver();
        if (fileObject != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                ERR.log(Level.SEVERE, "Cannot delete resolver " + FileUtil.toFile(fileObject), iOException);
                return;
            }
        }
        if (map.isEmpty()) {
            return;
        }
        FileUtil.runAtomicAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object object;
                Object object22222222;
                Document document = XMLUtil.createDocument((String)"MIME-resolver", null, (String)"-//NetBeans//DTD MIME Resolver 1.1//EN", (String)"http://www.netbeans.org/dtds/mime-resolver-1_1.dtd");
                for (Object object22222222 : map.keySet()) {
                    object = (Set)map.get(object22222222);
                    if (object.isEmpty()) continue;
                    Element element = document.createElement("file");
                    for (String string : (Set)map.get(object22222222)) {
                        Element element2 = document.createElement("ext");
                        element2.setAttribute("name", string);
                        element.appendChild(element2);
                    }
                    Element element3 = document.createElement("resolver");
                    element3.setAttribute("mime", (String)object22222222);
                    element.appendChild(element3);
                    document.getDocumentElement().appendChild(element);
                }
                if (!document.getDocumentElement().hasChildNodes()) {
                    return;
                }
                Object object3 = null;
                object22222222 = null;
                object = FileUtil.getConfigFile(MIMEResolverImpl.MIME_RESOLVERS_PATH);
                if (object == null) {
                    object = FileUtil.createFolder(FileUtil.getConfigRoot(), MIMEResolverImpl.MIME_RESOLVERS_PATH);
                }
                object22222222 = ((FileObject)object).createData(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, "xml");
                ((FileObject)object22222222).setAttribute(MIMEResolverImpl.USER_DEFINED_MIME_RESOLVER, Boolean.TRUE);
                ((FileObject)object22222222).setAttribute("position", 10);
                object3 = ((FileObject)object22222222).getOutputStream();
                XMLUtil.write((Document)document, (OutputStream)object3, (String)"UTF-8");
                if (object3 == null) return;
                try {
                    ((OutputStream)object3).close();
                    return;
                }
                catch (IOException iOException) {
                    ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (object22222222 == null ? "" : FileUtil.toFile((FileObject)object22222222)), iOException);
                }
                return;
                catch (IOException iOException) {
                    try {
                        ERR.log(Level.SEVERE, "Cannot write resolver " + (object22222222 == null ? "" : FileUtil.toFile((FileObject)object22222222)), iOException);
                        if (object3 == null) return;
                    }
                    catch (Throwable throwable) {
                        if (object3 == null) throw throwable;
                        try {
                            ((OutputStream)object3).close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {
                            ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (object22222222 == null ? "" : FileUtil.toFile((FileObject)object22222222)), iOException2);
                        }
                        throw throwable;
                    }
                    try {
                        ((OutputStream)object3).close();
                        return;
                    }
                    catch (IOException iOException3) {
                        ERR.log(Level.SEVERE, "Cannot close OutputStream of file " + (object22222222 == null ? "" : FileUtil.toFile((FileObject)object22222222)), iOException3);
                    }
                    return;
                }
            }
        });
    }

    public static Collection<? extends FileObject> getOrderedResolvers() {
        FileObject[] fileObjectArray = FileUtil.getConfigFile(MIME_RESOLVERS_PATH).getChildren();
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (FileObject fileObject : fileObjectArray) {
            Integer n = (Integer)fileObject.getAttribute("position");
            if (n == null) {
                n = Integer.MAX_VALUE;
            }
            while (treeMap.containsKey(n)) {
                Integer n2 = n;
                Integer n3 = n = Integer.valueOf(n - 1);
            }
            treeMap.put(n, fileObject);
        }
        return treeMap.values();
    }

    private static class Type {
        private String[] exts;
        private static final String EMPTY_EXTENSION = "";
        private String[] mimes;
        private String[] fatts;
        private List<FilePattern> patterns;
        private FilePattern lastAddedPattern = null;
        private List<FileName> names;
        private String[] vals;
        private byte[] magic;
        private byte[] mask;
        private boolean exit = false;

        Type() {
        }

        public String toString() {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("fast-check(");
            if (this.exts != null) {
                stringBuffer.append("exts:");
                for (n = 0; n < this.exts.length; ++n) {
                    stringBuffer.append(this.exts[n]).append(", ");
                }
            }
            if (this.mimes != null) {
                stringBuffer.append("mimes:");
                for (n = 0; n < this.mimes.length; ++n) {
                    stringBuffer.append(this.mimes[n]).append(", ");
                }
            }
            if (this.fatts != null) {
                stringBuffer.append("file-attributes:");
                for (n = 0; n < this.fatts.length; ++n) {
                    stringBuffer.append(this.fatts[n]).append("='").append(this.vals[n]).append("', ");
                }
            }
            if (this.patterns != null) {
                stringBuffer.append("patterns:");
                for (FilePattern object : this.patterns) {
                    stringBuffer.append(object.toString()).append(", ");
                }
            }
            if (this.names != null) {
                stringBuffer.append("names:");
                for (FileName fileName : this.names) {
                    stringBuffer.append(fileName.toString()).append(", ");
                }
            }
            if (this.magic != null) {
                stringBuffer.append("magic:").append(XMLUtil.toHex((byte[])this.magic, (int)0, (int)this.magic.length));
            }
            if (this.mask != null) {
                stringBuffer.append("mask:").append(XMLUtil.toHex((byte[])this.mask, (int)0, (int)this.mask.length));
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        private void addExt(String string) {
            this.exts = Util.addString(this.exts, string);
        }

        private void addMIME(String string) {
            this.mimes = Util.addString(this.mimes, string.toLowerCase());
        }

        private void addAttr(String string, String string2) {
            this.fatts = Util.addString(this.fatts, string);
            this.vals = Util.addString(this.vals, string2);
        }

        private void addPattern(String string, int n, boolean bl) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<FilePattern>();
            }
            this.lastAddedPattern = new FilePattern(string, n, bl);
            this.patterns.add(this.lastAddedPattern);
        }

        private void addInnerPattern(String string, int n, boolean bl) {
            FilePattern filePattern = new FilePattern(string, n, bl);
            this.lastAddedPattern.setInner(filePattern);
            this.lastAddedPattern = filePattern;
        }

        private void addName(String string, boolean bl, boolean bl2) {
            if (this.names == null) {
                this.names = new ArrayList<FileName>();
            }
            this.names.add(new FileName(string, bl, bl2));
        }

        private boolean setMagic(byte[] byArray, byte[] byArray2) {
            if (byArray == null) {
                return true;
            }
            if (byArray2 != null && byArray.length != byArray2.length) {
                return false;
            }
            this.magic = byArray;
            if (byArray2 != null) {
                this.mask = byArray2;
                for (int i = 0; i < byArray2.length; ++i) {
                    int n = i;
                    this.magic[n] = (byte)(this.magic[n] & byArray2[i]);
                }
            }
            return true;
        }

        private void setExit() {
            this.exit = true;
        }

        private static String getMIMEType(String string) {
            return FileUtil.getMIMEType(string);
        }

        private static void handleIOException(FileObject fileObject, IOException iOException) throws IOException {
            if (!(!fileObject.canRead() || Utilities.isWindows() && iOException instanceof FileNotFoundException && fileObject.isValid() && fileObject.getName().toLowerCase().contains("ntuser"))) {
                throw iOException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean accept(FileObject fileObject) throws IOException {
            int n;
            int n2;
            Object object;
            if (this.exts != null) {
                String string = fileObject.getExt();
                if (string == null) {
                    string = EMPTY_EXTENSION;
                }
                if (!Util.contains(this.exts, string, CASE_INSENSITIVE)) {
                    return false;
                }
            }
            if (this.mimes != null) {
                boolean bl = false;
                object = Type.getMIMEType(fileObject.getExt());
                if (object == null) {
                    return false;
                }
                n2 = ((String)object).indexOf(59);
                if (n2 >= 0) {
                    object = ((String)object).substring(0, n2);
                }
                object = ((String)object).toLowerCase();
                for (n = this.mimes.length - 1; n >= 0; --n) {
                    if (((String)object).equals(this.mimes[n])) {
                        bl = true;
                        break;
                    }
                    if (this.mimes[n].length() <= 0 || this.mimes[n].charAt(0) != '+' || !((String)object).endsWith(this.mimes[n])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            if (this.magic != null) {
                byte[] byArray = new byte[this.magic.length];
                object = null;
                try {
                    object = fileObject.getInputStream();
                    n2 = ((InputStream)object).read(byArray);
                    if (n2 < 0) {
                        n = 0;
                        return n != 0;
                    }
                }
                catch (IOException iOException) {
                    Type.handleIOException(fileObject, iOException);
                    n = 0;
                    return n != 0;
                }
                finally {
                    try {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                for (n2 = 0; n2 < this.magic.length; ++n2) {
                    if (this.mask != null) {
                        int n3 = n2;
                        byArray[n3] = (byte)(byArray[n3] & this.mask[n2]);
                    }
                    if (this.magic[n2] == byArray[n2]) continue;
                    return false;
                }
            }
            if (this.fatts != null) {
                for (int i = this.fatts.length - 1; i >= 0; --i) {
                    object = fileObject.getAttribute(this.fatts[i]);
                    if (object == null || object.toString().equals(this.vals[i]) || this.vals[i] == null) continue;
                    return false;
                }
            }
            if (this.patterns != null) {
                try {
                    boolean bl = false;
                    for (FilePattern filePattern : this.patterns) {
                        if (!filePattern.match(fileObject)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    Type.handleIOException(fileObject, iOException);
                    return false;
                }
            }
            if (this.names != null) {
                boolean bl = false;
                for (FileName fileName : this.names) {
                    if (!fileName.match(fileObject)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            return true;
        }

        private class FileName {
            private static final boolean DEFAULT_IGNORE_CASE = true;
            private static final boolean DEFAULT_SUBSTRING = false;
            private final String name;
            private final boolean substring;
            private final boolean ignoreCase;

            public FileName(String string, boolean bl, boolean bl2) {
                this.name = bl2 ? string.toLowerCase() : string;
                this.substring = bl;
                this.ignoreCase = bl2;
            }

            public boolean match(FileObject fileObject) {
                String string = fileObject.getNameExt();
                if (this.ignoreCase) {
                    string = string.toLowerCase();
                }
                if (this.substring) {
                    return string.contains(this.name);
                }
                return string.equals(this.name);
            }

            public String toString() {
                return "[" + this.name + ", " + this.substring + ", " + this.ignoreCase + "]";
            }
        }

        private class FilePattern {
            private static final boolean DEFAULT_IGNORE_CASE = false;
            private final String value;
            private final int range;
            private final boolean ignoreCase;
            private FilePattern inner;
            private final byte[] bytes;
            private final int valueLength;

            public FilePattern(String string, int n, boolean bl) {
                this.value = string;
                this.valueLength = string.length();
                this.bytes = bl ? string.toLowerCase().getBytes() : string.getBytes();
                this.range = n;
                this.ignoreCase = bl;
            }

            public void setInner(FilePattern filePattern) {
                this.inner = filePattern;
            }

            private boolean match(byte by, AtomicInteger atomicInteger) {
                if (by == this.bytes[atomicInteger.get()]) {
                    return atomicInteger.incrementAndGet() >= this.valueLength;
                }
                atomicInteger.set(0);
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean match(FileObject fileObject) throws IOException {
                InputStream inputStream = null;
                boolean bl = false;
                try {
                    inputStream = fileObject.getInputStream();
                    byte[] byArray = new byte[this.range];
                    int n = inputStream.read(byArray);
                    AtomicInteger atomicInteger = new AtomicInteger(0);
                    for (int i = 0; i < n; ++i) {
                        byte by = byArray[i];
                        if (this.ignoreCase) {
                            by = (byte)Character.toLowerCase(by);
                        }
                        if (!this.match(by, atomicInteger)) continue;
                        bl = true;
                        break;
                    }
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
                if (bl) {
                    if (this.inner == null) {
                        return true;
                    }
                    return this.inner.match(fileObject);
                }
                return false;
            }

            public String toString() {
                return "[" + this.value + ", " + this.range + ", " + this.ignoreCase + (this.inner != null ? ", " + this.inner : Type.EMPTY_EXTENSION) + "]";
            }
        }
    }

    private static class FileElement {
        private Type fileCheck = new Type();
        private String mime = null;
        private MIMEComponent rule = null;
        private static final String EXIT_MIME_TYPE = "mime-type-to-exit";

        FileElement() {
        }

        private String[] getExtensions() {
            return this.fileCheck.exts;
        }

        private String getMimeType() {
            return this.mime;
        }

        private boolean isExit() {
            return this.fileCheck.exit;
        }

        private void setMIME(String string) {
            if ("null".equals(string)) {
                return;
            }
            this.mime = string;
        }

        private String resolve(FileObject fileObject) {
            try {
                if (this.fileCheck.accept(fileObject)) {
                    if (this.rule != null && !this.rule.acceptFileObject(fileObject)) {
                        return null;
                    }
                    if (this.isExit() || this.mime == null) {
                        return EXIT_MIME_TYPE;
                    }
                    return this.mime;
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(MIMEResolverImpl.class.getName()).log(Level.INFO, null, iOException);
            }
            return null;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("FileElement(");
            stringBuffer.append(this.fileCheck).append(' ');
            stringBuffer.append(this.rule).append(' ');
            stringBuffer.append("Result:").append(this.mime);
            return stringBuffer.toString();
        }
    }

    private static class DescParser
    extends DefaultParser {
        private FileElement[] template = null;
        private short file_state = 0;
        private MIMEComponent component = null;
        private String componentDelimiter = null;
        private int patternLevel = 0;
        Set<Integer> patternLevelSet;
        private static final short IN_ROOT = 1;
        private static final short IN_FILE = 2;
        private static final short IN_RESOLVER = 3;
        private static final short IN_COMPONENT = 4;
        private static final short IN_PATTERN = 5;
        private static final short IN_EXIT = 1;
        private static final String ROOT = "MIME-resolver";
        private static final String FILE = "file";
        private static final String MIME = "mime";
        private static final String EXT = "ext";
        private static final String RESOLVER = "resolver";
        private static final String FATTR = "fattr";
        private static final String NAME = "name";
        private static final String PATTERN = "pattern";
        private static final String VALUE = "value";
        private static final String RANGE = "range";
        private static final String IGNORE_CASE = "ignorecase";
        private static final String SUBSTRING = "substring";
        private static final String MAGIC = "magic";
        private static final String HEX = "hex";
        private static final String MASK = "mask";
        private static final String TEXT = "text";
        private static final String EXIT = "exit";
        private static final String XML_RULE_COMPONENT = "xml-rule";

        DescParser(FileObject fileObject) {
            super(fileObject);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (this.state) {
                case 0: {
                    if (!ROOT.equals(string3)) {
                        this.error();
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (!FILE.equals(string3)) {
                        this.error();
                    }
                    if (this.template == null) {
                        this.template = new FileElement[]{new FileElement()};
                    } else {
                        FileElement[] fileElementArray = new FileElement[this.template.length + 1];
                        System.arraycopy(this.template, 0, fileElementArray, 1, this.template.length);
                        fileElementArray[0] = new FileElement();
                        this.template = fileElementArray;
                    }
                    this.state = (short)2;
                    break;
                }
                case 2: {
                    if (this.file_state == 1) {
                        this.error();
                    }
                    if (EXT.equals(string3)) {
                        String string4 = attributes.getValue(NAME);
                        if (string4 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addExt(string4);
                        break;
                    }
                    if (MAGIC.equals(string3)) {
                        String string5 = attributes.getValue(HEX);
                        if (string5 == null) {
                            this.error();
                        }
                        String string6 = attributes.getValue(MASK);
                        char[] cArray = string5.toCharArray();
                        byte[] byArray = null;
                        try {
                            Object[] objectArray;
                            if (string6 != null) {
                                objectArray = string6.toCharArray();
                                byArray = XMLUtil.fromHex((char[])objectArray, (int)0, (int)objectArray.length);
                            }
                            objectArray = XMLUtil.fromHex((char[])cArray, (int)0, (int)cArray.length);
                            if (this.template[0].fileCheck.setMagic((byte[])objectArray, byArray)) break;
                            this.error();
                        }
                        catch (IOException iOException) {
                            this.error();
                        }
                        break;
                    }
                    if (MIME.equals(string3)) {
                        String string7 = attributes.getValue(NAME);
                        if (string7 == null) {
                            this.error();
                        }
                        this.template[0].fileCheck.addMIME(string7);
                        break;
                    }
                    if (FATTR.equals(string3)) {
                        String string8 = attributes.getValue(NAME);
                        if (string8 == null) {
                            this.error();
                        }
                        String string9 = attributes.getValue(TEXT);
                        this.template[0].fileCheck.addAttr(string8, string9);
                        break;
                    }
                    if (PATTERN.equals(string3)) {
                        String string10 = attributes.getValue(VALUE);
                        if (string10 == null) {
                            this.error();
                        }
                        int n = Integer.valueOf(attributes.getValue(RANGE));
                        assert (n <= 4000 || !readLimitReported.add(this.fo.getPath())) : "MIME resolver " + this.fo.getPath() + " should not exceed " + 4000 + " bytes limit for files content check.";
                        boolean bl = false;
                        String string11 = attributes.getValue(IGNORE_CASE);
                        if (string11 != null) {
                            bl = Boolean.valueOf(string11);
                        }
                        if (this.file_state == 5) {
                            if (this.patternLevelSet == null) {
                                this.patternLevelSet = new HashSet<Integer>();
                            }
                            if (!this.patternLevelSet.add(this.patternLevel)) {
                                this.error("Second pattern element on the same level not allowed");
                            }
                            this.template[0].fileCheck.addInnerPattern(string10, n, bl);
                        } else {
                            this.template[0].fileCheck.addPattern(string10, n, bl);
                            this.file_state = (short)5;
                        }
                        ++this.patternLevel;
                        break;
                    }
                    if (NAME.equals(string3)) {
                        String string12 = attributes.getValue(NAME);
                        if (string12 == null) {
                            this.error();
                        }
                        String string13 = attributes.getValue(SUBSTRING);
                        boolean bl = false;
                        if (string13 != null) {
                            bl = Boolean.valueOf(string13);
                        }
                        boolean bl2 = true;
                        String string14 = attributes.getValue(IGNORE_CASE);
                        if (string14 != null) {
                            bl2 = Boolean.valueOf(string14);
                        }
                        this.template[0].fileCheck.addName(string12, bl, bl2);
                        break;
                    }
                    if (RESOLVER.equals(string3)) {
                        String string15;
                        if (this.template[0].fileCheck.exts == null && this.template[0].fileCheck.mimes == null && this.template[0].fileCheck.fatts == null && this.template[0].fileCheck.patterns == null && this.template[0].fileCheck.names == null && this.template[0].fileCheck.magic == null) {
                            this.error();
                        }
                        if ((string15 = attributes.getValue(MIME)) == null) {
                            this.error();
                        }
                        this.template[0].setMIME(string15);
                        this.state = (short)3;
                        break;
                    }
                    if (EXIT.equals(string3)) {
                        this.template[0].fileCheck.setExit();
                        this.file_state = 1;
                        break;
                    }
                    String string16 = "Unexpected element:  " + string3;
                    this.error(string16);
                    break;
                }
                case 3: {
                    if (!XML_RULE_COMPONENT.equals(string3)) break;
                    this.enterComponent(XML_RULE_COMPONENT, new XMLMIMEComponent());
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
                case 4: {
                    this.component.startElement(string, string2, string3, attributes);
                    break;
                }
            }
        }

        private void enterComponent(String string, MIMEComponent mIMEComponent) {
            this.component = mIMEComponent;
            this.componentDelimiter = string;
            mIMEComponent.setDocumentLocator(this.getLocator());
            this.template[0].rule = mIMEComponent;
            this.state = (short)4;
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.state) {
                case 2: {
                    if (FILE.equals(string3)) {
                        this.state = 1;
                        this.file_state = 0;
                    }
                    if (!PATTERN.equals(string3) || --this.patternLevel != 0) break;
                    this.patternLevelSet = null;
                    this.file_state = 0;
                    break;
                }
                case 3: {
                    if (!RESOLVER.equals(string3)) break;
                    this.state = (short)2;
                    break;
                }
                case 4: {
                    this.component.endElement(string, string2, string3);
                    if (!this.componentDelimiter.equals(string3)) break;
                    this.state = (short)3;
                    this.component.setDocumentLocator(null);
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.state == 4) {
                this.component.characters(cArray, n, n2);
            }
        }
    }

    private static class Impl
    extends MIMEResolver {
        private final FileObject data;
        private final FileChangeListener listener = new FileChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void fileChanged(FileEvent fileEvent) {
                Impl impl = Impl.this;
                synchronized (impl) {
                    Impl.this.state = (short)0;
                    Impl.access$102(Impl.this, null);
                }
            }
        };
        private FileElement[] smell = null;
        private short state = 0;
        private String[] implResolvableMIMETypes = null;

        Impl(FileObject fileObject) {
            if (ERR.isLoggable(Level.FINE)) {
                ERR.fine("MIMEResolverImpl.Impl.<init>(" + fileObject + ")");
            }
            this.data = fileObject;
            this.data.addFileChangeListener(FileUtil.weakFileChangeListener(this.listener, this.data));
        }

        @Override
        public String findMIMEType(FileObject fileObject) {
            if (fileObject.hasExt("xml") && fileObject.getPath().startsWith(MIMEResolverImpl.MIME_RESOLVERS_PATH)) {
                return null;
            }
            this.init();
            if (this.state == -1) {
                return null;
            }
            FileElement[] fileElementArray = this.smell;
            for (int i = fileElementArray.length - 1; i >= 0; --i) {
                String string;
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("findMIMEType - smell.resolve.");
                }
                if ((string = fileElementArray[i].resolve(fileObject)) == null) continue;
                if (string.equals("mime-type-to-exit")) {
                    return null;
                }
                if (ERR.isLoggable(Level.FINE)) {
                    ERR.fine("MIMEResolverImpl.findMIMEType(" + fileObject + ")=" + string);
                }
                return string;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Impl impl = this;
            synchronized (impl) {
                if (this.state == 0) {
                    this.state = this.parseDesc();
                }
            }
        }

        private short parseDesc() {
            this.smell = new FileElement[0];
            DescParser descParser = new DescParser(this.data);
            descParser.parse();
            FileElement[] fileElementArray = this.smell = descParser.template != null ? descParser.template : this.smell;
            if (ERR.isLoggable(Level.FINE)) {
                if (descParser.state == -1) {
                    ERR.fine("MIMEResolverImpl.Impl parsing error!");
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Parse: ");
                    for (int i = 0; i < this.smell.length; ++i) {
                        stringBuffer.append('\n').append(this.smell[i]);
                    }
                    ERR.fine(stringBuffer.toString());
                }
            }
            if (descParser.state != -1) {
                for (int i = 0; i < this.smell.length; ++i) {
                    String string = this.smell[i].getMimeType();
                    if (string == null) continue;
                    this.implResolvableMIMETypes = Util.addString(this.implResolvableMIMETypes, string);
                }
            }
            return descParser.state;
        }

        public String toString() {
            return "MIMEResolverImpl.Impl[" + this.data.getPath() + "]";
        }

        static /* synthetic */ String[] access$102(Impl impl, String[] stringArray) {
            impl.implResolvableMIMETypes = stringArray;
            return stringArray;
        }
    }
}

