/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.WeakSet;

final class StreamPool {
    private static final boolean ANNOTATE_UNCLOSED_STREAMS = Boolean.getBoolean("org.openide.filesystems.annotateUnclosedStreams");
    static final Logger LOG = Logger.getLogger(StreamPool.class.getName());
    private static Map<FileObject, StreamPool> fo2StreamPool = new WeakHashMap<FileObject, StreamPool>();
    private static Map<FileSystem, StreamPool> fs2StreamPool = new WeakHashMap<FileSystem, StreamPool>();
    private Set<InputStream> iStreams;
    private Set<OutputStream> oStreams;

    private StreamPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream createInputStream(final AbstractFolder abstractFolder) throws FileNotFoundException {
        InputStream inputStream = null;
        Object object = StreamPool.class;
        synchronized (StreamPool.class) {
            try {
                StreamPool.get(abstractFolder).waitForOutputStreamsClosed(abstractFolder, 2000);
                inputStream = new NotifyInputStream(abstractFolder);
                StreamPool.get(abstractFolder).iStream().add(inputStream);
                StreamPool.get(abstractFolder.getFileSystem()).iStream().add(inputStream);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, null, interruptedException);
            }
            if (inputStream != null && inputStream instanceof NotifyInputStream) {
                object = (AbstractFileSystem)abstractFolder.getFileSystem();
                ((NotifyInputStream)inputStream).setOriginal(((AbstractFileSystem)object).info.inputStream(abstractFolder.getPath()));
            } else {
                inputStream = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        FileAlreadyLockedException fileAlreadyLockedException = new FileAlreadyLockedException(abstractFolder.getPath());
                        StreamPool.get(abstractFolder).annotate(fileAlreadyLockedException);
                        throw fileAlreadyLockedException;
                    }
                };
            }
            return inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OutputStream createOutputStream(final AbstractFolder abstractFolder, boolean bl) throws IOException {
        OutputStream outputStream = null;
        Object object = StreamPool.class;
        synchronized (StreamPool.class) {
            try {
                StreamPool.get(abstractFolder).waitForInputStreamsClosed(abstractFolder, 2000);
                StreamPool.get(abstractFolder).waitForOutputStreamsClosed(abstractFolder, 2000);
                outputStream = new NotifyOutputStream(abstractFolder, bl);
                StreamPool.get(abstractFolder).oStream().add(outputStream);
                StreamPool.get(abstractFolder.getFileSystem()).oStream().add(outputStream);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, null, interruptedException);
            }
            if (outputStream != null && outputStream instanceof NotifyOutputStream) {
                object = (AbstractFileSystem)abstractFolder.getFileSystem();
                ((NotifyOutputStream)outputStream).setOriginal(((AbstractFileSystem)object).info.outputStream(abstractFolder.getPath()));
            } else {
                outputStream = new OutputStream(){

                    @Override
                    public void write(int n) throws IOException {
                        FileAlreadyLockedException fileAlreadyLockedException = new FileAlreadyLockedException(abstractFolder.getPath());
                        StreamPool.get(abstractFolder).annotate(fileAlreadyLockedException);
                        throw fileAlreadyLockedException;
                    }
                };
            }
            return outputStream;
        }
    }

    public static synchronized StreamPool find(FileObject fileObject) {
        return fo2StreamPool.get(fileObject);
    }

    public static synchronized StreamPool find(FileSystem fileSystem) {
        return fs2StreamPool.get(fileSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Exception exception) {
        if (!ANNOTATE_UNCLOSED_STREAMS) {
            return;
        }
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            Exception exception2;
            if (this.iStreams != null) {
                for (NotifyInputStream closeable : this.iStreams) {
                    exception2 = closeable.getException();
                    if (exception2 == null) continue;
                    ExternalUtil.annotate((Throwable)exception, exception2);
                }
            }
            if (this.oStreams != null) {
                for (NotifyOutputStream notifyOutputStream : this.oStreams) {
                    exception2 = notifyOutputStream.getException();
                    if (exception2 == null) continue;
                    ExternalUtil.annotate((Throwable)exception, exception2);
                }
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    public boolean isInputStreamOpen() {
        return this.iStreams != null && !this.iStreams.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInputStreamsClosed(FileObject fileObject, int n) throws InterruptedException {
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (this.isInputStreamOpen()) {
                StreamPool.class.wait((long)n);
                if (this.isInputStreamOpen()) {
                    throw new InterruptedException(fileObject.getPath());
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForOutputStreamsClosed(FileObject fileObject, int n) throws InterruptedException {
        Class<StreamPool> clazz = StreamPool.class;
        synchronized (StreamPool.class) {
            if (this.isOutputStreamOpen()) {
                StreamPool.class.wait((long)n);
                if (this.isOutputStreamOpen()) {
                    throw new InterruptedException(fileObject.getPath());
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public boolean isOutputStreamOpen() {
        return this.oStreams != null && !this.oStreams.isEmpty();
    }

    private static StreamPool get(FileObject fileObject) {
        StreamPool streamPool = fo2StreamPool.get(fileObject);
        if (streamPool == null) {
            streamPool = new StreamPool();
            fo2StreamPool.put(fileObject, streamPool);
        }
        return streamPool;
    }

    private static StreamPool get(FileSystem fileSystem) {
        StreamPool streamPool = fs2StreamPool.get(fileSystem);
        if (streamPool == null) {
            streamPool = new StreamPool();
            fs2StreamPool.put(fileSystem, streamPool);
        }
        return streamPool;
    }

    private Set<InputStream> iStream() {
        if (this.iStreams == null) {
            this.iStreams = new WeakSet();
        }
        return this.iStreams;
    }

    private Set<OutputStream> oStream() {
        if (this.oStreams == null) {
            this.oStreams = new WeakSet();
        }
        return this.oStreams;
    }

    private static void closeOutputStream(AbstractFolder abstractFolder, OutputStream outputStream, boolean bl) {
        StreamPool streamPool = StreamPool.find(abstractFolder);
        StreamPool streamPool2 = StreamPool.find(abstractFolder.getFileSystem());
        Set<OutputStream> set = streamPool != null ? streamPool.oStreams : null;
        Set<OutputStream> set2 = streamPool2 != null ? streamPool2.oStreams : null;
        StreamPool.removeStreams(set2, set, outputStream);
        StreamPool.removeStreamPools(streamPool2, streamPool, abstractFolder);
        abstractFolder.outputStreamClosed(bl);
    }

    private static void closeInputStream(AbstractFolder abstractFolder, InputStream inputStream) {
        StreamPool streamPool = StreamPool.find(abstractFolder);
        StreamPool streamPool2 = StreamPool.find(abstractFolder.getFileSystem());
        Set<InputStream> set = streamPool != null ? streamPool.iStreams : null;
        Set<InputStream> set2 = streamPool2 != null ? streamPool2.iStreams : null;
        StreamPool.removeStreams(set2, set, inputStream);
        StreamPool.removeStreamPools(streamPool2, streamPool, abstractFolder);
    }

    private static synchronized void removeStreams(Set set, Set set2, Object object) {
        if (set2 != null) {
            set2.remove(object);
        }
        if (set != null) {
            set.remove(object);
        }
    }

    private static synchronized void removeStreamPools(StreamPool streamPool, StreamPool streamPool2, AbstractFolder abstractFolder) {
        boolean bl;
        boolean bl2 = streamPool2 == null || streamPool2.iStreams == null || streamPool2.iStreams.isEmpty();
        boolean bl3 = bl = streamPool2 == null || streamPool2.oStreams == null || streamPool2.oStreams.isEmpty();
        if (bl2 && bl) {
            fo2StreamPool.remove(abstractFolder);
        }
        bl2 = streamPool == null || streamPool.iStreams == null || streamPool.iStreams.isEmpty();
        boolean bl4 = bl = streamPool == null || streamPool.oStreams == null || streamPool.oStreams.isEmpty();
        if (bl2 && bl) {
            fs2StreamPool.remove(abstractFolder.getFileSystem());
        }
    }

    private static final class NotifyInputStream
    extends FilterInputStream {
        private static final InputStream emptyIs = new ByteArrayInputStream(new byte[0]);
        private Exception ex;
        AbstractFolder fo;
        private boolean closed = false;

        public NotifyInputStream(AbstractFolder abstractFolder) {
            super(emptyIs);
            this.fo = abstractFolder;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
        }

        private void setOriginal(InputStream inputStream) {
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            if (this.closed) return;
            this.closed = true;
            this.ex = null;
            super.close();
            StreamPool.closeInputStream(this.fo, this);
            Class<StreamPool> clazz = StreamPool.class;
            synchronized (StreamPool.class) {
                if (StreamPool.get(this.fo).isInputStreamOpen()) return;
                StreamPool.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }

    private static final class NotifyOutputStream
    extends FilterOutputStream {
        private static final OutputStream emptyOs = new ByteArrayOutputStream();
        private Exception ex;
        private boolean closed = false;
        AbstractFolder fo;
        private boolean fireFileChanged;

        public NotifyOutputStream(AbstractFolder abstractFolder, boolean bl) {
            super(emptyOs);
            this.fo = abstractFolder;
            if (ANNOTATE_UNCLOSED_STREAMS) {
                this.ex = new Exception();
            }
            this.fireFileChanged = bl;
        }

        private void setOriginal(OutputStream outputStream) {
            this.out = outputStream;
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void close() throws IOException {
            if (this.closed) return;
            this.closed = true;
            this.ex = null;
            this.out.flush();
            super.close();
            StreamPool.closeOutputStream(this.fo, this, this.fireFileChanged);
            Class<StreamPool> clazz = StreamPool.class;
            synchronized (StreamPool.class) {
                StreamPool.class.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

