/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.kde;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.NbBundle;

public class KWalletProvider
implements KeyringProvider {
    private static final Logger logger = Logger.getLogger(KWalletProvider.class.getName());
    private char[] handler = "0".toCharArray();

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            logger.fine("native keyring integration disabled");
            return false;
        }
        if (new String(this.runCommand("isEnabled", new char[0][])).equals("true")) {
            return this.updateHandler();
        }
        return false;
    }

    public char[] read(String string) {
        if (this.updateHandler()) {
            char[] cArray = this.runCommand("readPassword", this.handler, this.getApplicationName(), string.toCharArray(), this.getApplicationName(true));
            return (char[])(cArray.length > 0 ? cArray : null);
        }
        throw new KwalletException("read");
    }

    public void save(String string, char[] cArray, String string2) {
        if (this.updateHandler()) {
            if (new String(this.runCommand("writePassword", this.handler, this.getApplicationName(), string.toCharArray(), cArray, this.getApplicationName(true))).equals("-1")) {
                throw new KwalletException("save");
            }
            return;
        }
        throw new KwalletException("save");
    }

    public void delete(String string) {
        if (this.updateHandler()) {
            if (new String(this.runCommand("removeEntry", this.handler, this.getApplicationName(), string.toCharArray(), this.getApplicationName(true))).equals("-1")) {
                throw new KwalletException("delete");
            }
            return;
        }
        throw new KwalletException("delete");
    }

    private boolean updateHandler() {
        char[] cArray = this.handler = new String(this.handler).equals("") ? "0".toCharArray() : this.handler;
        if (new String(this.runCommand("isOpen", new char[][]{this.handler})).equals("true")) {
            return true;
        }
        char[] cArray2 = this.runCommand("localWallet", new char[0][]);
        this.handler = this.runCommand("open", cArray2, "0".toCharArray(), this.getApplicationName(true));
        return !new String(this.handler).equals("-1");
    }

    private char[] runCommand(String string, char[] ... cArray) {
        Object[] objectArray = new String[cArray.length + 4];
        objectArray[0] = "qdbus";
        objectArray[1] = "org.kde.kwalletd";
        objectArray[2] = "/modules/kwalletd";
        objectArray[3] = "org.kde.KWallet." + string;
        for (int i = 0; i < cArray.length; ++i) {
            objectArray[i + 4] = new String(cArray[i]);
        }
        Runtime runtime = Runtime.getRuntime();
        String string2 = "";
        try {
            String string3;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "executing {0}", Arrays.toString(objectArray));
            }
            Process process = runtime.exec((String[])objectArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string2.equals("")) {
                    string2 = string2.concat("\n");
                }
                string2 = string2.concat(string3);
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string2.equals("")) {
                    string2 = string2.concat("\n");
                }
                string2 = string2.concat(string3);
            }
            bufferedReader.close();
            int n = process.waitFor();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "application exit with code {0} for commandString: {1}", new Object[]{n, Arrays.toString(objectArray)});
            }
        }
        catch (InterruptedException interruptedException) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(objectArray) + "\"", interruptedException);
        }
        catch (IOException iOException) {
            logger.log(Level.FINE, "exception thrown while invoking the command \"" + Arrays.toString(objectArray) + "\"", iOException);
        }
        return string2.trim().toCharArray();
    }

    private char[] getApplicationName() {
        return this.getApplicationName(false);
    }

    private char[] getApplicationName(boolean bl) {
        String string;
        try {
            string = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.core.windows.view.ui.Bundle").getString("CTL_MainWindow_Title_No_Project"), bl ? System.getProperty("netbeans.buildnumber") : "");
        }
        catch (MissingResourceException missingResourceException) {
            string = "NetBeans" + (bl ? " " + System.getProperty("netbeans.buildnumber") : "");
        }
        return string.toCharArray();
    }

    public class KwalletException
    extends RuntimeException {
        public KwalletException(String string) {
            super("error while trying to access KWallet, during " + string);
        }
    }
}

