/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.mac;

import com.sun.jna.Pointer;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.mac.SecurityLibrary;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.Utilities;

public class MacProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(MacProvider.class.getName());

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        return Utilities.isMac();
    }

    public char[] read(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = "NetBeans".getBytes("UTF-8");
            int[] nArray = new int[1];
            Pointer[] pointerArray = new Pointer[1];
            MacProvider.error("find", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, nArray, pointerArray, null));
            if (pointerArray[0] == null) {
                return null;
            }
            byte[] byArray3 = pointerArray[0].getByteArray(0L, nArray[0]);
            return new String(byArray3, "UTF-8").toCharArray();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, null, unsupportedEncodingException);
            return null;
        }
    }

    public void save(String string, char[] cArray, String string2) {
        this.delete(string);
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = "NetBeans".getBytes("UTF-8");
            byte[] byArray3 = new String(cArray).getBytes("UTF-8");
            MacProvider.error("save", SecurityLibrary.LIBRARY.SecKeychainAddGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, byArray3.length, byArray3, null));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, null, unsupportedEncodingException);
        }
    }

    public void delete(String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = "NetBeans".getBytes("UTF-8");
            Pointer[] pointerArray = new Pointer[1];
            MacProvider.error("find (for delete)", SecurityLibrary.LIBRARY.SecKeychainFindGenericPassword(null, byArray.length, byArray, byArray2.length, byArray2, null, null, pointerArray));
            if (pointerArray[0] != null) {
                MacProvider.error("delete", SecurityLibrary.LIBRARY.SecKeychainItemDelete(pointerArray[0]));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.log(Level.WARNING, null, unsupportedEncodingException);
        }
    }

    private static void error(String string, int n) {
        if (n != 0 && n != -25300) {
            LOG.warning(string + ": " + n);
        }
    }
}

