/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Transparency;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public final class ImageUtilities {
    static final String TOOLTIP_SEPAR = "<br>";
    private static final ActiveRef<String> NO_ICON = new ActiveRef<Object>(null, null, null);
    private static final Map<String, ActiveRef<String>> cache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<String, ActiveRef<String>> localizedCache = new HashMap<String, ActiveRef<String>>(128);
    private static final Map<CompositeImageKey, ActiveRef<CompositeImageKey>> compositeCache = new HashMap<CompositeImageKey, ActiveRef<CompositeImageKey>>(128);
    private static final Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> imageToolTipCache = new HashMap<ToolTipImageKey, ActiveRef<ToolTipImageKey>>(128);
    private static final Set<String> extraInitialSlashes = new HashSet<String>();
    private static volatile Object currentLoader;
    private static Lookup.Result<ClassLoader> loaderQuery;
    private static boolean noLoaderWarned;
    private static final Component component;
    private static final MediaTracker tracker;
    private static int mediaTrackerID;
    private static ImageReader PNG_READER;
    private static final Logger ERR;

    private ImageUtilities() {
    }

    public static final Image loadImage(String string) {
        return ImageUtilities.getIcon(string, false);
    }

    public static final Image loadImage(String string, boolean bl) {
        return ImageUtilities.getIcon(string, bl);
    }

    public static final ImageIcon loadImageIcon(String string, boolean bl) {
        Image image = ImageUtilities.getIcon(string, bl);
        return image == null ? null : (ImageIcon)ImageUtilities.image2Icon(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image mergeImages(Image image, Image image2, int n, int n2) {
        if (image == null || image2 == null) {
            throw new NullPointerException();
        }
        CompositeImageKey compositeImageKey = new CompositeImageKey(image, image2, n, n2);
        Map<CompositeImageKey, ActiveRef<CompositeImageKey>> map = compositeCache;
        synchronized (map) {
            Image image3;
            ActiveRef<CompositeImageKey> activeRef = compositeCache.get(compositeImageKey);
            if (activeRef != null && (image3 = (Image)activeRef.get()) != null) {
                return image3;
            }
            image3 = ImageUtilities.doMergeImages(image, image2, n, n2);
            compositeCache.put(compositeImageKey, new ActiveRef<CompositeImageKey>(image3, compositeCache, compositeImageKey));
            return image3;
        }
    }

    public static final Icon image2Icon(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).getIcon();
        }
        return new ImageIcon(image);
    }

    public static final Image icon2Image(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        ToolTipImage toolTipImage = new ToolTipImage("", icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = toolTipImage.getGraphics();
        icon.paintIcon(new JLabel(), graphics, 0, 0);
        graphics.dispose();
        return toolTipImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Image assignToolTipToImage(Image image, String string) {
        Parameters.notNull("image", image);
        Parameters.notNull("text", string);
        ToolTipImageKey toolTipImageKey = new ToolTipImageKey(image, string);
        Map<ToolTipImageKey, ActiveRef<ToolTipImageKey>> map = imageToolTipCache;
        synchronized (map) {
            Image image2;
            ActiveRef<ToolTipImageKey> activeRef = imageToolTipCache.get(toolTipImageKey);
            if (activeRef != null && (image2 = (Image)activeRef.get()) != null) {
                return image2;
            }
            image2 = ToolTipImage.createNew(string, image);
            imageToolTipCache.put(toolTipImageKey, new ActiveRef<ToolTipImageKey>(image2, imageToolTipCache, toolTipImageKey));
            return image2;
        }
    }

    public static final String getImageToolTip(Image image) {
        if (image instanceof ToolTipImage) {
            return ((ToolTipImage)image).toolTipText;
        }
        return "";
    }

    public static final Image addToolTipToImage(Image image, String string) {
        if (image instanceof ToolTipImage) {
            ToolTipImage toolTipImage = (ToolTipImage)image;
            StringBuilder stringBuilder = new StringBuilder(toolTipImage.toolTipText);
            if (stringBuilder.length() > 0 && string.length() > 0) {
                stringBuilder.append(TOOLTIP_SEPAR);
            }
            stringBuilder.append(string);
            return ImageUtilities.assignToolTipToImage(image, stringBuilder.toString());
        }
        return ImageUtilities.assignToolTipToImage(image, string);
    }

    public static Icon createDisabledIcon(Icon icon) {
        Parameters.notNull("icon", icon);
        return new LazyDisabledIcon(ImageUtilities.icon2Image(icon));
    }

    public static Image createDisabledImage(Image image) {
        Parameters.notNull("image", image);
        return LazyDisabledIcon.createDisabledImage(image);
    }

    static ClassLoader getLoader() {
        Iterator iterator;
        Object object = currentLoader;
        if (object instanceof ClassLoader) {
            return (ClassLoader)object;
        }
        currentLoader = Thread.currentThread();
        if (loaderQuery == null) {
            loaderQuery = Lookup.getDefault().lookup(new Lookup.Template(ClassLoader.class));
            loaderQuery.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent lookupEvent) {
                    ERR.fine("Loader cleared");
                    currentLoader = null;
                }
            });
        }
        if ((iterator = loaderQuery.allInstances().iterator()).hasNext()) {
            ClassLoader classLoader = (ClassLoader)iterator.next();
            if (currentLoader == Thread.currentThread()) {
                currentLoader = classLoader;
            }
            ERR.fine("Loader computed: " + currentLoader);
            return classLoader;
        }
        if (!noLoaderWarned) {
            noLoaderWarned = true;
            ERR.warning("No ClassLoader instance found in " + Lookup.getDefault());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Image getIcon(String string, boolean bl) {
        if (bl) {
            Map<String, ActiveRef<String>> map = localizedCache;
            synchronized (map) {
                String string2;
                String string3;
                ActiveRef<String> activeRef = localizedCache.get(string);
                Image image = null;
                if (activeRef == NO_ICON) {
                    return null;
                }
                if (activeRef != null) {
                    image = (Image)activeRef.get();
                }
                if (image != null) {
                    return image;
                }
                ClassLoader classLoader = ImageUtilities.getLoader();
                int n = (string = new String(string).intern()).lastIndexOf(46);
                if (n != -1 && n > string.lastIndexOf(47)) {
                    string3 = string.substring(0, n);
                    string2 = string.substring(n);
                } else {
                    string3 = string;
                    string2 = "";
                }
                URL uRL = classLoader != null ? classLoader.getResource(string) : ImageUtilities.class.getClassLoader().getResource(string);
                Iterator<String> iterator = NbBundle.getLocalizingSuffixes();
                while (iterator.hasNext()) {
                    String string4 = iterator.next();
                    Image image2 = string4.length() == 0 ? ImageUtilities.getIcon(string, classLoader, false) : ImageUtilities.getIcon(string3 + string4 + string2, classLoader, true);
                    if (image2 == null) continue;
                    localizedCache.put(string, new ActiveRef<String>(image2, localizedCache, string));
                    return image2;
                }
                localizedCache.put(string, NO_ICON);
                return null;
            }
        }
        return ImageUtilities.getIcon(string, ImageUtilities.getLoader(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image getIcon(String string, ClassLoader classLoader, boolean bl) {
        ActiveRef<String> activeRef = cache.get(string);
        Image image = null;
        if (activeRef == NO_ICON) {
            return null;
        }
        if (activeRef != null) {
            image = (Image)activeRef.get();
        }
        if (image != null) {
            return image;
        }
        Map<String, ActiveRef<String>> map = cache;
        synchronized (map) {
            BufferedImage bufferedImage;
            String string2;
            boolean bl2;
            block20: {
                activeRef = cache.get(string);
                if (activeRef == NO_ICON) {
                    return null;
                }
                if (activeRef != null) {
                    image = (Image)activeRef.get();
                }
                if (image != null) {
                    return image;
                }
                if (string.startsWith("/")) {
                    bl2 = true;
                    string2 = string.substring(1);
                } else {
                    bl2 = false;
                    string2 = string;
                }
                URL uRL = classLoader != null ? classLoader.getResource(string2) : ImageUtilities.class.getClassLoader().getResource(string2);
                bufferedImage = null;
                try {
                    if (uRL == null) break block20;
                    if (string.endsWith(".png")) {
                        ImageInputStream imageInputStream = ImageIO.createImageInputStream(uRL.openStream());
                        ImageReadParam imageReadParam = PNG_READER.getDefaultReadParam();
                        try {
                            PNG_READER.setInput(imageInputStream, true, true);
                            bufferedImage = PNG_READER.read(0, imageReadParam);
                        }
                        catch (IOException iOException) {
                            ERR.log(Level.INFO, "Image " + string + " is not PNG", iOException);
                        }
                        imageInputStream.close();
                    }
                    if (bufferedImage == null) {
                        bufferedImage = ImageIO.read(uRL);
                    }
                }
                catch (IOException iOException) {
                    ERR.log(Level.WARNING, "Cannot load " + string + " image", iOException);
                }
            }
            if (bufferedImage != null) {
                if (bl2 && extraInitialSlashes.add(string)) {
                    ERR.warning("Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + string);
                }
                ERR.log(Level.FINE, "loading icon {0} = {1}", new Object[]{string2, bufferedImage});
                string = new String(string).intern();
                bufferedImage = ToolTipImage.createNew("", bufferedImage);
                cache.put(string, new ActiveRef<String>(bufferedImage, cache, string));
                return bufferedImage;
            }
            if (!bl) {
                cache.put(string, NO_ICON);
            }
            return null;
        }
    }

    static final Image toBufferedImage(Image image) {
        new ImageIcon(image, "");
        if (image.getHeight(null) * image.getWidth(null) > 576) {
            return image;
        }
        BufferedImage bufferedImage = ImageUtilities.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLoaded(Image image) {
        if ((Toolkit.getDefaultToolkit().checkImage(image, -1, -1, null) & 0x30) != 0) {
            return;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int n = ++mediaTrackerID;
            tracker.addImage(image, n);
            try {
                tracker.waitForID(n, 0L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("INTERRUPTED while loading Image");
            }
            assert (tracker.statusID(n, false) == 8) : "Image loaded";
            tracker.removeImage(image, n);
        }
    }

    private static final Image doMergeImages(Image image, Image image2, int n, int n2) {
        Object object;
        ImageUtilities.ensureLoaded(image);
        ImageUtilities.ensureLoaded(image2);
        int n3 = Math.max(image.getWidth(null), n + image2.getWidth(null));
        int n4 = Math.max(image.getHeight(null), n2 + image2.getHeight(null));
        boolean bl = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3 && image2 instanceof Transparency && ((Transparency)((Object)image2)).getTransparency() != 3;
        StringBuilder stringBuilder = new StringBuilder(image instanceof ToolTipImage ? ((ToolTipImage)image).toolTipText : "");
        if (image2 instanceof ToolTipImage) {
            object = ((ToolTipImage)image2).toolTipText;
            if (stringBuilder.length() > 0 && ((String)object).length() > 0) {
                stringBuilder.append(TOOLTIP_SEPAR);
            }
            stringBuilder.append((String)object);
        }
        object = ImageUtilities.colorModel(bl ? 2 : 3);
        ToolTipImage toolTipImage = new ToolTipImage(stringBuilder.toString(), (ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(n3, n4), ((ColorModel)object).isAlphaPremultiplied(), null);
        Graphics2D graphics2D = toolTipImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.drawImage(image2, n, n2, null);
        graphics2D.dispose();
        return toolTipImage;
    }

    static final BufferedImage createBufferedImage(int n, int n2) {
        if (Utilities.isMac()) {
            return new BufferedImage(n, n2, 3);
        }
        ColorModel colorModel = ImageUtilities.colorModel(3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    private static ColorModel colorModel(int n) {
        ColorModel colorModel;
        try {
            colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(n);
        }
        catch (HeadlessException headlessException) {
            colorModel = ColorModel.getRGBdefault();
        }
        return colorModel;
    }

    static {
        loaderQuery = null;
        noLoaderWarned = false;
        component = new Component(){};
        tracker = new MediaTracker(component);
        ERR = Logger.getLogger(ImageUtilities.class.getName());
        ImageIO.setUseCache(false);
        PNG_READER = ImageIO.getImageReadersByMIMEType("image/png").next();
    }

    private static class DisabledButtonFilter
    extends RGBImageFilter {
        DisabledButtonFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            return (n3 & 0xFF000000) + 0x888888 + ((n3 >> 16 & 0xFF) >> 2 << 16) + ((n3 >> 8 & 0xFF) >> 2 << 8) + ((n3 & 0xFF) >> 2);
        }

        public void setProperties(Hashtable hashtable) {
            hashtable = (Hashtable)hashtable.clone();
            this.consumer.setProperties(hashtable);
        }
    }

    private static class LazyDisabledIcon
    implements Icon {
        private static final RGBImageFilter DISABLED_BUTTON_FILTER = new DisabledButtonFilter();
        private Image img;
        private Icon disabledIcon;

        public LazyDisabledIcon(Image image) {
            assert (null != image);
            this.img = image;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            this.getDisabledIcon().paintIcon(component, graphics, n, n2);
        }

        @Override
        public int getIconWidth() {
            return this.getDisabledIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getDisabledIcon().getIconHeight();
        }

        private synchronized Icon getDisabledIcon() {
            if (null == this.disabledIcon) {
                this.disabledIcon = new ImageIcon(LazyDisabledIcon.createDisabledImage(this.img));
            }
            return this.disabledIcon;
        }

        static Image createDisabledImage(Image image) {
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), DISABLED_BUTTON_FILTER);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
    }

    private static class ToolTipImage
    extends BufferedImage
    implements Icon {
        final String toolTipText;
        ImageIcon imageIcon;

        public static ToolTipImage createNew(String string, Image image) {
            ImageUtilities.ensureLoaded(image);
            boolean bl = image instanceof Transparency && ((Transparency)((Object)image)).getTransparency() != 3;
            ColorModel colorModel = ImageUtilities.colorModel(bl ? 2 : 3);
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            ToolTipImage toolTipImage = new ToolTipImage(string, colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
            Graphics2D graphics2D = toolTipImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
            graphics2D.dispose();
            return toolTipImage;
        }

        public ToolTipImage(String string, ColorModel colorModel, WritableRaster writableRaster, boolean bl, Hashtable<?, ?> hashtable) {
            super(colorModel, writableRaster, bl, hashtable);
            this.toolTipText = string;
        }

        public ToolTipImage(String string, int n, int n2, int n3, IndexColorModel indexColorModel) {
            super(n, n2, n3, indexColorModel);
            this.toolTipText = string;
        }

        public ToolTipImage(String string, int n, int n2, int n3) {
            super(n, n2, n3);
            this.toolTipText = string;
        }

        public ToolTipImage(String string, BufferedImage bufferedImage) {
            super(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
            this.toolTipText = string;
        }

        synchronized ImageIcon getIcon() {
            if (this.imageIcon == null) {
                this.imageIcon = new ImageIcon(this);
            }
            return this.imageIcon;
        }

        @Override
        public int getIconHeight() {
            return super.getHeight();
        }

        @Override
        public int getIconWidth() {
            return super.getWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawImage(this, n, n2, null);
        }
    }

    private static final class ActiveRef<T>
    extends SoftReference<Image>
    implements Runnable {
        private final Map<T, ActiveRef<T>> holder;
        private final T key;

        public ActiveRef(Image image, Map<T, ActiveRef<T>> map, T t) {
            super(image, Utilities.activeReferenceQueue());
            this.holder = map;
            this.key = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<T, ActiveRef<T>> map = this.holder;
            synchronized (map) {
                this.holder.remove(this.key);
            }
        }
    }

    private static class ToolTipImageKey {
        Image image;
        String str;

        ToolTipImageKey(Image image, String string) {
            this.image = image;
            this.str = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ToolTipImageKey)) {
                return false;
            }
            ToolTipImageKey toolTipImageKey = (ToolTipImageKey)object;
            return this.str.equals(toolTipImageKey.str) && this.image == toolTipImageKey.image;
        }

        public int hashCode() {
            int n = this.image.hashCode() ^ this.str.hashCode();
            return n;
        }

        public String toString() {
            return "ImageStringKey for " + this.image + " + " + this.str;
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image image, Image image2, int n, int n2) {
            this.x = n;
            this.y = n2;
            this.baseImage = image;
            this.overlayImage = image2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey compositeImageKey = (CompositeImageKey)object;
            return this.x == compositeImageKey.x && this.y == compositeImageKey.y && this.baseImage == compositeImageKey.baseImage && this.overlayImage == compositeImageKey.overlayImage;
        }

        public int hashCode() {
            int n = (this.x << 3 ^ this.y) << 4;
            n = n ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return n;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

