/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.Serializable;

public abstract class Union2<First, Second>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;

    Union2() {
    }

    public abstract First first() throws IllegalArgumentException;

    public abstract Second second() throws IllegalArgumentException;

    public abstract boolean hasFirst();

    public abstract boolean hasSecond();

    public abstract Union2<First, Second> clone();

    public static <First, Second> Union2<First, Second> createFirst(First First) {
        return new Union2First(First);
    }

    public static <First, Second> Union2<First, Second> createSecond(Second Second) {
        return new Union2Second(Second);
    }

    private static final class Union2Second<First, Second>
    extends Union2<First, Second> {
        private static final long serialVersionUID = 1L;
        private final Second second;

        public Union2Second(Second Second) {
            this.second = Second;
        }

        @Override
        public First first() throws IllegalArgumentException {
            throw new IllegalArgumentException();
        }

        @Override
        public Second second() throws IllegalArgumentException {
            return this.second;
        }

        @Override
        public boolean hasFirst() {
            return false;
        }

        @Override
        public boolean hasSecond() {
            return true;
        }

        public String toString() {
            return String.valueOf(this.second);
        }

        public boolean equals(Object object) {
            return this.second != null ? object instanceof Union2Second && this.second.equals(((Union2Second)object).second) : object == null;
        }

        public int hashCode() {
            return this.second != null ? this.second.hashCode() : 0;
        }

        @Override
        public Union2<First, Second> clone() {
            return Union2Second.createSecond(this.second);
        }
    }

    private static final class Union2First<First, Second>
    extends Union2<First, Second> {
        private static final long serialVersionUID = 1L;
        private final First first;

        public Union2First(First First) {
            this.first = First;
        }

        @Override
        public First first() throws IllegalArgumentException {
            return this.first;
        }

        @Override
        public Second second() throws IllegalArgumentException {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean hasFirst() {
            return true;
        }

        @Override
        public boolean hasSecond() {
            return false;
        }

        public String toString() {
            return String.valueOf(this.first);
        }

        public boolean equals(Object object) {
            return this.first != null ? object instanceof Union2First && this.first.equals(((Union2First)object).first) : object == null;
        }

        public int hashCode() {
            return this.first != null ? this.first.hashCode() : 0;
        }

        @Override
        public Union2<First, Second> clone() {
            return Union2First.createFirst(this.first);
        }
    }
}

