/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.lib.profiler.global.Platform;

public class ClassBytesLoader {
    private static Map jarCache = new HashMap();

    public static byte[] getClassFileBytes(String string) {
        String string2 = string.replace('.', '/') + ".class";
        URL uRL = ClassLoader.getSystemResource(string2);
        if (uRL == null) {
            if (Platform.getJDKVersionNumber() == 5) {
                return null;
            }
            System.err.println("***Profiler agent warning: could not get .class file for a synthetic class " + string + " in ClassBytesLoader.getClassFileBytes");
            return null;
        }
        String string3 = uRL.getProtocol();
        if (string3 == null) {
            System.err.println("***Profiler agent critical error: could not get .class file for class " + string + " in ClassBytesLoader.getClassFileBytes");
            return null;
        }
        try {
            if (string3.equals("jar")) {
                return ClassBytesLoader.readJar(uRL);
            }
            if (string3.equals("file")) {
                return ClassBytesLoader.readFile(uRL);
            }
            System.err.println("***Profiler agent critical error: Invalid URL " + uRL);
            return null;
        }
        catch (IOException iOException) {
            System.err.println("*** Profiler agent critical error: caught IOException in ClassBytesLoadergetClassFileBytes: " + iOException);
            iOException.printStackTrace();
            System.err.println("*** End Profiler agent critical error message ---------------------------");
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            System.err.println("*** Profiler agent critical error: caught URISyntaxException in ClassBytesLoadergetClassFileBytes: " + uRISyntaxException);
            uRISyntaxException.printStackTrace();
            System.err.println("*** End Profiler agent critical error message ---------------------------");
            return null;
        }
    }

    public static void preloadClasses() {
        ClassBytesLoader.getClassFileBytes("sun.misc.Launcher");
        new FilePermission("*", "read");
        HashMap hashMap = new HashMap();
        hashMap.keySet().iterator();
    }

    private static byte[] readFile(URL uRL) throws IOException, URISyntaxException {
        URI uRI = new URI(uRL.toString());
        File file = new File(uRI);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.readFully(byArray);
        randomAccessFile.close();
        return byArray;
    }

    private static byte[] readJar(URL uRL) throws IOException {
        String string = uRL.getFile();
        int n = string.lastIndexOf(33);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        ZipFile zipFile = (ZipFile)jarCache.get(string2);
        int n2 = 0;
        if (zipFile == null) {
            zipFile = new ZipFile(new File(URI.create(string2)));
            jarCache.put(string2, zipFile);
        }
        ZipEntry zipEntry = zipFile.getEntry(string3);
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        byte[] byArray = new byte[(int)zipEntry.getSize()];
        while (n2 < byArray.length) {
            n2 += inputStream.read(byArray, n2, byArray.length - n2);
        }
        inputStream.close();
        return byArray;
    }
}

