/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import org.netbeans.lib.profiler.server.ProfilerRuntimeCPU;
import org.netbeans.lib.profiler.server.ProfilerServer;

public class ThreadInfo {
    static final int MAX_EVENT_ENTRIES_IN_LOCAL_BUFFER = 500;
    static final int MAX_EVENT_SIZE = 17;
    static int evBufSize;
    static int evBufPosThreshold;
    static Thread[] profilerServerThreads;
    static int nProfilerServerThreads;
    static int nProfiledAppThreads;
    static ThreadInfo dummyThreadInfo;
    private static boolean profilingSuspended;
    private static ThreadInfo[] threadInfos;
    private static int threadInfosSize;
    private static int nThreads;
    private static boolean hasDeadThreads;
    private static ThreadInfo lastThreadInfo;
    Thread thread;
    byte[] evBuf;
    boolean inCallGraph;
    boolean sampleDue;
    int evBufDumpLastPos;
    int evBufPos;
    int inProfilingRuntimeMethod;
    int rootMethodStackDepth;
    int stackDepth;
    int threadId;
    long absEntryTime;
    long lastWaitStartTime;
    long threadEntryTime;
    private boolean initialized;

    private ThreadInfo(Thread thread) {
        this.thread = thread;
        this.inProfilingRuntimeMethod = 1;
        this.threadId = nThreads & 0xFFFF;
    }

    public final boolean isInCallGraph() {
        return this.inCallGraph;
    }

    public final Thread getThread() {
        return this.thread;
    }

    public final int getThreadId() {
        return this.threadId;
    }

    public static boolean isCurrentThreadProfilerServerThread() {
        return ThreadInfo.isProfilerServerThread(Thread.currentThread());
    }

    public static boolean isProfilerServerThread(Thread thread) {
        if (profilerServerThreads == null) {
            return false;
        }
        for (int i = 0; i < nProfilerServerThreads; ++i) {
            if (profilerServerThreads[i] != thread) continue;
            return true;
        }
        return false;
    }

    public static synchronized void addProfilerServerThread(Thread thread) {
        ThreadInfo.profilerServerThreads[ThreadInfo.nProfilerServerThreads++] = thread;
    }

    public static synchronized void clearProfilerServerThreads() {
        if (profilerServerThreads == null) {
            profilerServerThreads = new Thread[10];
        } else {
            for (int i = 0; i < nProfilerServerThreads; ++i) {
                ThreadInfo.profilerServerThreads[i] = null;
            }
            nProfilerServerThreads = 0;
        }
    }

    public static boolean profilingSuspended() {
        return profilingSuspended;
    }

    public static synchronized void removeProfilerServerThread(Thread thread) {
        if (profilerServerThreads == null) {
            return;
        }
        for (int i = 0; i < nProfilerServerThreads; ++i) {
            if (profilerServerThreads[i] != thread) continue;
            if (i == nProfilerServerThreads - 1) {
                ThreadInfo.profilerServerThreads[i] = null;
            } else {
                System.arraycopy(profilerServerThreads, i + 1, profilerServerThreads, i, nProfilerServerThreads - i - 1);
            }
            --nProfilerServerThreads;
            return;
        }
    }

    public static void resumeProfiling() {
        profilingSuspended = false;
    }

    public static void suspendProfiling() {
        profilingSuspended = true;
    }

    static byte[] getCurrentLivenessStatus() {
        ThreadInfo[] threadInfoArray = threadInfos;
        int n = nThreads;
        byte[] byArray = new byte[n];
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null || threadInfo.threadId >= n || threadInfo.thread == null) continue;
            byArray[threadInfo.threadId] = threadInfo.thread.isAlive() ? (byte)1 : 0;
        }
        return byArray;
    }

    static void setDefaultEvBufParams() {
        evBufSize = 8500;
        evBufPosThreshold = evBufSize - 68 - 1;
        threadInfos = new ThreadInfo[1];
        threadInfosSize = 0;
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final void initialize() {
        this.initialize(false);
    }

    final void initialize(boolean bl) {
        ++this.inProfilingRuntimeMethod;
        if (!ThreadInfo.isProfilerServerThread(this.thread)) {
            if (bl && nProfiledAppThreads == 0) {
                ProfilerServer.notifyClientOnResultsAvailability();
            }
            ++nProfiledAppThreads;
        }
        this.resetInternalState();
        this.initialized = true;
        --this.inProfilingRuntimeMethod;
    }

    final void useEventBuffer() {
        this.evBuf = new byte[evBufSize];
    }

    static int getNProfiledAppThreads() {
        return nProfiledAppThreads;
    }

    static void setSampleDueForAllThreads() {
        ThreadInfo[] threadInfoArray = threadInfos;
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null) continue;
            threadInfo.sampleDue = true;
        }
    }

    static ThreadInfo getThreadInfo() {
        Thread thread = Thread.currentThread();
        ThreadInfo threadInfo = lastThreadInfo;
        if (threadInfo.thread == thread) {
            return threadInfo;
        }
        return ThreadInfo.getThreadInfo(thread);
    }

    static ThreadInfo getThreadInfo(Thread thread) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfoOrNull(thread);
        if (threadInfo == null) {
            threadInfo = ThreadInfo.newThreadInfo(thread);
        }
        return threadInfo;
    }

    static ThreadInfo[] getThreadInfos() {
        return threadInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void changeAllThreadsInProfRuntimeMethodStatus(int n) {
        ThreadInfo[] threadInfoArray = threadInfos;
        synchronized (threadInfos) {
            for (int i = 0; i < threadInfos.length; ++i) {
                ThreadInfo threadInfo = threadInfos[i];
                if (!threadInfo.inCallGraph) continue;
                threadInfo.inProfilingRuntimeMethod += n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetThreadInfoTable() {
        ThreadInfo[] threadInfoArray = threadInfos;
        ThreadInfo[] threadInfoArray2 = threadInfos;
        synchronized (threadInfos) {
            nProfiledAppThreads = 0;
            lastThreadInfo = dummyThreadInfo;
            for (int i = 0; i < threadInfoArray.length; ++i) {
                ThreadInfo threadInfo = threadInfoArray[i];
                if (threadInfo == null || threadInfo.thread == null) {
                    threadInfoArray[i] = null;
                    continue;
                }
                threadInfo.initialized = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void setEvBuf(byte[] byArray) {
        this.evBuf = byArray;
        evBufSize = byArray.length;
        evBufPosThreshold = byArray.length - 34 - 1;
    }

    static void releaseDeadThreads() {
        ThreadInfo[] threadInfoArray = threadInfos;
        for (int i = 0; i < threadInfoArray.length; ++i) {
            Thread thread;
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null || (thread = threadInfo.thread) == null || thread.isAlive()) continue;
            if (threadInfo.evBuf != null) {
                if (threadInfo.evBufPos > 0) {
                    ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
                }
                threadInfo.evBuf = null;
            }
            threadInfo.thread = null;
            hasDeadThreads = true;
        }
    }

    private static int getThreadHashCode(Thread thread) {
        return System.identityHashCode(thread) & Integer.MAX_VALUE;
    }

    private static ThreadInfo getThreadInfoOrNull(Thread thread) {
        ThreadInfo threadInfo;
        ThreadInfo[] threadInfoArray = threadInfos;
        int n = threadInfoArray.length;
        int n2 = ThreadInfo.getThreadHashCode(thread) % n;
        while ((threadInfo = threadInfoArray[n2]) != null) {
            if (threadInfo.thread == thread) {
                return threadInfo;
            }
            n2 = (n2 + 1) % n;
        }
        return null;
    }

    private static void addThreadInfo(ThreadInfo threadInfo, Thread thread) {
        if (threadInfosSize >= threadInfos.length * 3 / 4) {
            ThreadInfo.rehash();
        }
        int n = threadInfos.length;
        int n2 = ThreadInfo.getThreadHashCode(thread) % n;
        while (threadInfos[n2] != null) {
            n2 = (n2 + 1) % n;
        }
        ThreadInfo.threadInfos[n2] = threadInfo;
        ++threadInfosSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadInfo newThreadInfo(Thread thread) {
        ThreadInfo[] threadInfoArray = threadInfos;
        synchronized (threadInfos) {
            ThreadInfo threadInfo = ThreadInfo.getThreadInfoOrNull(thread);
            if (threadInfo != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return threadInfo;
            }
            ThreadInfo threadInfo2 = new ThreadInfo(thread);
            ++nThreads;
            ThreadInfo.addThreadInfo(threadInfo2, thread);
            threadInfo2.inProfilingRuntimeMethod = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return threadInfo2;
        }
    }

    private static void rehash() {
        int n = hasDeadThreads ? threadInfos.length : threadInfos.length * 2 + 1;
        ThreadInfo[] threadInfoArray = new ThreadInfo[n];
        int n2 = 0;
        for (int i = 0; i < threadInfos.length; ++i) {
            ThreadInfo threadInfo = threadInfos[i];
            if (threadInfo == null || threadInfo.thread == null) continue;
            int n3 = ThreadInfo.getThreadHashCode(threadInfo.thread) % n;
            while (threadInfoArray[n3] != null) {
                n3 = (n3 + 1) % n;
            }
            threadInfoArray[n3] = threadInfo;
            ++n2;
        }
        threadInfos = threadInfoArray;
        threadInfosSize = n2;
        hasDeadThreads = false;
    }

    private void resetInternalState() {
        this.evBufDumpLastPos = 0;
        this.evBufPos = 0;
        this.threadEntryTime = 0L;
        this.lastWaitStartTime = 0L;
        this.absEntryTime = 0L;
        this.stackDepth = 0;
        this.rootMethodStackDepth = 0;
        this.sampleDue = false;
        this.inCallGraph = false;
        this.evBuf = null;
    }

    static {
        ThreadInfo.setDefaultEvBufParams();
        dummyThreadInfo = new ThreadInfo(null);
        profilingSuspended = false;
        threadInfos = new ThreadInfo[1];
        lastThreadInfo = dummyThreadInfo;
    }
}

