/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.classfile;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassFileCache;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.lib.profiler.classfile.ClassLoaderTable;
import org.netbeans.lib.profiler.classfile.ClassPath;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.classfile.PlaceholderClassInfo;
import org.netbeans.lib.profiler.classfile.SameNameClassGroup;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.utils.FileOrZipEntry;
import org.netbeans.lib.profiler.utils.MiscUtils;

public abstract class ClassRepository
implements CommonConstants {
    static final String LOCATION_VMSUPPLIED = "<VM_SUPPLIED>";
    private static ClassPath classPath;
    private static Hashtable classes;
    private static Set notFoundClasses;
    private static Map definingClassLoaderMap;

    public static List getAllClassVersions(String string) {
        Object v = classes.get(string = string.replace('.', '/').intern());
        if (v != null) {
            ArrayList arrayList = new ArrayList();
            if (v instanceof BaseClassInfo) {
                arrayList.add(v);
            } else {
                arrayList = ((SameNameClassGroup)v).getAll();
            }
            return arrayList;
        }
        return null;
    }

    public static Enumeration getClassEnumerationWithAllVersions() {
        class ClassesEnumeration
        implements Enumeration {
            private Enumeration baseEnum;
            private Object nextElement;
            private List classes;
            private int idx;

            ClassesEnumeration(Enumeration enumeration) {
                this.baseEnum = enumeration;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.nextElement == null) {
                    return this.baseEnum.hasMoreElements();
                }
                return true;
            }

            public Object nextElement() {
                if (this.nextElement != null) {
                    Object object = this.nextElement;
                    ++this.idx;
                    this.nextElement = this.idx == this.classes.size() ? null : this.classes.get(this.idx);
                    return object;
                }
                Object e = this.baseEnum.nextElement();
                if (e instanceof SameNameClassGroup) {
                    SameNameClassGroup sameNameClassGroup = (SameNameClassGroup)e;
                    this.classes = sameNameClassGroup.getAll();
                    e = this.classes.get(0);
                    if (this.classes.size() > 1) {
                        this.idx = 1;
                        this.nextElement = this.classes.get(1);
                    } else {
                        this.classes = null;
                    }
                }
                return e;
            }
        }
        return new ClassesEnumeration(classes.elements());
    }

    public static ClassPath getClassPath() {
        return classPath;
    }

    public static List getClassesOnClasspath(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        arrayList2.addAll(arrayList);
        ArrayList arrayList3 = new ArrayList();
        for (String string : arrayList2) {
            if (!string.endsWith(".jar") && !string.endsWith(".zip")) {
                MiscUtils.getAllClassesInDir(string, "", true, arrayList3);
                continue;
            }
            MiscUtils.getAllClassesInJar(string, true, arrayList3);
        }
        return arrayList3;
    }

    public static CodeRegionBCI getMethodForSourceRegion(ClassInfo classInfo, int n, int n2) throws ClassNotFoundException, IOException, BadLocationException {
        if (n > n2) {
            return null;
        }
        int[] nArray = classInfo.methodIdxAndBestBCIForLineNo(n);
        int n3 = nArray[0];
        if (n3 >= 0) {
            int[] nArray2;
            Object object;
            String string = classInfo.getMethodNames()[n3];
            if ((string == "<init>" || string == "<clinit>") && (object = ClassRepository.getMethodForSourceRegionInNestedClasses(classInfo, n, n2)) != null) {
                return object;
            }
            object = classInfo.getMinAndMaxLinesForMethod(n3);
            if (n2 <= object[1]) {
                ++n2;
            }
            if (n3 != (nArray2 = classInfo.methodIdxAndBestBCIForLineNo(n2))[0]) {
                if (nArray2[0] != -1) {
                    return null;
                }
                nArray2[0] = n3;
                byte[] byArray = classInfo.getMethodBytecode(n3);
                nArray2[1] = ClassInfo.findPreviousBCI(byArray, byArray.length);
            }
            int n4 = nArray[1];
            for (int i = n + 1; i < n2 - 1; ++i) {
                int n5 = classInfo.bciForMethodAndLineNo(n3, i);
                if (n5 >= n4) continue;
                n4 = n5;
            }
            return new CodeRegionBCI(classInfo.getName(), classInfo.getMethodNames()[n3], classInfo.getMethodSignatures()[n3], n4, nArray2[1]);
        }
        if (n3 == -2) {
            throw new BadLocationException("Class does not have source line number tables.\nRecompile it with appropriate options.");
        }
        return ClassRepository.getMethodForSourceRegionInNestedClasses(classInfo, n, n2);
    }

    public static CodeRegionBCI getMethodMinAndMaxBCI(ClassInfo classInfo, String string, String string2) {
        int n = classInfo.getMethodIndex(string = string.intern(), string2 = string2.intern());
        if (n == -1) {
            return null;
        }
        return new CodeRegionBCI(classInfo.getName(), string, string2, 0, classInfo.getMethodBytecode(n).length - 1);
    }

    public static void addPlaceholder(PlaceholderClassInfo placeholderClassInfo) {
        BaseClassInfo baseClassInfo = null;
        SameNameClassGroup sameNameClassGroup = null;
        String string = placeholderClassInfo.getName();
        Object v = classes.get(string);
        if (v != null) {
            if (v instanceof BaseClassInfo) {
                baseClassInfo = (BaseClassInfo)v;
                sameNameClassGroup = new SameNameClassGroup();
                sameNameClassGroup.add(baseClassInfo);
                sameNameClassGroup.add(placeholderClassInfo);
                classes.put(string, sameNameClassGroup);
            } else {
                sameNameClassGroup = (SameNameClassGroup)v;
                sameNameClassGroup.add(placeholderClassInfo);
            }
        } else {
            classes.put(string, placeholderClassInfo);
        }
    }

    public static void addVMSuppliedClassFile(String string, int n, byte[] byArray) {
        string = string.replace('.', '/').intern();
        ClassFileCache.getDefault().addVMSuppliedClassFile(string, n, byArray);
    }

    public static ClassInfo classInfoForFile(File file) throws ClassNotFoundException, IOException, ClassFormatError {
        String string;
        byte[] byArray = MiscUtils.readFileIntoBuffer(new FileOrZipEntry(file));
        ClassInfo classInfo = new ClassInfo(byArray){

            @Override
            protected byte[] getClassFileBytes() {
                return null;
            }
        };
        String string2 = file.getCanonicalPath();
        String string3 = classInfo.getName() + ".class";
        if (!string3.equals(string = string2.substring(string2.length() - string3.length()).replace('\\', '/'))) {
            throw new ClassNotFoundException("Mismatch between name in .class file and location for " + string2 + "\nYour class path setting may be incorrect.");
        }
        return classInfo;
    }

    public static void cleanup() {
        ClassRepository.clearCache();
        if (classPath != null) {
            classPath.close();
            classPath = null;
        }
    }

    public static void clearCache() {
        classes = new Hashtable();
        ClassFileCache.resetDefaultCache();
        notFoundClasses = new HashSet();
        definingClassLoaderMap = new HashMap();
    }

    public static void initClassPaths(String string, String[] stringArray) {
        Object object;
        Comparable<File> comparable;
        List list = MiscUtils.getPathComponents(stringArray[0], true, string);
        List list2 = MiscUtils.getPathComponents(stringArray[2], true, string);
        String string2 = stringArray[1];
        ArrayList arrayList = new ArrayList();
        List list3 = MiscUtils.getPathComponents(string2, true, string);
        Object object2 = list3.iterator();
        while (object2.hasNext()) {
            comparable = new File((String)object2.next());
            object = ((File)comparable).list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return (string = string.toLowerCase()).endsWith(".zip") || string.endsWith(".jar");
                }
            });
            if (object == null) continue;
            for (int i = 0; i < ((String[])object).length; ++i) {
                String string3 = ((File)comparable).getAbsolutePath() + File.separatorChar + (String)object[i];
                List list4 = MiscUtils.getPathComponents(string3, true, string);
                arrayList.addAll(list4);
            }
        }
        object2 = new ArrayList();
        object2.addAll(list2);
        object2.addAll(arrayList);
        object2.addAll(list);
        comparable = new StringBuffer();
        object = object2.iterator();
        while (object.hasNext()) {
            ((StringBuffer)comparable).append((String)object.next());
            if (!object.hasNext()) continue;
            ((StringBuffer)comparable).append(File.pathSeparatorChar);
        }
        classPath = new ClassPath(((StringBuffer)comparable).toString(), true);
        notFoundClasses = new HashSet();
    }

    public static DynamicClassInfo lookupClass(String string, int n) throws IOException, ClassFormatError {
        return ClassRepository.lookupClass(string, n, true);
    }

    public static BaseClassInfo lookupClassOrCreatePlaceholder(String string, int n) {
        BaseClassInfo baseClassInfo = null;
        BaseClassInfo baseClassInfo2 = null;
        SameNameClassGroup sameNameClassGroup = null;
        Object v = classes.get(string = string.replace('.', '/').intern());
        if (v != null) {
            if (v instanceof BaseClassInfo) {
                baseClassInfo = (BaseClassInfo)v;
                baseClassInfo2 = SameNameClassGroup.checkForCompatibility(baseClassInfo, n);
            } else {
                sameNameClassGroup = (SameNameClassGroup)v;
                baseClassInfo2 = sameNameClassGroup.findCompatibleClass(n);
            }
            if (baseClassInfo2 != null) {
                return baseClassInfo2;
            }
            baseClassInfo2 = new PlaceholderClassInfo(string, n);
            if (sameNameClassGroup != null) {
                sameNameClassGroup.add(baseClassInfo2);
            } else {
                sameNameClassGroup = new SameNameClassGroup();
                sameNameClassGroup.add(baseClassInfo);
                sameNameClassGroup.add(baseClassInfo2);
                classes.put(string, sameNameClassGroup);
            }
            return baseClassInfo2;
        }
        baseClassInfo2 = new PlaceholderClassInfo(string, n);
        classes.put(string, baseClassInfo2);
        return baseClassInfo2;
    }

    public static BaseClassInfo lookupLoadedClass(String string, int n, boolean bl) {
        BaseClassInfo baseClassInfo = null;
        BaseClassInfo baseClassInfo2 = null;
        Object v = classes.get(string = string.replace('.', '/').intern());
        if (v != null) {
            if (v instanceof BaseClassInfo) {
                baseClassInfo = (BaseClassInfo)v;
                baseClassInfo2 = SameNameClassGroup.checkForCompatibility(baseClassInfo, n);
            } else {
                SameNameClassGroup sameNameClassGroup = (SameNameClassGroup)v;
                baseClassInfo2 = sameNameClassGroup.findCompatibleClass(n);
            }
            if (baseClassInfo2 != null) {
                if (!(baseClassInfo2 instanceof PlaceholderClassInfo)) {
                    return baseClassInfo2;
                }
                if (bl) {
                    return baseClassInfo2;
                }
            }
        }
        return null;
    }

    public static BaseClassInfo lookupSpecialClass(String string) {
        BaseClassInfo baseClassInfo;
        if (string.indexOf(46) != -1) {
            string = string.replace('.', '/').intern();
        }
        if ((baseClassInfo = (BaseClassInfo)classes.get(string)) == null) {
            baseClassInfo = new BaseClassInfo(string, 0);
            classes.put(string, baseClassInfo);
        }
        return baseClassInfo;
    }

    static int getDefiningClassLoaderId(String string, int n) {
        String string2 = string + "#" + n;
        Integer n2 = (Integer)definingClassLoaderMap.get(string2);
        if (n2 != null) {
            return n2;
        }
        int n3 = -1;
        try {
            n3 = TargetAppRunner.getDefault().getProfilerClient().getDefiningClassLoaderId(string, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        definingClassLoaderMap.put(string2, new Integer(n3));
        return n3;
    }

    private static CodeRegionBCI getMethodForSourceRegionInNestedClasses(ClassInfo classInfo, int n, int n2) throws ClassNotFoundException, IOException, ClassFormatError {
        String string = classInfo.getName();
        String[] stringArray = classInfo.getNestedClassNames();
        int n3 = string.length();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(string) || stringArray[i].length() <= n3) continue;
                try {
                    CodeRegionBCI codeRegionBCI;
                    DynamicClassInfo dynamicClassInfo = ClassRepository.lookupClass(stringArray[i], classInfo.getLoaderId());
                    if (dynamicClassInfo == null || (codeRegionBCI = ClassRepository.getMethodForSourceRegion(dynamicClassInfo, n, n2)) == null) continue;
                    return codeRegionBCI;
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
        }
        return null;
    }

    private static DynamicClassInfo checkForVMSuppliedClass(String string, int n) throws IOException, ClassFormatError {
        int n2 = ClassFileCache.getDefault().hasVMSuppliedClassFile(string, n);
        if (n2 != -1) {
            return new DynamicClassInfo(string, n, LOCATION_VMSUPPLIED + n2);
        }
        return null;
    }

    private static DynamicClassInfo lookupClass(String string, int n, boolean bl) throws IOException, ClassFormatError {
        BaseClassInfo baseClassInfo = null;
        BaseClassInfo baseClassInfo2 = null;
        SameNameClassGroup sameNameClassGroup = null;
        Object v = classes.get(string = string.replace('.', '/').intern());
        if (v != null) {
            if (v instanceof BaseClassInfo) {
                baseClassInfo = (BaseClassInfo)v;
                baseClassInfo2 = SameNameClassGroup.checkForCompatibility(baseClassInfo, n);
            } else {
                sameNameClassGroup = (SameNameClassGroup)v;
                baseClassInfo2 = sameNameClassGroup.findCompatibleClass(n);
            }
            if (baseClassInfo2 != null) {
                if (!(baseClassInfo2 instanceof PlaceholderClassInfo)) {
                    return (DynamicClassInfo)baseClassInfo2;
                }
                PlaceholderClassInfo placeholderClassInfo = (PlaceholderClassInfo)baseClassInfo2;
                DynamicClassInfo dynamicClassInfo = ClassRepository.tryLoadRealClass(string, n, bl);
                if (dynamicClassInfo != null) {
                    placeholderClassInfo.transferDataIntoRealClass(dynamicClassInfo);
                    if (sameNameClassGroup != null) {
                        sameNameClassGroup.replace(placeholderClassInfo, dynamicClassInfo);
                    } else {
                        classes.put(string, dynamicClassInfo);
                    }
                    return dynamicClassInfo;
                }
                return null;
            }
            DynamicClassInfo dynamicClassInfo = ClassRepository.tryLoadRealClass(string, n, bl);
            if (dynamicClassInfo != null) {
                if (sameNameClassGroup != null) {
                    sameNameClassGroup.add(dynamicClassInfo);
                } else {
                    sameNameClassGroup = new SameNameClassGroup();
                    sameNameClassGroup.add(baseClassInfo);
                    sameNameClassGroup.add(dynamicClassInfo);
                    classes.put(string, sameNameClassGroup);
                }
                return dynamicClassInfo;
            }
            return null;
        }
        DynamicClassInfo dynamicClassInfo = ClassRepository.tryLoadRealClass(string, n, bl);
        if (dynamicClassInfo != null) {
            classes.put(string, dynamicClassInfo);
            return dynamicClassInfo;
        }
        return null;
    }

    private static DynamicClassInfo tryLoadRealClass(String string, int n, boolean bl) throws IOException, ClassFormatError {
        DynamicClassInfo dynamicClassInfo = null;
        int n2 = n;
        do {
            if ((dynamicClassInfo = ClassRepository.checkForVMSuppliedClass(string, n2)) != null || n2 != 0 && n2 != -1 || classPath == null) continue;
            dynamicClassInfo = classPath.getClassInfoForClass(string, n2);
        } while (dynamicClassInfo == null && n2 != 0 && (n2 = ClassLoaderTable.getParentLoader(n2)) >= 0);
        if (dynamicClassInfo == null && (n2 = ClassRepository.getDefiningClassLoaderId(string, n)) != -1 && (dynamicClassInfo = ClassRepository.checkForVMSuppliedClass(string, n2)) == null && n2 == 0) {
            dynamicClassInfo = classPath.getClassInfoForClass(string, n2);
        }
        if (dynamicClassInfo == null && bl && !notFoundClasses.contains(string)) {
            MiscUtils.printWarningMessage("class " + string + ", ldr = " + n + " not found anywhere");
            notFoundClasses.add(string);
        }
        return dynamicClassInfo;
    }

    static {
        ClassRepository.clearCache();
    }

    public static class CodeRegionBCI {
        public String className;
        public String methodName;
        public String methodSignature;
        public int bci0;
        public int bci1;

        public CodeRegionBCI(String string, String string2, String string3, int n, int n2) {
            this.className = string;
            this.methodName = string2;
            this.methodSignature = string3;
            this.bci0 = n;
            this.bci1 = n2;
        }

        public String toString() {
            return "CodeRegionBCI [className: " + this.className + ", methodName: " + this.methodName + ", methodSignature: " + this.methodSignature + ", bci0: " + this.bci0 + ", bci1: " + this.bci1 + "]";
        }
    }
}

