/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCallGraphBuilder;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.InstrTimingData;
import org.netbeans.lib.profiler.results.cpu.MethodInfoMapper;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;

public class StackTraceSnapshotBuilder {
    private static final StackTraceElement[] NO_STACK_TRACE = new StackTraceElement[0];
    private static final boolean COLLECT_TWO_TIMESTAMPS = true;
    private static final List<MethodInfo> knownBLockingMethods = Arrays.asList(new MethodInfo("java.net.PlainSocketImpl", "socketAccept[native]"), new MethodInfo("sun.awt.windows.WToolkit", "eventLoop[native]"), new MethodInfo("java.lang.UNIXProcess", "waitForProcessExit[native]"), new MethodInfo("sun.awt.X11.XToolkit", "waitForEvents[native]"), new MethodInfo("apple.awt.CToolkit", "doAWTRunLoop[native]"), new MethodInfo("java.lang.Object", "wait[native]"), new MethodInfo("java.lang.Thread", "sleep[native]"), new MethodInfo("sun.net.dns.ResolverConfigurationImpl", "notifyAddrChange0[native]"));
    private InstrumentationFilter filter;
    final List<Long> threadIds = new ArrayList<Long>();
    final List<String> threadNames = new ArrayList<String>();
    final List<byte[]> threadCompactData = new ArrayList<byte[]>();
    final List<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
    final MethodInfoMapper mapper = new MethodInfoMapper(){

        @Override
        public String getInstrMethodClass(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).className;
        }

        @Override
        public String getInstrMethodName(int n) {
            return StackTraceSnapshotBuilder.this.methodInfos.get((int)n).methodName;
        }

        @Override
        public String getInstrMethodSignature(int n) {
            return "";
        }

        @Override
        public int getMaxMethodId() {
            return StackTraceSnapshotBuilder.this.methodInfos.size();
        }

        @Override
        public int getMinMethodId() {
            return 0;
        }
    };
    final CPUCallGraphBuilder ccgb;
    final Object lock = new Object();
    final Object stampLock = new Object();
    long currentDumpTimeStamp = -1L;
    final AtomicReference<Map<Long, SampledThreadInfo>> lastStackTrace = new AtomicReference<Map>(Collections.EMPTY_MAP);
    int stackTraceCount = 0;
    final Set<String> ignoredThreadNames = new HashSet<String>();
    final Map<Long, Long> threadtimes = new HashMap<Long, Long>();

    public StackTraceSnapshotBuilder() {
        this(1, null);
    }

    public StackTraceSnapshotBuilder(int n, InstrumentationFilter instrumentationFilter) {
        this.filter = instrumentationFilter;
        this.setDefaultTiming();
        this.ccgb = new StackTraceCallGraphBuilder(this.mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIgnoredThreads(Set<String> set) {
        Object object = this.lock;
        synchronized (object) {
            this.ignoredThreadNames.clear();
            this.ignoredThreadNames.addAll(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addStacktrace(ThreadInfo[] threadInfoArray, long l) throws IllegalStateException {
        long l2;
        Object object = this.stampLock;
        synchronized (object) {
            if (l <= this.currentDumpTimeStamp) {
                return;
            }
            l2 = l - this.currentDumpTimeStamp;
            this.currentDumpTimeStamp = l;
        }
        object = this.lock;
        synchronized (object) {
            HashMap<Long, SampledThreadInfo> hashMap = new HashMap<Long, SampledThreadInfo>();
            for (ThreadInfo threadInfo : threadInfoArray) {
                if (threadInfo == null) continue;
                hashMap.put(threadInfo.getThreadId(), new SampledThreadInfo(threadInfo, this.filter));
            }
            for (SampledThreadInfo sampledThreadInfo : hashMap.values()) {
                String string = sampledThreadInfo.getThreadName();
                if (this.ignoredThreadNames.contains(string)) continue;
                long l3 = sampledThreadInfo.getThreadId();
                if (!this.threadIds.contains(l3)) {
                    this.threadIds.add(l3);
                    this.threadNames.add(string);
                    this.ccgb.newThread((int)l3, string, "<none>");
                    this.threadtimes.put(l3, l);
                }
                StackTraceElement[] stackTraceElementArray = sampledThreadInfo.getStackTrace();
                Thread.State state = sampledThreadInfo.getThreadState();
                SampledThreadInfo sampledThreadInfo2 = this.lastStackTrace.get().get(l3);
                StackTraceElement[] stackTraceElementArray2 = NO_STACK_TRACE;
                Thread.State state2 = Thread.State.NEW;
                if (sampledThreadInfo2 != null) {
                    stackTraceElementArray2 = sampledThreadInfo2.getStackTrace();
                    state2 = sampledThreadInfo2.getThreadState();
                }
                this.processDiffs((int)l3, stackTraceElementArray2, stackTraceElementArray, l, l2, state2, state);
            }
            for (SampledThreadInfo sampledThreadInfo : this.lastStackTrace.get().values()) {
                if (this.ignoredThreadNames.contains(sampledThreadInfo.getThreadName()) || hashMap.containsKey(sampledThreadInfo.getThreadId())) continue;
                Thread.State state = sampledThreadInfo.getThreadState();
                Thread.State state3 = Thread.State.TERMINATED;
                this.processDiffs((int)sampledThreadInfo.getThreadId(), sampledThreadInfo.getStackTrace(), NO_STACK_TRACE, l, l2, state, state3);
            }
            this.lastStackTrace.set(hashMap);
            ++this.stackTraceCount;
        }
    }

    private void processDiffs(int n, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l, long l2, Thread.State state, Thread.State state2) throws IllegalStateException {
        if (state2 == Thread.State.NEW) {
            throw new IllegalStateException("Invalid thread state " + Thread.State.NEW.name() + " for taking a stack trace");
        }
        if (state == Thread.State.TERMINATED && state2 != Thread.State.TERMINATED) {
            throw new IllegalStateException("Thread has already been set to " + Thread.State.TERMINATED.name() + " - stack trace can not be taken");
        }
        long l3 = this.threadtimes.get(n);
        if (state == Thread.State.RUNNABLE) {
            this.threadtimes.put(Long.valueOf(n), l3 += l2);
        }
        this.processDiffs(n, stackTraceElementArray, stackTraceElementArray2, l, l3);
    }

    private void processDiffs(int n, StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, long l, long l2) throws IllegalStateException {
        if (stackTraceElementArray.length == 0 && stackTraceElementArray2.length == 0) {
            return;
        }
        int n2 = stackTraceElementArray2.length - 1;
        int n3 = stackTraceElementArray.length - 1;
        int n4 = Math.max(n3, n2);
        List<StackTraceElement> list = Collections.EMPTY_LIST;
        List<StackTraceElement> list2 = Collections.EMPTY_LIST;
        for (int i = 0; i <= n4; ++i) {
            StackTraceElement stackTraceElement;
            StackTraceElement stackTraceElement2 = n3 >= i ? stackTraceElementArray[n3 - i] : null;
            StackTraceElement stackTraceElement3 = stackTraceElement = n2 >= i ? stackTraceElementArray2[n2 - i] : null;
            if (stackTraceElement2 != null && stackTraceElement != null) {
                if (stackTraceElement2.equals(stackTraceElement)) continue;
                if (this.hasSameMethodInfo(stackTraceElement2, stackTraceElement)) {
                    ++i;
                }
                list = Arrays.asList(stackTraceElementArray2).subList(0, n2 - i + 1);
                list2 = Arrays.asList(stackTraceElementArray).subList(0, n3 - i + 1);
                break;
            }
            if (stackTraceElement2 == null && stackTraceElement != null) {
                list = Arrays.asList(stackTraceElementArray2).subList(0, n2 - i + 1);
                break;
            }
            if (stackTraceElement2 == null || stackTraceElement != null) continue;
            list2 = Arrays.asList(stackTraceElementArray).subList(0, n3 - i + 1);
            break;
        }
        this.addMethodExits(n, list2, l, l2, stackTraceElementArray2.length == 0);
        this.addMethodEntries(n, list, l, l2, stackTraceElementArray.length == 0);
    }

    private void addMethodEntries(int n, List<StackTraceElement> list, long l, long l2, boolean bl) throws IllegalStateException {
        boolean bl2 = false;
        ListIterator<StackTraceElement> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            int n2;
            StackTraceElement stackTraceElement = listIterator.previous();
            MethodInfo methodInfo = new MethodInfo(stackTraceElement);
            if (!this.methodInfos.contains(methodInfo)) {
                this.methodInfos.add(methodInfo);
            }
            if ((n2 = this.methodInfos.indexOf(methodInfo)) == -1) {
                System.err.println("*** Not found: " + methodInfo);
                throw new IllegalStateException();
            }
            if (bl && !bl2) {
                bl2 = true;
                this.ccgb.methodEntry(n2, n, 2, l, l2);
                continue;
            }
            this.ccgb.methodEntry(n2, n, 1, l, l2);
        }
    }

    private void addMethodExits(int n, List<StackTraceElement> list, long l, long l2, boolean bl) throws IllegalStateException {
        int n2 = list.size();
        for (StackTraceElement stackTraceElement : list) {
            MethodInfo methodInfo = new MethodInfo(stackTraceElement);
            int n3 = this.methodInfos.indexOf(methodInfo);
            if (n3 == -1) {
                System.err.println("*** Not found: " + methodInfo);
                throw new IllegalStateException();
            }
            if (bl && --n2 == 0) {
                this.ccgb.methodExit(n3, n, 2, l, l2);
                continue;
            }
            this.ccgb.methodExit(n3, n, 1, l, l2);
        }
    }

    private boolean hasSameMethodInfo(StackTraceElement stackTraceElement, StackTraceElement stackTraceElement2) {
        MethodInfo methodInfo = new MethodInfo(stackTraceElement);
        MethodInfo methodInfo2 = new MethodInfo(stackTraceElement2);
        return methodInfo.equals(methodInfo2);
    }

    private void setDefaultTiming() {
        ProfilingSessionStatus profilingSessionStatus = new ProfilingSessionStatus();
        profilingSessionStatus.timerCountsInSecond[0] = InstrTimingData.DEFAULT.timerCountsInSecond0;
        profilingSessionStatus.timerCountsInSecond[1] = InstrTimingData.DEFAULT.timerCountsInSecond1;
        profilingSessionStatus.currentInstrType = 2;
        profilingSessionStatus.absoluteTimerOn = true;
        profilingSessionStatus.threadCPUTimerOn = true;
        TimingAdjusterOld.getInstance(profilingSessionStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CPUResultsSnapshot createSnapshot(long l) throws CPUResultsSnapshot.NoDataAvailableException {
        if (this.stackTraceCount < 1) {
            throw new CPUResultsSnapshot.NoDataAvailableException();
        }
        Object object = this.lock;
        synchronized (object) {
            int n = this.methodInfos.size();
            String[] stringArray = new String[this.methodInfos.size()];
            String[] stringArray2 = new String[this.methodInfos.size()];
            String[] stringArray3 = new String[this.methodInfos.size()];
            int n2 = 0;
            for (MethodInfo methodInfo : this.methodInfos) {
                stringArray[n2] = methodInfo.className;
                stringArray2[n2] = methodInfo.methodName;
                stringArray3[n2] = "";
                ++n2;
            }
            this.addStacktrace(new ThreadInfo[0], this.currentDumpTimeStamp + 1L);
            return new CPUResultsSnapshot(l, System.currentTimeMillis(), this.ccgb, this.ccgb.isCollectingTwoTimeStamps(), stringArray, stringArray2, stringArray3, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.ccgb.reset();
            this.methodInfos.clear();
            this.threadIds.clear();
            this.threadNames.clear();
            this.stackTraceCount = 0;
            this.lastStackTrace.set(Collections.EMPTY_MAP);
            Object object2 = this.stampLock;
            synchronized (object2) {
                this.currentDumpTimeStamp = -1L;
            }
        }
    }

    public MethodInfoMapper getMapper() {
        return this.mapper;
    }

    public RuntimeCCTNode getAppRootNode() {
        return this.ccgb.getAppRootNode();
    }

    public boolean collectionTwoTimeStamps() {
        return true;
    }

    public InstrumentationFilter getFilter() {
        return this.filter;
    }

    private class StackTraceCallGraphBuilder
    extends CPUCallGraphBuilder {
        StackTraceCallGraphBuilder(MethodInfoMapper methodInfoMapper) {
            this.setFactory(new CPUCCTNodeFactory(true));
            this.setFilter(InstrumentationFilter.getDefault());
            this.setMethodInfoMapper(methodInfoMapper);
        }

        @Override
        protected boolean isCollectingTwoTimeStamps() {
            return true;
        }

        @Override
        protected boolean isReady() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected long getDumpAbsTimeStamp() {
            Object object = StackTraceSnapshotBuilder.this.stampLock;
            synchronized (object) {
                return StackTraceSnapshotBuilder.this.currentDumpTimeStamp;
            }
        }
    }

    static class SampledThreadInfo {
        private StackTraceElement[] stackTrace;
        private Thread.State state;
        private ThreadInfo threadInfo;

        SampledThreadInfo(ThreadInfo threadInfo, InstrumentationFilter instrumentationFilter) {
            Thread.State state = threadInfo.getThreadState();
            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
            this.threadInfo = threadInfo;
            if (state == Thread.State.RUNNABLE && SampledThreadInfo.containsKnownBlockingMethod(stackTraceElementArray)) {
                this.state = Thread.State.WAITING;
            }
            if (instrumentationFilter != null) {
                int n;
                for (n = 0; n < stackTraceElementArray.length; ++n) {
                    StackTraceElement stackTraceElement = stackTraceElementArray[n];
                    if (!instrumentationFilter.passesFilter(stackTraceElement.getClassName().replace('.', '/'))) continue;
                    if (n <= 1) break;
                    this.stackTrace = new StackTraceElement[stackTraceElementArray.length - n + 1];
                    System.arraycopy(stackTraceElementArray, n - 1, this.stackTrace, 0, this.stackTrace.length);
                    break;
                }
                if (n == stackTraceElementArray.length) {
                    this.stackTrace = NO_STACK_TRACE;
                }
            }
        }

        private static boolean containsKnownBlockingMethod(StackTraceElement[] stackTraceElementArray) {
            if (stackTraceElementArray.length > 0) {
                MethodInfo methodInfo = new MethodInfo(stackTraceElementArray[0]);
                return knownBLockingMethods.contains(methodInfo);
            }
            return false;
        }

        private StackTraceElement[] getStackTrace() {
            if (this.stackTrace != null) {
                return this.stackTrace;
            }
            return this.threadInfo.getStackTrace();
        }

        Thread.State getThreadState() {
            if (this.state != null) {
                return this.state;
            }
            return this.threadInfo.getThreadState();
        }

        private String getThreadName() {
            return this.threadInfo.getThreadName();
        }

        private long getThreadId() {
            return this.threadInfo.getThreadId();
        }
    }

    static class MethodInfo {
        final String className;
        final String methodName;

        MethodInfo(String string, String string2) {
            this.className = string;
            this.methodName = string2;
        }

        MethodInfo(StackTraceElement stackTraceElement) {
            this.className = stackTraceElement.getClassName();
            this.methodName = stackTraceElement.getMethodName() + (stackTraceElement.isNativeMethod() ? "[native]" : "");
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MethodInfo methodInfo = (MethodInfo)object;
            if (this.className == null ? methodInfo.className != null : !this.className.equals(methodInfo.className)) {
                return false;
            }
            return !(this.methodName == null ? methodInfo.methodName != null : !this.methodName.equals(methodInfo.methodName));
        }

        public int hashCode() {
            int n = 5;
            n = 29 * n + (this.className != null ? this.className.hashCode() : 0);
            n = 29 * n + (this.methodName != null ? this.methodName.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.className + "." + this.methodName + "()";
        }
    }
}

