/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.util.logging.Level;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;

public class MemoryDataFrameProcessor
extends AbstractDataFrameProcessor {
    @Override
    public void doProcessDataFrame(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        int c = -1;
        do {
            byte by = byArray[n++];
            switch (by) {
                case 12: {
                    char c2 = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    long c3 = ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    int n3 = (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Allocation stack trace: classId=" + c2 + ", objSize=" + c3 + ", depth=" + n3);
                    }
                    int[] l2 = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        l2[i] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    }
                    this.fireAllocStackTrace(c2, c3, l2);
                    break;
                }
                case 14: {
                    char c3;
                    char c2 = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    char c4 = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    if (c4 > c3) {
                        c3 = c4;
                    }
                    long l = ((long)c2 & 0xFFFFL) << 48 | ((long)c4 & 0xFFFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    long l2 = ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    int n4 = (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Liveness stack trace: classId=" + c2 + ", objectId=" + l + ", objEpoch=" + c4 + ", objSize=" + l2 + ", depth=" + n4);
                    }
                    int[] nArray = new int[n4];
                    for (int i = 0; i < n4; ++i) {
                        nArray[i] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    }
                    this.fireLivenessStackTrace(c2, l, c4, l2, nArray);
                    break;
                }
                case 15: {
                    char c3;
                    char c2 = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    char c4 = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                    if (c4 > c3) {
                        c3 = c4;
                    }
                    long l = ((long)c2 & 0xFFFFL) << 48 | ((long)c4 & 0xFFFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("GC Performed: classId=" + c2 + ", objectId=" + l + ", objEpoch=" + c4);
                    }
                    this.fireGCPerformed(c2, l, c4);
                    break;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    break;
                }
                case 26: {
                    char c2 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    long c3 = ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | ((long)byArray[n++] & 0xFFL) << 16 | ((long)byArray[n++] & 0xFFL) << 8 | (long)byArray[n++] & 0xFFL;
                    int n3 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    this.fireProfilingPoint(n3, c2, c3);
                    break;
                }
                default: {
                    LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in MemoryDataFrameProcessor: " + by + " at " + n);
                }
            }
        } while (n < n2);
    }

    private void fireAllocStackTrace(final char c, final long l, final int[] nArray) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                try {
                    ((MemoryProfilingResultsListener)profilingResultListener).onAllocStackTrace(c, l, nArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private void fireGCPerformed(final char c, final long l, final int n) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((MemoryProfilingResultsListener)profilingResultListener).onGcPerformed(c, l, n);
            }
        });
    }

    private void fireLivenessStackTrace(final char c, final long l, final int n, final long l2, final int[] nArray) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener profilingResultListener) {
                ((MemoryProfilingResultsListener)profilingResultListener).onLivenessStackTrace(c, l, n, l2, nArray);
            }
        });
    }
}

