/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Color;
import java.awt.Font;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;

class GTKDefaultStyle
extends GTKStyle {
    private static final int DEFAULT_XTHICKNESS = 2;
    private static final int DEFAULT_YTHICKNESS = 2;
    private static final Color[][] DEFAULT_COLORS;
    private static final int[] DEFAULT_COLOR_MAP;

    GTKDefaultStyle(Font font) {
        super(font);
    }

    Color getStyleSpecificColor(SynthContext synthContext, int n, ColorType colorType) {
        Region region = synthContext != null ? synthContext.getRegion() : null;
        Color color = null;
        if (region == Region.TOOL_TIP) {
            color = this.getToolTipColor(n, colorType);
        } else if (region == Region.PROGRESS_BAR && GTKLookAndFeel.is2_2()) {
            color = this.getProgressBarColor(n, colorType);
        } else if ((region == Region.MENU || region == Region.MENU_ITEM || region == Region.POPUP_MENU_SEPARATOR || region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.MENU_ITEM_ACCELERATOR) && GTKLookAndFeel.is2_2()) {
            color = this.getMenuItemColor(n, colorType);
        }
        if (color != null) {
            return color;
        }
        for (int i = DEFAULT_COLOR_MAP.length - 1; i >= 0; --i) {
            if ((DEFAULT_COLOR_MAP[i] & n) == 0 || colorType.getID() >= DEFAULT_COLORS[i].length) continue;
            return DEFAULT_COLORS[i][colorType.getID()];
        }
        if (colorType.getID() < DEFAULT_COLORS[2].length) {
            return DEFAULT_COLORS[2][colorType.getID()];
        }
        return null;
    }

    private Color getToolTipColor(int n, ColorType colorType) {
        if (n == 1) {
            if (colorType == GTKColorType.BACKGROUND) {
                return GTKLookAndFeel.is2_2() ? new ColorUIResource(15655347) : new ColorUIResource(0xFFFFC0);
            }
            if (colorType == GTKColorType.FOREGROUND) {
                return new ColorUIResource(0);
            }
        }
        return null;
    }

    private Color getProgressBarColor(int n, ColorType colorType) {
        if (n == 1) {
            if (colorType == GTKColorType.BACKGROUND) {
                return new ColorUIResource(0xBAB5AB);
            }
        } else if (n == 2 && colorType == GTKColorType.BACKGROUND) {
            return new ColorUIResource(4942211);
        }
        return null;
    }

    private Color getMenuItemColor(int n, ColorType colorType) {
        if (n == 512) {
            if (colorType == GTKColorType.TEXT_FOREGROUND || colorType == GTKColorType.FOREGROUND) {
                return new ColorUIResource(0xFFFFFF);
            }
        } else if (n == 2) {
            if (colorType == GTKColorType.BACKGROUND) {
                return new ColorUIResource(10336466);
            }
            if (colorType == GTKColorType.FOREGROUND) {
                return GTKStyle.WHITE_COLOR;
            }
            if (colorType == GTKColorType.TEXT_FOREGROUND) {
                return new ColorUIResource(0xFFFFFF);
            }
        }
        return null;
    }

    int getXThickness() {
        return 2;
    }

    int getYThickness() {
        return 2;
    }

    Object getClassSpecificValue(Region region, String string) {
        return null;
    }

    private static Color[] getColorsFrom(Color color, Color color2) {
        Color color3 = GTKDefaultStyle.calculateLightColor(color);
        Color color4 = GTKDefaultStyle.calculateDarkColor(color);
        Color color5 = GTKDefaultStyle.calculateMidColor(color3, color4);
        Color[] colorArray = new Color[GTKColorType.MAX_COUNT];
        colorArray[GTKColorType.BACKGROUND.getID()] = color;
        colorArray[GTKColorType.LIGHT.getID()] = color3;
        colorArray[GTKColorType.DARK.getID()] = color4;
        colorArray[GTKColorType.MID.getID()] = color5;
        colorArray[GTKColorType.BLACK.getID()] = BLACK_COLOR;
        colorArray[GTKColorType.WHITE.getID()] = WHITE_COLOR;
        colorArray[GTKColorType.FOCUS.getID()] = BLACK_COLOR;
        colorArray[GTKColorType.FOREGROUND.getID()] = color2;
        colorArray[GTKColorType.TEXT_FOREGROUND.getID()] = color2;
        colorArray[GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
        return colorArray;
    }

    private static Color calculateLightColor(Color color) {
        return GTKColorType.adjustColor(color, 1.0f, 1.3f, 1.3f);
    }

    private static Color calculateDarkColor(Color color) {
        return GTKColorType.adjustColor(color, 1.0f, 0.7f, 0.7f);
    }

    private static Color calculateMidColor(Color color, Color color2) {
        int n = color.getRGB();
        int n2 = color2.getRGB();
        int n3 = (n & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF0000) >> 16;
        int n5 = (n & 0xFF00) >> 8;
        int n6 = (n2 & 0xFF00) >> 8;
        int n7 = n & 0xFF;
        int n8 = n2 & 0xFF;
        return new ColorUIResource((n3 + n4) / 2 << 16 | (n5 + n6) / 2 << 8 | (n7 + n8) / 2);
    }

    static {
        DEFAULT_COLOR_MAP = new int[]{4, 512, 1, 2, 8};
        DEFAULT_COLORS = new Color[5][];
        if (!GTKLookAndFeel.is2_2()) {
            GTKDefaultStyle.DEFAULT_COLORS[0] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(195, 195, 195), BLACK_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[1] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(0, 0, 156), WHITE_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[2] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(214, 214, 214), BLACK_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[3] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(233, 233, 233), BLACK_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[4] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(214, 214, 214), new ColorUIResource(117, 117, 117));
            GTKDefaultStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(188, 210, 238);
            GTKDefaultStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(164, 223, 255);
            GTKDefaultStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_FOREGROUND.getID()] = DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()];
        } else {
            GTKDefaultStyle.DEFAULT_COLORS[0] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(186, 181, 171), BLACK_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[1] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(75, 105, 131), WHITE_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[2] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(220, 218, 213), BLACK_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[3] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(238, 235, 231), BLACK_COLOR);
            GTKDefaultStyle.DEFAULT_COLORS[4] = GTKDefaultStyle.getColorsFrom(new ColorUIResource(220, 218, 213), new ColorUIResource(117, 117, 117));
            GTKDefaultStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(128, 125, 116);
            GTKDefaultStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(75, 105, 131);
            GTKDefaultStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[3][GTKColorType.TEXT_BACKGROUND.getID()] = WHITE_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_BACKGROUND.getID()] = new ColorUIResource(238, 235, 231);
            GTKDefaultStyle.DEFAULT_COLORS[0][GTKColorType.TEXT_FOREGROUND.getID()] = WHITE_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[1][GTKColorType.TEXT_FOREGROUND.getID()] = WHITE_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[2][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[3][GTKColorType.TEXT_FOREGROUND.getID()] = BLACK_COLOR;
            GTKDefaultStyle.DEFAULT_COLORS[4][GTKColorType.TEXT_FOREGROUND.getID()] = new ColorUIResource(117, 117, 117);
        }
    }
}

