/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -4856846361193249489L;
    private final long mostSigBits;
    private final long leastSigBits;
    private transient int version = -1;
    private transient int variant = -1;
    private volatile transient long timestamp = -1L;
    private transient int sequence = -1;
    private transient long node = -1L;
    private transient int hashCode = -1;

    private UUID(byte[] byArray) {
        int n;
        long l = 0L;
        long l2 = 0L;
        assert (byArray.length == 16);
        for (n = 0; n < 8; ++n) {
            l = l << 8 | (long)(byArray[n] & 0xFF);
        }
        for (n = 8; n < 16; ++n) {
            l2 = l2 << 8 | (long)(byArray[n] & 0xFF);
        }
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public UUID(long l, long l2) {
        this.mostSigBits = l;
        this.leastSigBits = l2;
    }

    public static UUID randomUUID() {
        SecureRandom secureRandom = Holder.numberGenerator;
        byte[] byArray = new byte[16];
        secureRandom.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0x80);
        return new UUID(byArray);
    }

    public static UUID nameUUIDFromBytes(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("MD5 not supported");
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        byArray2[6] = (byte)(byArray2[6] & 0xF);
        byArray2[6] = (byte)(byArray2[6] | 0x30);
        byArray2[8] = (byte)(byArray2[8] & 0x3F);
        byArray2[8] = (byte)(byArray2[8] | 0x80);
        return new UUID(byArray2);
    }

    public static UUID fromString(String string) {
        String[] stringArray = string.split("-");
        if (stringArray.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + string);
        }
        for (int i = 0; i < 5; ++i) {
            stringArray[i] = "0x" + stringArray[i];
        }
        long l = Long.decode(stringArray[0]);
        l <<= 16;
        l |= Long.decode(stringArray[1]).longValue();
        l <<= 16;
        long l2 = Long.decode(stringArray[3]);
        l2 <<= 48;
        return new UUID(l |= Long.decode(stringArray[2]).longValue(), l2 |= Long.decode(stringArray[4]).longValue());
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        if (this.version < 0) {
            this.version = (int)(this.mostSigBits >> 12 & 0xFL);
        }
        return this.version;
    }

    public int variant() {
        if (this.variant < 0) {
            this.variant = this.leastSigBits >>> 63 == 0L ? 0 : (this.leastSigBits >>> 62 == 2L ? 2 : (int)(this.leastSigBits >>> 61));
        }
        return this.variant;
    }

    public long timestamp() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        long l = this.timestamp;
        if (l < 0L) {
            l = (this.mostSigBits & 0xFFFL) << 48;
            l |= (this.mostSigBits >> 16 & 0xFFFFL) << 32;
            this.timestamp = l |= this.mostSigBits >>> 32;
        }
        return l;
    }

    public int clockSequence() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        if (this.sequence < 0) {
            this.sequence = (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
        }
        return this.sequence;
    }

    public long node() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
        if (this.node < 0L) {
            this.node = this.leastSigBits & 0xFFFFFFFFFFFFL;
        }
        return this.node;
    }

    public String toString() {
        return UUID.digits(this.mostSigBits >> 32, 8) + "-" + UUID.digits(this.mostSigBits >> 16, 4) + "-" + UUID.digits(this.mostSigBits, 4) + "-" + UUID.digits(this.leastSigBits >> 48, 4) + "-" + UUID.digits(this.leastSigBits, 12);
    }

    private static String digits(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = (int)(this.mostSigBits >> 32 ^ this.mostSigBits ^ this.leastSigBits >> 32 ^ this.leastSigBits);
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UUID)) {
            return false;
        }
        if (((UUID)object).variant() != this.variant()) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.mostSigBits == uUID.mostSigBits && this.leastSigBits == uUID.leastSigBits;
    }

    @Override
    public int compareTo(UUID uUID) {
        return this.mostSigBits < uUID.mostSigBits ? -1 : (this.mostSigBits > uUID.mostSigBits ? 1 : (this.leastSigBits < uUID.leastSigBits ? -1 : (this.leastSigBits > uUID.leastSigBits ? 1 : 0)));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.version = -1;
        this.variant = -1;
        this.timestamp = -1L;
        this.sequence = -1;
        this.node = -1L;
        this.hashCode = -1;
    }

    private static class Holder {
        static final SecureRandom numberGenerator = new SecureRandom();

        private Holder() {
        }
    }
}

