/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class BranchInstruction
extends Instruction
implements InstructionTargeter {
    protected int index;
    protected InstructionHandle target;
    protected int position;

    BranchInstruction() {
    }

    protected BranchInstruction(short s, InstructionHandle instructionHandle) {
        super(s, (short)3);
        this.setTarget(instructionHandle);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.opcode);
        this.index = this.getTargetOffset();
        if (Math.abs(this.index) >= Short.MAX_VALUE) {
            throw new ClassGenException("Branch target offset too large for short");
        }
        dataOutputStream.writeShort(this.index);
    }

    protected int getTargetOffset(InstructionHandle instructionHandle) {
        if (instructionHandle == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int n = instructionHandle.getPosition();
        if (n < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + n + ":" + instructionHandle);
        }
        return n - this.position;
    }

    protected int getTargetOffset() {
        return this.getTargetOffset(this.target);
    }

    protected int updatePosition(int n, int n2) {
        this.position += n;
        return 0;
    }

    @Override
    public String toString(boolean bl) {
        String string = super.toString(bl);
        String string2 = "null";
        if (bl) {
            if (this.target != null) {
                string2 = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : this.target.getInstruction().toString(false));
            }
        } else if (this.target != null) {
            this.index = this.getTargetOffset();
            string2 = "" + (this.index + this.position);
        }
        return string + " -> " + string2;
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.length = (short)3;
        this.index = byteSequence.readShort();
    }

    public final int getIndex() {
        return this.index;
    }

    public InstructionHandle getTarget() {
        return this.target;
    }

    public final void setTarget(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTargetChanging(this.target, this);
        this.target = instructionHandle;
        BranchInstruction.notifyTargetChanged(this.target, this);
    }

    static void notifyTargetChanging(InstructionHandle instructionHandle, InstructionTargeter instructionTargeter) {
        if (instructionHandle != null) {
            instructionHandle.removeTargeter(instructionTargeter);
        }
    }

    static void notifyTargetChanged(InstructionHandle instructionHandle, InstructionTargeter instructionTargeter) {
        if (instructionHandle != null) {
            instructionHandle.addTargeter(instructionTargeter);
        }
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        if (this.target != instructionHandle) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but " + this.target);
        }
        this.setTarget(instructionHandle2);
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.target == instructionHandle;
    }

    @Override
    void dispose() {
        this.setTarget(null);
        this.index = -1;
        this.position = -1;
    }
}

