/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing.policy;

import com.sun.xml.internal.ws.addressing.W3CAddressingMetadataConstants;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.policy.AssertionSet;
import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.PolicyMap;
import com.sun.xml.internal.ws.policy.PolicySubject;
import com.sun.xml.internal.ws.policy.jaxws.spi.PolicyMapConfigurator;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.internal.ws.policy.subject.WsdlBindingSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.soap.AddressingFeature;

public class AddressingPolicyMapConfigurator
implements PolicyMapConfigurator {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AddressingPolicyMapConfigurator.class);

    @Override
    public Collection<PolicySubject> update(PolicyMap policyMap, SEIModel sEIModel, WSBinding wSBinding) throws PolicyException {
        LOGGER.entering(policyMap, sEIModel, wSBinding);
        ArrayList<PolicySubject> arrayList = new ArrayList<PolicySubject>();
        if (policyMap != null) {
            AddressingFeature addressingFeature = wSBinding.getFeature(AddressingFeature.class);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("addressingFeature = " + addressingFeature);
            }
            if (addressingFeature != null && addressingFeature.isEnabled()) {
                this.addWsamAddressing(arrayList, policyMap, sEIModel, addressingFeature);
            }
        }
        LOGGER.exiting(arrayList);
        return arrayList;
    }

    private void addWsamAddressing(Collection<PolicySubject> collection, PolicyMap policyMap, SEIModel sEIModel, AddressingFeature addressingFeature) throws PolicyException {
        QName qName = sEIModel.getBoundPortTypeName();
        WsdlBindingSubject wsdlBindingSubject = WsdlBindingSubject.createBindingSubject(qName);
        Policy policy = this.createWsamAddressingPolicy(qName, addressingFeature);
        PolicySubject policySubject = new PolicySubject((Object)wsdlBindingSubject, policy);
        collection.add(policySubject);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Added addressing policy with ID \"" + policy.getIdOrName() + "\" to binding element \"" + qName + "\"");
        }
    }

    private Policy createWsamAddressingPolicy(QName qName, AddressingFeature addressingFeature) {
        ArrayList<AssertionSet> arrayList = new ArrayList<AssertionSet>(1);
        ArrayList<AddressingAssertion> arrayList2 = new ArrayList<AddressingAssertion>(1);
        AssertionData assertionData = AssertionData.createAssertionData(W3CAddressingMetadataConstants.WSAM_ADDRESSING_ASSERTION);
        if (!addressingFeature.isRequired()) {
            assertionData.setOptionalAttribute(true);
        }
        try {
            AddressingFeature.Responses responses = addressingFeature.getResponses();
            if (responses == AddressingFeature.Responses.ANONYMOUS) {
                AssertionData assertionData2 = AssertionData.createAssertionData(W3CAddressingMetadataConstants.WSAM_ANONYMOUS_NESTED_ASSERTION);
                AddressingAssertion addressingAssertion = new AddressingAssertion(assertionData2, null);
                arrayList2.add(new AddressingAssertion(assertionData, AssertionSet.createAssertionSet(Collections.singleton(addressingAssertion))));
            } else if (responses == AddressingFeature.Responses.NON_ANONYMOUS) {
                AssertionData assertionData3 = AssertionData.createAssertionData(W3CAddressingMetadataConstants.WSAM_NONANONYMOUS_NESTED_ASSERTION);
                AddressingAssertion addressingAssertion = new AddressingAssertion(assertionData3, null);
                arrayList2.add(new AddressingAssertion(assertionData, AssertionSet.createAssertionSet(Collections.singleton(addressingAssertion))));
            } else {
                arrayList2.add(new AddressingAssertion(assertionData, AssertionSet.createAssertionSet(null)));
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            arrayList2.add(new AddressingAssertion(assertionData, AssertionSet.createAssertionSet(null)));
        }
        arrayList.add(AssertionSet.createAssertionSet(arrayList2));
        return Policy.createPolicy(null, qName.getLocalPart() + "_WSAM_Addressing_Policy", arrayList);
    }

    private static final class AddressingAssertion
    extends PolicyAssertion {
        AddressingAssertion(AssertionData assertionData, AssertionSet assertionSet) {
            super(assertionData, null, assertionSet);
        }

        AddressingAssertion(AssertionData assertionData) {
            super(assertionData, null, null);
        }
    }
}

