/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.spi;

import com.sun.xml.internal.ws.policy.PolicyAssertion;
import com.sun.xml.internal.ws.policy.spi.PolicyAssertionValidator;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public abstract class AbstractQNameValidator
implements PolicyAssertionValidator {
    private final Set<String> supportedDomains = new HashSet<String>();
    private final Collection<QName> serverAssertions;
    private final Collection<QName> clientAssertions;

    protected AbstractQNameValidator(Collection<QName> collection, Collection<QName> collection2) {
        if (collection != null) {
            this.serverAssertions = new HashSet<QName>(collection);
            for (QName qName : this.serverAssertions) {
                this.supportedDomains.add(qName.getNamespaceURI());
            }
        } else {
            this.serverAssertions = new HashSet<QName>(0);
        }
        if (collection2 != null) {
            this.clientAssertions = new HashSet<QName>(collection2);
            for (QName qName : this.clientAssertions) {
                this.supportedDomains.add(qName.getNamespaceURI());
            }
        } else {
            this.clientAssertions = new HashSet<QName>(0);
        }
    }

    @Override
    public String[] declareSupportedDomains() {
        return this.supportedDomains.toArray(new String[this.supportedDomains.size()]);
    }

    @Override
    public PolicyAssertionValidator.Fitness validateClientSide(PolicyAssertion policyAssertion) {
        return this.validateAssertion(policyAssertion, this.clientAssertions, this.serverAssertions);
    }

    @Override
    public PolicyAssertionValidator.Fitness validateServerSide(PolicyAssertion policyAssertion) {
        return this.validateAssertion(policyAssertion, this.serverAssertions, this.clientAssertions);
    }

    private PolicyAssertionValidator.Fitness validateAssertion(PolicyAssertion policyAssertion, Collection<QName> collection, Collection<QName> collection2) {
        QName qName = policyAssertion.getName();
        if (collection.contains(qName)) {
            return PolicyAssertionValidator.Fitness.SUPPORTED;
        }
        if (collection2.contains(qName)) {
            return PolicyAssertionValidator.Fitness.UNSUPPORTED;
        }
        return PolicyAssertionValidator.Fitness.UNKNOWN;
    }
}

