/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.transport.http.server;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.PropertySet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.resources.WsservletMessages;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import com.sun.xml.internal.ws.transport.http.WSHTTPConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.spi.http.HttpExchange;

final class PortableConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final HttpExchange httpExchange;
    private int status;
    private final HttpAdapter adapter;
    private boolean outputWritten;
    private static final PropertySet.PropertyMap model = PortableConnectionImpl.parse(PortableConnectionImpl.class);

    public PortableConnectionImpl(@NotNull HttpAdapter httpAdapter, @NotNull HttpExchange httpExchange) {
        this.adapter = httpAdapter;
        this.httpExchange = httpExchange;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.internal.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        return this.httpExchange.getRequestHeaders();
    }

    @Override
    public String getRequestHeader(String string) {
        return this.httpExchange.getRequestHeader(string);
    }

    @Override
    public void setResponseHeaders(Map<String, List<String>> map) {
        Map<String, List<String>> map2 = this.httpExchange.getResponseHeaders();
        map2.clear();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            List<String> list = entry.getValue();
            if (string.equalsIgnoreCase("Content-Length") || string.equalsIgnoreCase("Content-Type")) continue;
            map2.put(string, new ArrayList<String>(list));
        }
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.response.headers", "com.sun.xml.internal.ws.api.message.packet.outbound.transport.headers"})
    public Map<String, List<String>> getResponseHeaders() {
        return this.httpExchange.getResponseHeaders();
    }

    @Override
    public void setContentTypeResponseHeader(@NotNull String string) {
        this.httpExchange.addResponseHeader("Content-Type", string);
    }

    @Override
    public void setStatus(int n) {
        this.status = n;
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.status;
    }

    @Override
    @NotNull
    public InputStream getInput() throws IOException {
        return this.httpExchange.getRequestBody();
    }

    @Override
    @NotNull
    public OutputStream getOutput() throws IOException {
        assert (!this.outputWritten);
        this.outputWritten = true;
        this.httpExchange.setStatus(this.getStatus());
        return this.httpExchange.getResponseBody();
    }

    @Override
    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    @Override
    public Principal getUserPrincipal(Packet packet) {
        return this.httpExchange.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(Packet packet, String string) {
        return this.httpExchange.isUserInRole(string);
    }

    @Override
    @NotNull
    public String getEPRAddress(Packet packet, WSEndpoint wSEndpoint) {
        PortAddressResolver portAddressResolver = this.adapter.owner.createPortAddressResolver(this.getBaseAddress());
        String string = portAddressResolver.getAddressFor(wSEndpoint.getServiceName(), wSEndpoint.getPortName().getLocalPart());
        if (string == null) {
            throw new WebServiceException(WsservletMessages.SERVLET_NO_ADDRESS_AVAILABLE(wSEndpoint.getPortName()));
        }
        return string;
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.context"})
    public Object getServletContext() {
        return this.httpExchange.getAttribute("javax.xml.ws.servlet.context");
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.response"})
    public Object getServletResponse() {
        return this.httpExchange.getAttribute("javax.xml.ws.servlet.response");
    }

    @PropertySet.Property(value={"javax.xml.ws.servlet.request"})
    public Object getServletRequest() {
        return this.httpExchange.getAttribute("javax.xml.ws.servlet.request");
    }

    @Override
    public String getWSDLAddress(@NotNull Packet packet, @NotNull WSEndpoint wSEndpoint) {
        String string = this.getEPRAddress(packet, wSEndpoint);
        if (this.adapter.getEndpoint().getPort() != null) {
            return string + "?wsdl";
        }
        return null;
    }

    @Override
    public boolean isSecure() {
        return this.httpExchange.getScheme().equals("https");
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return this.httpExchange.getRequestMethod();
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return this.httpExchange.getQueryString();
    }

    @Override
    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        return this.httpExchange.getPathInfo();
    }

    @PropertySet.Property(value={"com.sun.xml.internal.ws.http.exchange"})
    public HttpExchange getExchange() {
        return this.httpExchange;
    }

    @Override
    @NotNull
    public String getBaseAddress() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.httpExchange.getScheme());
        stringBuilder.append("://");
        stringBuilder.append(this.httpExchange.getLocalAddress().getHostName());
        stringBuilder.append(":");
        stringBuilder.append(this.httpExchange.getLocalAddress().getPort());
        stringBuilder.append(this.httpExchange.getContextPath());
        return stringBuilder.toString();
    }

    @Override
    public String getProtocol() {
        return this.httpExchange.getProtocol();
    }

    @Override
    public void setContentLengthResponseHeader(int n) {
        this.httpExchange.addResponseHeader("Content-Length", "" + n);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

