/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.instrumentation;

import java.util.HashMap;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;

final class MaxLocalsTracker
extends ClassVisitor {
    private final HashMap<String, Integer> maxLocalsMap = new HashMap();

    public MaxLocalsTracker() {
        super(327680);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        return new MaxLocalsMethodVisitor(MaxLocalsTracker.key(string, string2));
    }

    public int getMaxLocals(String string, String string2) {
        Integer n = this.maxLocalsMap.get(MaxLocalsTracker.key(string, string2));
        if (n == null) {
            throw new IllegalArgumentException("No maxLocals could be found for " + string + string2);
        }
        return n;
    }

    private static String key(String string, String string2) {
        return string + string2;
    }

    private final class MaxLocalsMethodVisitor
    extends MethodVisitor {
        private String key;

        public MaxLocalsMethodVisitor(String string) {
            super(327680);
            this.key = string;
        }

        @Override
        public void visitMaxs(int n, int n2) {
            MaxLocalsTracker.this.maxLocalsMap.put(this.key, n2);
        }
    }
}

