/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceMeter;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.ResourceIdImpl;

public class SimpleMeter
implements ResourceMeter,
ResourceRequest {
    private final ResourceType type;
    private final AtomicLong value;
    private final AtomicLong allocated;
    private final ResourceRequest parent;

    public static SimpleMeter create(ResourceType resourceType) {
        return new SimpleMeter(resourceType, null);
    }

    public static SimpleMeter create(ResourceType resourceType, ResourceRequest resourceRequest) {
        return new SimpleMeter(resourceType, resourceRequest);
    }

    protected SimpleMeter(ResourceType resourceType, ResourceRequest resourceRequest) {
        this.type = Objects.requireNonNull(resourceType, "type");
        this.parent = resourceRequest;
        this.value = new AtomicLong();
        this.allocated = new AtomicLong();
    }

    @Override
    public final long getValue() {
        return this.value.get();
    }

    @Override
    public final long getAllocated() {
        return this.allocated.get();
    }

    @Override
    public final ResourceType getType() {
        return this.type;
    }

    public final ResourceRequest getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long request(long l, ResourceId resourceId) {
        long l2;
        if (l == 0L) {
            Object var4_3 = null;
            if (resourceId == null || !(resourceId instanceof ResourceIdImpl) || !((ResourceIdImpl)resourceId).isForcedUpdate()) {
                return 0L;
            }
        }
        long l3 = 0L;
        if (l > 0L) {
            try {
                l2 = this.value.getAndAdd(l);
                l3 = this.validate(l2, l, resourceId);
            }
            finally {
                l2 = l - l3;
                if (l2 != 0L) {
                    this.value.getAndAdd(-l2);
                }
            }
        } else {
            l2 = this.getValue();
            l3 = this.validate(l2, l, resourceId);
            this.value.getAndAdd(l3);
        }
        if (this.parent != null) {
            l2 = l3;
            l3 = 0L;
            try {
                l3 = this.parent.request(l2, resourceId);
            }
            finally {
                long l4 = l2 - l3;
                if (l4 != 0L) {
                    this.value.getAndAdd(-l4);
                }
            }
        }
        if (l3 > 0L) {
            this.allocated.getAndAdd(l3);
        }
        return l3;
    }

    protected long validate(long l, long l2, ResourceId resourceId) throws ResourceRequestDeniedException {
        return l2;
    }

    public String toString() {
        long l = this.value.get();
        long l2 = this.allocated.get();
        return this.type.toString() + ": " + Long.toString(l) + "/" + l2;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }
}

