/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import javax.net.ssl.SSLHandshakeException;

final class DHClientKeyExchange
extends HandshakeMessage {
    private byte[] dh_Yc;

    int messageType() {
        return 16;
    }

    BigInteger getClientPublicKey() {
        return this.dh_Yc == null ? null : new BigInteger(1, this.dh_Yc);
    }

    DHClientKeyExchange(BigInteger bigInteger) {
        this.dh_Yc = DHClientKeyExchange.toByteArray(bigInteger);
    }

    DHClientKeyExchange() {
        this.dh_Yc = null;
    }

    DHClientKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
        if (handshakeInStream.available() < 2) {
            throw new SSLHandshakeException("Unsupported implicit client DiffieHellman public key");
        }
        this.dh_Yc = handshakeInStream.getBytes16();
    }

    int messageLength() {
        if (this.dh_Yc == null) {
            return 0;
        }
        return this.dh_Yc.length + 2;
    }

    void send(HandshakeOutStream handshakeOutStream) throws IOException {
        if (this.dh_Yc != null && this.dh_Yc.length != 0) {
            handshakeOutStream.putBytes16(this.dh_Yc);
        }
    }

    void print(PrintStream printStream) throws IOException {
        printStream.println("*** ClientKeyExchange, DH");
        if (debug != null && Debug.isOn("verbose")) {
            Debug.println(printStream, "DH Public key", this.dh_Yc);
        }
    }
}

