/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.system;

import com.jrockit.mc.common.IArray;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IVirtualMachineService;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;

public class ServerInformationModel
implements IArray<String[]> {
    public static final Field FIELD_BYTE_FORMATTER = new ByteField(0);
    private final IConnectionHandle m_connectionHandle;
    private Properties m_serverProperties;

    public ServerInformationModel(IConnectionHandle connectionHandle) {
        this.m_connectionHandle = connectionHandle;
    }

    public String getConnectionInformation() {
        return NLS.bind((String)Messages.CONNECTION_INFORMATION_VALUE, (Object)this.m_connectionHandle.getServerDescriptor().getDisplayName(), (Object)this.m_connectionHandle.toString());
    }

    public String getOsVersion() {
        return String.valueOf(this.getServerProperty("os.name")) + ' ' + this.getServerProperty("os.version");
    }

    public String getOsArchitecture() {
        return this.getServerProperty("os.arch");
    }

    public String getNumberOfProcessors() {
        Object proc = AttributeToolkit.getAttributeValueOrNull((IConnectionHandle)this.m_connectionHandle, (String)"java.lang:type=OperatingSystem", (String)"AvailableProcessors");
        return proc instanceof Number ? String.valueOf(proc) : "";
    }

    public String getTotalPhysicalMemory() {
        Object memory = AttributeToolkit.getAttributeValueOrNull((IConnectionHandle)this.m_connectionHandle, (String)"java.lang:type=OperatingSystem", (String)"TotalPhysicalMemorySize");
        return memory instanceof Number ? KindOfQuantity.format((Number)((Number)memory), (IUnit)UnitLookup.BYTES) : "";
    }

    public String getPID() {
        int pid = ((IVirtualMachineService)this.m_connectionHandle.getServiceOrDummy(IVirtualMachineService.class)).getPID();
        return pid != 0 ? Integer.toString(pid) : "";
    }

    public String getVmVersion() {
        Object[] values = new String[]{this.getServerProperty("java.vm.name"), this.getServerProperty("java.vm.version"), this.getServerProperty("java.runtime.version")};
        return values[0].isEmpty() ? "" : NLS.bind((String)Messages.VM_VERSION_VALUE, (Object[])values);
    }

    public String getVmVendor() {
        return this.getServerProperty("java.vm.vendor");
    }

    public String getStartTime() {
        Object o = AttributeToolkit.getAttributeValueOrNull((IConnectionHandle)this.m_connectionHandle, (String)"java.lang:type=Runtime", (String)"StartTime");
        return o instanceof Number ? KindOfQuantity.format((Number)((Number)o), (IUnit)UnitLookup.EPOCHMILLIS) : "";
    }

    public String getClassPath() {
        return this.getServerProperty("java.class.path");
    }

    public String getVmArguments() {
        Object arguments = AttributeToolkit.getAttributeValueOrNull((IConnectionHandle)this.m_connectionHandle, (String)"java.lang:type=Runtime", (String)"InputArguments");
        StringBuilder argBuilder = new StringBuilder();
        if (arguments instanceof String[]) {
            String[] stringArray = (String[])arguments;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String argument = stringArray[n2];
                if (argBuilder.length() > 0) {
                    argBuilder.append(' ');
                }
                argBuilder.append(argument);
                ++n2;
            }
        }
        return argBuilder.toString();
    }

    public String getApplicationArguments() {
        JVMDescriptor jvmInfo;
        Object a = AttributeToolkit.getAttributeValueOrNull((IConnectionHandle)this.m_connectionHandle, (String)"oracle.jrockit.management:type=PerfCounters", (String)"sun.rt.javaCommand");
        if (a != null) {
            return a.toString();
        }
        String arguments = this.getServerProperties().getProperty("sun.java.command");
        if ((arguments == null || arguments.length() == 0) && (jvmInfo = this.m_connectionHandle.getServerDescriptor().getJvmInfo()) != null && jvmInfo.getJavaCommandLine() != null) {
            arguments = jvmInfo.getJavaCommandLine();
        }
        return arguments == null ? "" : arguments;
    }

    public String getLibraryPath() {
        return this.getServerProperty("java.library.path");
    }

    public String getBootClassPath() {
        return this.getServerProperty("sun.boot.class.path");
    }

    private String getServerProperty(String key) {
        return this.getServerProperties().getProperty(key, "");
    }

    private Properties getServerProperties() {
        if (this.m_serverProperties == null) {
            this.m_serverProperties = ConnectionToolkit.getServerProperties((IConnectionHandle)this.m_connectionHandle);
        }
        return this.m_serverProperties;
    }

    public boolean isEmpty() {
        return false;
    }

    public String[][] elements() {
        return new String[][]{ServerInformationModel.buildDataRow(Messages.CONNECTION_INFORMATION_LABEL, this.getConnectionInformation()), ServerInformationModel.buildDataRow(Messages.OPERATING_SYSTEM_LABEL, this.getOsVersion()), ServerInformationModel.buildDataRow(Messages.OPERATING_SYSTEM_ARCHITECTURE_LABEL, this.getOsArchitecture()), ServerInformationModel.buildDataRow(Messages.NUMBER_OF_PROCESSORS_LABEL, this.getNumberOfProcessors()), ServerInformationModel.buildDataRow(Messages.TOTAL_PHYSICAL_MEMORY_LABEL, this.getTotalPhysicalMemory()), ServerInformationModel.buildDataRow(Messages.PROCESS_ID_LABEL, this.getPID()), ServerInformationModel.buildDataRow(Messages.VM_VERSION_LABEL, this.getVmVersion()), ServerInformationModel.buildDataRow(Messages.VM_VENDOR_LABEL, this.getVmVendor()), ServerInformationModel.buildDataRow(Messages.START_TIME_LABEL, this.getStartTime()), ServerInformationModel.buildDataRow(Messages.CLASS_PATH_LABEL, this.getClassPath()), ServerInformationModel.buildDataRow(Messages.VM_ARGUMENTS_LABEL, this.getVmArguments()), ServerInformationModel.buildDataRow(Messages.APPLICATION_ARGUMENTS_LABEL, this.getApplicationArguments()), ServerInformationModel.buildDataRow(Messages.LIBRARY_PATH_LABEL, this.getLibraryPath()), ServerInformationModel.buildDataRow(Messages.BOOT_CLASS_PATH_LABEL, this.getBootClassPath())};
    }

    private static String[] buildDataRow(String label, String value) {
        return new String[]{label, value};
    }
}

