/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.IOException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.BackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;

public class LazyBackupStore
implements IBackupStore {
    private BackupStore delegate;
    private final String prefix;

    public LazyBackupStore(String prefix) {
        this.prefix = prefix;
    }

    public boolean backup(File file) throws IOException {
        this.loadDelegate();
        return this.delegate.backup(file);
    }

    public boolean backupDirectory(File file) throws IOException {
        this.loadDelegate();
        return this.delegate.backupDirectory(file);
    }

    public void discard() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.discard();
    }

    public void restore() throws IOException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.restore();
    }

    private void loadDelegate() {
        if (this.delegate != null) {
            return;
        }
        this.delegate = new BackupStore(null, this.prefix);
    }

    public String getBackupName() {
        this.loadDelegate();
        return this.delegate.getBackupName();
    }

    public boolean backupCopy(File file) throws IOException {
        this.loadDelegate();
        return this.delegate.backupCopy(file);
    }

    public void backupCopyAll(File file) throws IOException {
        this.loadDelegate();
        this.delegate.backupCopyAll(file);
    }

    public void backupAll(File file) throws IOException {
        this.loadDelegate();
        this.delegate.backupAll(file);
    }
}

