/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.api.nodes;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.ExternalPackages;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.selector.api.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.api.nodes.PackageNode;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.api.nodes.SelectorNode;
import org.openide.filesystems.FileObject;
import org.openide.util.lookup.Lookups;

public class JarNode
extends ContainerNode {
    private FileObject jar;

    public JarNode(FileObject fileObject) {
        super(fileObject.getName(), Icons.getIcon((String)"LanguangeIcons.Jar"), Lookups.singleton((Object)fileObject));
        this.jar = fileObject;
    }

    @Override
    protected SelectorChildren getChildren() {
        return new Children(this);
    }

    private static class Children
    extends SelectorChildren<JarNode> {
        public Children(JarNode jarNode) {
            super(jarNode);
        }

        @Override
        protected List<? extends SelectorNode> prepareChildren(JarNode jarNode) {
            ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
            for (SourcePackageInfo sourcePackageInfo : ExternalPackages.forPath((FileObject)jarNode.jar)) {
                arrayList.add(new PackageNode(sourcePackageInfo, jarNode));
            }
            return arrayList;
        }
    }
}

