/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;

public class ObjectArrayNode
extends ArrayNode {
    public ObjectArrayNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode) {
        super((Instance)objectArrayInstance, string, heapWalkerNode);
    }

    public ObjectArrayNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super((Instance)objectArrayInstance, string, heapWalkerNode, n);
    }

    public ObjectArrayInstance getInstance() {
        return (ObjectArrayInstance)super.getInstance();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            @Override
            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] heapWalkerNodeArray = null;
                if (ObjectArrayNode.this.getMode() == 1) {
                    int n = ObjectArrayNode.this.getInstance().getLength();
                    if (n == 0) {
                        heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(ObjectArrayNode.this)};
                    } else if (n > 500) {
                        int n2 = n;
                        BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(n2);
                        int n3 = groupingInfo.containersCount;
                        int n4 = groupingInfo.collapseUnitSize;
                        heapWalkerNodeArray = new HeapWalkerNode[n3];
                        for (int i = 0; i < n3; ++i) {
                            int n5 = n4 * i;
                            int n6 = Math.min(n5 + n4, n2) - 1;
                            heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createArrayItemContainerNode(ObjectArrayNode.this, n5, n6);
                        }
                    } else {
                        List list = ObjectArrayNode.this.getInstance().getValues();
                        heapWalkerNodeArray = new HeapWalkerNode[list.size()];
                        for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                            heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createObjectArrayItemNode(ObjectArrayNode.this, i, (Instance)list.get(i));
                        }
                    }
                } else if (ObjectArrayNode.this.getMode() == 2) {
                    heapWalkerNodeArray = HeapWalkerNodeFactory.createReferences(ObjectArrayNode.this);
                }
                return heapWalkerNodeArray;
            }
        };
    }

    public static abstract class RootNode
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode) {
            super(objectArrayInstance, string, heapWalkerNode);
        }

        public RootNode(ObjectArrayInstance objectArrayInstance, String string, HeapWalkerNode heapWalkerNode, int n) {
            super(objectArrayInstance, string, heapWalkerNode, n);
        }

        @Override
        public abstract void refreshView();
    }

    public static class ArrayItem
    extends ObjectArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private int itemIndex;
        private String nodeID;

        public ArrayItem(int n, ObjectArrayInstance objectArrayInstance, HeapWalkerNode heapWalkerNode) {
            this(n, objectArrayInstance, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
        }

        public ArrayItem(int n, ObjectArrayInstance objectArrayInstance, HeapWalkerNode heapWalkerNode, int n2) {
            super(objectArrayInstance, null, heapWalkerNode, n2);
            this.itemIndex = n;
        }

        @Override
        public int getItemIndex() {
            return this.itemIndex;
        }

        @Override
        protected String computeName() {
            String string = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                return string + " " + Bundle.ObjectArrayNode_LoopToString(BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            return string;
        }

        @Override
        protected String computeType() {
            if (!this.hasInstance()) {
                return "<" + BrowserUtils.getArrayItemType(this.getType()) + ">";
            }
            return super.computeType();
        }

        @Override
        public Object getNodeID() {
            if (this.nodeID == null) {
                this.nodeID = this.itemIndex + "#" + (this.hasInstance() ? Long.valueOf(this.getInstance().getInstanceId()) : "null");
            }
            return this.nodeID;
        }
    }
}

