/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    public static <T> T get(FST<T> fst, IntsRef input) throws IOException {
        Object NO_OUTPUT;
        assert (fst.inputType == FST.INPUT_TYPE.BYTE4);
        FST.Arc<T> arc = fst.getFirstArc(new FST.Arc());
        Object output = NO_OUTPUT = fst.outputs.getNoOutput();
        for (int i = 0; i < input.length; ++i) {
            if (fst.findTargetArc(input.ints[input.offset + i], arc, arc) == null) {
                return null;
            }
            if (arc.output == NO_OUTPUT) continue;
            output = fst.outputs.add(output, arc.output);
        }
        if (fst.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != NO_OUTPUT) {
            return fst.outputs.add(output, arc.output);
        }
        return output;
    }

    public static <T> T get(FST<T> fst, char[] input, int offset, int length) throws IOException {
        int utf32;
        Object NO_OUTPUT;
        assert (fst.inputType == FST.INPUT_TYPE.BYTE4);
        FST.Arc<T> arc = fst.getFirstArc(new FST.Arc());
        int charLimit = offset + length;
        Object output = NO_OUTPUT = fst.outputs.getNoOutput();
        for (int charIdx = offset; charIdx < charLimit; charIdx += Character.charCount(utf32)) {
            utf32 = Character.codePointAt(input, charIdx);
            if (fst.findTargetArc(utf32, arc, arc) != null) continue;
            return null;
        }
        if (fst.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != NO_OUTPUT) {
            return fst.outputs.add(output, arc.output);
        }
        return output;
    }

    public static <T> T get(FST<T> fst, CharSequence input) throws IOException {
        int utf32;
        Object NO_OUTPUT;
        assert (fst.inputType == FST.INPUT_TYPE.BYTE4);
        FST.Arc<T> arc = fst.getFirstArc(new FST.Arc());
        int charLimit = input.length();
        Object output = NO_OUTPUT = fst.outputs.getNoOutput();
        for (int charIdx = 0; charIdx < charLimit; charIdx += Character.charCount(utf32)) {
            utf32 = Character.codePointAt(input, charIdx);
            if (fst.findTargetArc(utf32, arc, arc) != null) continue;
            return null;
        }
        if (fst.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != NO_OUTPUT) {
            return fst.outputs.add(output, arc.output);
        }
        return output;
    }

    public static <T> T get(FST<T> fst, BytesRef input) throws IOException {
        Object NO_OUTPUT;
        assert (fst.inputType == FST.INPUT_TYPE.BYTE1);
        FST.Arc<T> arc = fst.getFirstArc(new FST.Arc());
        Object output = NO_OUTPUT = fst.outputs.getNoOutput();
        for (int i = 0; i < input.length; ++i) {
            if (fst.findTargetArc(input.bytes[i + input.offset] & 0xFF, arc, arc) == null) {
                return null;
            }
            if (arc.output == NO_OUTPUT) continue;
            output = fst.outputs.add(output, arc.output);
        }
        if (fst.findTargetArc(-1, arc, arc) == null) {
            return null;
        }
        if (arc.output != NO_OUTPUT) {
            return fst.outputs.add(output, arc.output);
        }
        return output;
    }

    public static <T> void toDot(FST<T> fst, Writer out, boolean sameRank, boolean labelStates) throws IOException {
        String expandedNodeColor = "blue";
        FST.Arc<T> startArc = fst.getFirstArc(new FST.Arc());
        ArrayList thisLevelQueue = new ArrayList();
        ArrayList nextLevelQueue = new ArrayList();
        nextLevelQueue.add(startArc);
        ArrayList<Integer> sameLevelStates = new ArrayList<Integer>();
        BitSet seen = new BitSet();
        seen.set(startArc.target);
        String stateShape = "circle";
        out.write("digraph FST {\n");
        out.write("  rankdir = LR; splines=true; concentrate=true; ordering=out; ranksep=2.5; \n");
        if (!labelStates) {
            out.write("  node [shape=circle, width=.2, height=.2, style=filled]\n");
        }
        Util.emitDotState(out, "initial", "point", "white", "");
        Util.emitDotState(out, Integer.toString(startArc.target), "circle", fst.isExpandedTarget(startArc) ? "blue" : null, "");
        out.write("  initial -> " + startArc.target + "\n");
        Object NO_OUTPUT = fst.outputs.getNoOutput();
        int level = 0;
        while (!nextLevelQueue.isEmpty()) {
            thisLevelQueue.addAll(nextLevelQueue);
            nextLevelQueue.clear();
            out.write("\n  // Transitions and states at level: " + ++level + "\n");
            block1: while (!thisLevelQueue.isEmpty()) {
                FST.Arc arc = (FST.Arc)thisLevelQueue.remove(thisLevelQueue.size() - 1);
                if (!fst.targetHasArcs(arc)) continue;
                int node = arc.target;
                fst.readFirstTargetArc(arc, arc);
                while (true) {
                    if (arc.target >= 0 && !seen.get(arc.target)) {
                        boolean isExpanded = fst.isExpandedTarget(arc);
                        Util.emitDotState(out, Integer.toString(arc.target), "circle", isExpanded ? "blue" : null, labelStates ? Integer.toString(arc.target) : "");
                        seen.set(arc.target);
                        nextLevelQueue.add(new FST.Arc().copyFrom(arc));
                        sameLevelStates.add(arc.target);
                    }
                    String outs = arc.output != NO_OUTPUT ? "/" + fst.outputs.outputToString(arc.output) : "";
                    String cl = arc.label == -1 ? "~" : Util.printableLabel(arc.label);
                    out.write("  " + node + " -> " + arc.target + " [label=\"" + cl + outs + "\"]\n");
                    if (arc.isLast()) continue block1;
                    fst.readNextArc(arc);
                }
            }
            if (sameRank && sameLevelStates.size() > 1) {
                out.write("  {rank=same; ");
                Iterator i$ = sameLevelStates.iterator();
                while (i$.hasNext()) {
                    int state = (Integer)i$.next();
                    out.write(state + "; ");
                }
                out.write(" }\n");
            }
            sameLevelStates.clear();
        }
        out.write("  -1 [style=filled, color=black, shape=circle, label=\"\"]\n\n");
        out.write("  {rank=sink; -1 }\n");
        out.write("}\n");
        out.flush();
    }

    private static void emitDotState(Writer out, String name, String shape, String color, String label) throws IOException {
        out.write("  " + name + " [" + (shape != null ? "shape=" + shape : "") + " " + (color != null ? "color=" + color : "") + " " + (label != null ? "label=\"" + label + "\"" : "label=\"\"") + " " + "]\n");
    }

    private static String printableLabel(int label) {
        if (label >= 32 && label <= 125) {
            return Character.toString((char)label);
        }
        return "0x" + Integer.toHexString(label);
    }
}

