/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.commands.internal.parser;

import com.jrockit.mc.commands.Parameter;
import com.jrockit.mc.commands.internal.parser.ParameterParser;
import com.jrockit.mc.commands.internal.parser.ParserException;
import com.jrockit.mc.common.parsing.Token;
import java.text.ParseException;

final class BooleanParser
extends ParameterParser {
    public static final String ID = "boolean";

    BooleanParser(Parameter parameter) {
        super(parameter);
    }

    @Override
    boolean acceptValue(String value) {
        if (value.equals(Boolean.TRUE.toString())) {
            return true;
        }
        return value.equals(Boolean.FALSE.toString());
    }

    @Override
    protected Object parseValue(Token parameterToken, String text) throws ParseException {
        if (Boolean.TRUE.toString().equals(text)) {
            return Boolean.TRUE;
        }
        if (Boolean.FALSE.toString().equals(text)) {
            return Boolean.FALSE;
        }
        throw new ParserException("Boolean value must be true or false.", parameterToken);
    }
}

