/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.BlockedException;
import com.sun.deploy.security.BlockedVersionException;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.awt.Component;
import java.io.IOException;
import java.net.URL;

public class SecureStaticVersioning {
    public static final int REASON_CONFIG = 0;
    public static final int REASON_UNSIGNED = 1;
    public static final int REASON_UNAVAIL = 2;
    public static final int REASON_FX = 3;
    public static final int REASON_INVALID = 4;

    private static boolean promptUse(Component component, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, LocalApplicationProperties localApplicationProperties, String string) throws BlockedException {
        if (!SecureStaticVersioning.isTrustedNotSelfSigned(appInfo) && deploymentRuleSet.isSSVModeNever()) {
            SecureStaticVersioning.useLatest(appInfo, deploymentRuleSet, string, 0);
            return false;
        }
        if (localApplicationProperties != null && "ssv.latest.allowed".equals(localApplicationProperties.get("ssv.version.allowed"))) {
            return false;
        }
        if (SecureStaticVersioning.showSSV2Dialog(component, appInfo, string)) {
            if (localApplicationProperties != null) {
                localApplicationProperties.put("ssv.version.allowed", string);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
            return true;
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put("ssv.version.allowed", "ssv.latest.allowed");
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
        return false;
    }

    public static boolean canUse(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, String string) throws BlockedException {
        Object object;
        String string2 = deploymentRuleSet.getVersionString();
        if (deploymentRuleSet.isRuleRun()) {
            if (string2 == null || SecureStaticVersioning.satisfiesDRSVersion(string2, string)) {
                return true;
            }
            if (SecureStaticVersioning.satisfiesDRSVersion(string2)) {
                return false;
            }
            object = ResourceManager.getString("deployment.blocked.ruleset.version", deploymentRuleSet.getVersionString(), string);
            BlockedDialog.show(appInfo, (String)object, null, null, null, deploymentRuleSet);
        }
        if (!SecureStaticVersioning.isOlderVersion(string) || SecurityBaseline.satisfiesSecurityBaseline(string)) {
            return true;
        }
        object = SecureStaticVersioning.getLap(appInfo);
        if (object != null && string.equals(object.get("ssv.version.allowed"))) {
            return true;
        }
        return SecureStaticVersioning.promptUse(null, appInfo, deploymentRuleSet, (LocalApplicationProperties)object, string);
    }

    public static void checkVersionAllowed(DeploymentRuleSet deploymentRuleSet) {
        String string = deploymentRuleSet.getVersionString();
        if (string != null && !SecureStaticVersioning.satisfiesDRSVersion(string)) {
            throw new BlockedVersionException("Required JRE " + string + " not running", null);
        }
    }

    private static boolean isTrustedNotSelfSigned(AppInfo appInfo) {
        String string;
        return appInfo.getSecurity() == 2 && !"true".equals(string = (String)ToolkitStore.get().getAppContext().get("self-signed"));
    }

    public static void resetAcceptedVersion(URL uRL, AppInfo appInfo) {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(uRL);
        if (localApplicationProperties != null) {
            localApplicationProperties.put("ssv.version.allowed", null);
            SandboxSecurity.resetAcceptedVersion(localApplicationProperties, appInfo);
        }
    }

    private static boolean isOlderVersion(String string) {
        VersionID versionID;
        VersionID versionID2 = new VersionID(SecurityBaseline.getCurrentVersion() + "+");
        return !versionID2.match(versionID = new VersionID(string));
    }

    private static LocalApplicationProperties getLap(AppInfo appInfo) {
        return Cache.getLocalApplicationProperties(appInfo.getLapURL());
    }

    private static boolean showSSV2Dialog(Component component, AppInfo appInfo, String string) throws BlockedException {
        String string2 = ResourceManager.getString("deployment.ssv2.title");
        String string3 = ResourceManager.getString("deployment.ssv2.masthead");
        String string4 = ResourceManager.getString("deployment.ssv2.risk");
        String string5 = ResourceManager.getString("deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = ResourceManager.getString("deployment.ssv2.choice");
        String string7 = ResourceManager.getString("deployment.ssv2.choice1");
        String string8 = ResourceManager.getString("deployment.ssv2.choice2", string);
        String string9 = ResourceManager.getString("deployment.ssv2.run.button");
        String string10 = ResourceManager.getString("common.cancel_btn");
        int n = ToolkitStore.getUI().showSSVDialog(component, appInfo, string2, string3, string4, string5, uRL, string6, string7, string8, string9, string10);
        ToolkitStore.getUI();
        if (n == 0) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 2) {
            return false;
        }
        throw new BlockedException("deployment.blocked.cancel", null);
    }

    private static void showCannotUseDialog(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string, int n) throws BlockedException {
        if (localApplicationProperties != null && "ssv.latest.allowed".equals(localApplicationProperties.get("ssv.version.allowed"))) {
            return;
        }
        String string2 = ResourceManager.getString("deployment.ssv2.nodl.title");
        String string3 = null;
        switch (n) {
            case 0: {
                string3 = "deployment.ssv2.nodl.blocked";
                break;
            }
            case 3: {
                string3 = "deployment.ssv2.nodl.fx";
                break;
            }
            case 4: {
                string3 = "deployment.ssv2.nodl.invalid";
                break;
            }
            default: {
                string3 = "deployment.ssv2.nodl.masthead";
            }
        }
        String string4 = ResourceManager.getString(string3, string);
        String string5 = ResourceManager.getString("deployment.ssv2.nodl.button");
        String string6 = ResourceManager.getString("common.cancel_btn");
        String string7 = ResourceManager.getString("deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n2 = uIFactory.showMessageDialog(component, appInfo, 2, string2, string4, null, null, string5, string6, null, uRL, string7, 0);
        ToolkitStore.getUI();
        if (n2 != 0) {
            throw new BlockedException("deployment.blocked.cancel", null);
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put("ssv.version.allowed", "ssv.latest.allowed");
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
        }
    }

    public static boolean useLatest(AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, String string, int n) throws BlockedException {
        if (deploymentRuleSet.isRuleRun()) {
            String string2 = deploymentRuleSet.getVersionString();
            if (string2 == null || SecureStaticVersioning.satisfiesDRSVersion(string2)) {
                return true;
            }
            String string3 = ResourceManager.getString("deployment.blocked.ruleset.version", deploymentRuleSet.getVersionString(), string);
            BlockedDialog.show(appInfo, string3, null, null, null, deploymentRuleSet);
        }
        SecureStaticVersioning.showCannotUseDialog(null, appInfo, SecureStaticVersioning.getLap(appInfo), string, n);
        return true;
    }

    public static boolean satisfiesDRSVersion(String string) {
        JREInfo jREInfo = JREInfo.getHomeJRE();
        if (jREInfo != null) {
            return SecureStaticVersioning.satisfiesDRSVersion(string, jREInfo.getProduct());
        }
        return false;
    }

    public static boolean satisfiesDRSVersion(String string, String string2) {
        int n = string2.indexOf("-");
        String string3 = string2 = n > 0 ? string2.substring(0, n) : string2;
        if (string.startsWith("SECURE-")) {
            String string4 = string.substring("SECURE-".length());
            if (!string2.startsWith(string4)) {
                return false;
            }
            String string5 = SecurityBaseline.getBaselineVersion(string4);
            return SecurityBaseline.satisfiesBaselineStrictly(string2, string5);
        }
        if (string.equals("SECURE")) {
            return SecurityBaseline.satisfiesBaselineStrictly(string2);
        }
        VersionString versionString = new VersionString(string);
        return versionString.contains(string2);
    }
}

