/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.trace.Trace;
import java.awt.Font;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class PromptEditorKit
extends HTMLEditorKit {
    private StyleSheet _defaultStyles;
    private final Font base;
    private final Font bold;
    private final boolean increaseFontSize;

    public PromptEditorKit(Font font, Font font2, boolean bl) {
        this.base = font;
        this.bold = font2;
        this.increaseFontSize = bl;
    }

    public StyleSheet getStyleSheet() {
        if (this._defaultStyles == null) {
            this._defaultStyles = new StyleSheet();
            this._defaultStyles.addStyleSheet(super.getStyleSheet());
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0 }"));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("a { color:blue; text-decoration: none; }"));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString("A:hover {color:red;}"));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString(this.displayPropertiesToCSS("body", this.base)));
            this._defaultStyles.addStyleSheet(this.createStyleSheetFromString(this.displayPropertiesToCSS("b", this.bold)));
        }
        return this._defaultStyles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StyleSheet createStyleSheetFromString(String string) {
        StyleSheet styleSheet = new StyleSheet();
        StringReader stringReader = null;
        try {
            try {
                stringReader = new StringReader(string);
                styleSheet.loadRules(stringReader, null);
            }
            catch (IOException iOException) {
                Trace.printException(iOException);
                Object var6_5 = null;
                if (stringReader != null) {
                    stringReader.close();
                }
            }
            Object var6_4 = null;
            if (stringReader != null) {
                stringReader.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (stringReader != null) {
                stringReader.close();
            }
            throw throwable;
        }
        return styleSheet;
    }

    private String displayPropertiesToCSS(String string, Font font) {
        StringBuilder stringBuilder = new StringBuilder(string + " {");
        if (font != null) {
            stringBuilder.append(" font-family: ");
            stringBuilder.append(font.getFamily());
            stringBuilder.append(" ; ");
            stringBuilder.append(" font-size: ");
            stringBuilder.append(font.getSize());
            stringBuilder.append("pt ;");
            if (font.isBold() && this.increaseFontSize) {
                stringBuilder.append(" font-weight: 700 ; ");
            }
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

