/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeObjAllocTermCCTNode;
import org.netbeans.lib.profiler.results.memory.SurvGenSet;

public class RuntimeObjLivenessTermCCTNode
extends RuntimeObjAllocTermCCTNode {
    private int[][] epochAndNLiveObjects;

    public RuntimeObjLivenessTermCCTNode(int n) {
        super(n);
    }

    protected RuntimeObjLivenessTermCCTNode() {
    }

    @Override
    public int getType() {
        return 3;
    }

    public void addLiveObjectForEpoch(int n) {
        int n2;
        int n3;
        if (this.epochAndNLiveObjects == null) {
            this.epochAndNLiveObjects = new int[2][2];
            this.epochAndNLiveObjects[0][1] = -1;
            this.epochAndNLiveObjects[0][0] = -1;
        }
        int n4 = this.epochAndNLiveObjects[0].length;
        for (n3 = n2 = n4 - 1; this.epochAndNLiveObjects[0][n3] == -1 && n3 > 0; --n3) {
        }
        if (this.epochAndNLiveObjects[0][n3] > -1) {
            if (this.epochAndNLiveObjects[0][n3] < n) {
                if (n3 == n2) {
                    int[][] nArray = new int[2][n4 + 2];
                    System.arraycopy(this.epochAndNLiveObjects[0], 0, nArray[0], 0, n4);
                    System.arraycopy(this.epochAndNLiveObjects[1], 0, nArray[1], 0, n4);
                    this.epochAndNLiveObjects = nArray;
                    this.epochAndNLiveObjects[0][n4 + 1] = -1;
                    this.epochAndNLiveObjects[0][n4] = -1;
                }
                ++n3;
            } else {
                while (n3 > 0 && this.epochAndNLiveObjects[0][n3] != n) {
                    --n3;
                }
                if (this.epochAndNLiveObjects[0][n3] != n) {
                    return;
                }
            }
        }
        this.epochAndNLiveObjects[0][n3] = n;
        int[] nArray = this.epochAndNLiveObjects[1];
        int n5 = n3;
        nArray[n5] = nArray[n5] + 1;
    }

    public static float calculateAvgObjectAgeForAllPaths(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n) {
        int[] nArray = new int[2];
        RuntimeObjLivenessTermCCTNode.calculateNObjAndAge(runtimeMemoryCCTNode, n, nArray);
        if (nArray[0] == 0) {
            return 0.0f;
        }
        return (float)((double)nArray[1] / (double)nArray[0]);
    }

    public int calculateTotalNLiveObjects() {
        if (this.epochAndNLiveObjects == null) {
            return 0;
        }
        int n = 0;
        int n2 = this.epochAndNLiveObjects[0].length;
        for (int i = 0; i < n2 && this.epochAndNLiveObjects[0][i] != -1; ++i) {
            n += this.epochAndNLiveObjects[1][i];
        }
        return n;
    }

    public static int calculateTotalNumberOfSurvGensForAllPaths(RuntimeMemoryCCTNode runtimeMemoryCCTNode) {
        SurvGenSet survGenSet = new SurvGenSet();
        RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(runtimeMemoryCCTNode, survGenSet);
        return survGenSet.getTotalNoOfAges();
    }

    @Override
    public Object clone() {
        RuntimeObjLivenessTermCCTNode runtimeObjLivenessTermCCTNode = (RuntimeObjLivenessTermCCTNode)super.clone();
        if (this.epochAndNLiveObjects == null) {
            runtimeObjLivenessTermCCTNode.epochAndNLiveObjects = null;
        } else {
            int n = this.epochAndNLiveObjects[0].length;
            runtimeObjLivenessTermCCTNode.epochAndNLiveObjects = new int[2][n];
            System.arraycopy(this.epochAndNLiveObjects[0], 0, runtimeObjLivenessTermCCTNode.epochAndNLiveObjects[0], 0, n);
            System.arraycopy(this.epochAndNLiveObjects[1], 0, runtimeObjLivenessTermCCTNode.epochAndNLiveObjects[1], 0, n);
        }
        return runtimeObjLivenessTermCCTNode;
    }

    @Override
    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        super.readFromStream(dataInputStream);
        int n = dataInputStream.readInt();
        this.epochAndNLiveObjects = new int[2][n];
        for (int i = 0; i < n; ++i) {
            this.epochAndNLiveObjects[0][i] = dataInputStream.readInt();
            this.epochAndNLiveObjects[1][i] = dataInputStream.readInt();
        }
    }

    public void removeLiveObjectForEpoch(int n) {
        int n2;
        int n3;
        assert (this.epochAndNLiveObjects != null);
        int n4 = this.epochAndNLiveObjects[0].length;
        for (n3 = n2 = n4 - 1; this.epochAndNLiveObjects[0][n3] != n && n3 > 0; --n3) {
        }
        if (this.epochAndNLiveObjects[0][n3] != n) {
            return;
        }
        int[] nArray = this.epochAndNLiveObjects[1];
        int n5 = n3;
        nArray[n5] = nArray[n5] - 1;
        if (this.epochAndNLiveObjects[1][n3] == 0) {
            if (n3 < n2) {
                if (n3 >= n2 || this.epochAndNLiveObjects[0][n3 + 1] != -1) {
                    System.arraycopy(this.epochAndNLiveObjects[0], n3 + 1, this.epochAndNLiveObjects[0], n3, n2 - n3);
                    System.arraycopy(this.epochAndNLiveObjects[1], n3 + 1, this.epochAndNLiveObjects[1], n3, n2 - n3);
                } else {
                    this.epochAndNLiveObjects[0][n3] = -1;
                }
            }
            this.epochAndNLiveObjects[0][n2] = -1;
            this.epochAndNLiveObjects[1][n2] = 0;
        }
    }

    @Override
    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        super.writeToStream(dataOutputStream);
        int n = this.epochAndNLiveObjects == null ? 0 : this.epochAndNLiveObjects[0].length;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeInt(this.epochAndNLiveObjects[0][i]);
            dataOutputStream.writeInt(this.epochAndNLiveObjects[1][i]);
        }
    }

    protected static void calculateNObjAndAge(RuntimeMemoryCCTNode runtimeMemoryCCTNode, int n, int[] nArray) {
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        if (runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) {
            runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])runtimeMemoryCCTNode;
            int[][] nArray2 = runtimeMemoryCCTNodeArray.epochAndNLiveObjects;
            if (nArray2 != null) {
                int n2 = nArray2[0].length;
                for (int i = 0; i < n2 && nArray2[0][i] != -1; ++i) {
                    nArray[0] = nArray[0] + nArray2[1][i];
                    nArray[1] = nArray[1] + nArray2[1][i] * (n - nArray2[0][i]);
                }
            }
        }
        if (runtimeMemoryCCTNode.children != null) {
            if (runtimeMemoryCCTNode.children instanceof RuntimeMemoryCCTNode) {
                RuntimeObjLivenessTermCCTNode.calculateNObjAndAge((RuntimeMemoryCCTNode)runtimeMemoryCCTNode.children, n, nArray);
            } else {
                runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])runtimeMemoryCCTNode.children;
                for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
                    RuntimeObjLivenessTermCCTNode.calculateNObjAndAge(runtimeMemoryCCTNodeArray[i], n, nArray);
                }
            }
        }
    }

    protected static void calculateTotalNumberOfSurvGens(RuntimeMemoryCCTNode runtimeMemoryCCTNode, SurvGenSet survGenSet) {
        RuntimeMemoryCCTNode[] runtimeMemoryCCTNodeArray;
        if (runtimeMemoryCCTNode instanceof RuntimeObjLivenessTermCCTNode) {
            runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])runtimeMemoryCCTNode;
            int[][] nArray = runtimeMemoryCCTNodeArray.epochAndNLiveObjects;
            if (nArray != null) {
                int[] nArray2 = nArray[0];
                int n = nArray2.length;
                for (int i = 0; i < n && nArray2[i] != -1; ++i) {
                    survGenSet.addAge(nArray2[i]);
                }
            }
        }
        if (runtimeMemoryCCTNode.children != null) {
            if (runtimeMemoryCCTNode.children instanceof RuntimeMemoryCCTNode) {
                RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens((RuntimeMemoryCCTNode)runtimeMemoryCCTNode.children, survGenSet);
            } else {
                runtimeMemoryCCTNodeArray = (RuntimeMemoryCCTNode[])runtimeMemoryCCTNode.children;
                for (int i = 0; i < runtimeMemoryCCTNodeArray.length; ++i) {
                    RuntimeObjLivenessTermCCTNode.calculateTotalNumberOfSurvGens(runtimeMemoryCCTNodeArray[i], survGenSet);
                }
            }
        }
    }

    protected void dumpEpochs() {
        if (this.epochAndNLiveObjects != null) {
            int n = this.epochAndNLiveObjects[0].length;
            for (int i = 0; i < n; ++i) {
                System.err.println("epoch = " + this.epochAndNLiveObjects[0][i] + ", objno = " + this.epochAndNLiveObjects[1][i]);
            }
        } else {
            System.err.println("epoch = null");
        }
    }
}

