/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.diagnostic.form;

import com.jrockit.mc.console.ui.diagnostic.DiagnosticPlugin;
import com.jrockit.mc.console.ui.diagnostic.form.DiagnosticOperationForm;
import com.jrockit.mc.console.ui.diagnostic.form.Messages;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.rjmx.services.IDiagnosticCommandService;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DiagnosticTab
extends ConsoleTab {
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout(MCLayoutFactory.createFormPageLayout());
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)DiagnosticPlugin.getDefault().getMCDialogSettings(), (String)"execute_diagnostic_form");
        SashForm sash = new SashForm(form.getBody(), 512);
        new DiagnosticOperationForm(sash, managedForm.getToolkit(), settings, this.loadOperations());
        sash.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
    }

    private Collection<? extends IOperation> loadOperations() {
        IDiagnosticCommandService diagCommandService = (IDiagnosticCommandService)this.getConnectionHandle().getServiceOrNull(IDiagnosticCommandService.class);
        if (diagCommandService != null) {
            try {
                return diagCommandService.getOperations();
            }
            catch (Exception e) {
                this.showMessage(Messages.DiagnosticTab_MESSAGE_DIAGNOSTIC_COMMANDS_NOT_SUPPORTED);
                return Collections.emptyList();
            }
        }
        this.showMessage(Messages.DiagnosticTab_MESSAGE_DIAGNOSTIC_COMMANDS_NOT_SUPPORTED);
        return Collections.emptyList();
    }
}

