/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.unicode;

import org.jcodings.ApplyAllCaseFoldFunction;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.CodeRange;
import org.jcodings.IntHolder;
import org.jcodings.MultiByteEncoding;
import org.jcodings.exception.CharacterPropertyException;
import org.jcodings.unicode.UnicodeProperties;
import org.jcodings.util.ArrayReader;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.IntArrayHash;
import org.jcodings.util.IntHash;

public abstract class UnicodeEncoding
extends MultiByteEncoding {
    private static final int PROPERTY_NAME_MAX_SIZE = 20;
    static final short[] UNICODE_ISO_8859_1_CTypeTable = new short[]{16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17036, 17033, 17032, 17032, 17032, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 16392, 17028, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 30896, 16800, 16800, 16800, 16800, 16800, 16800, 16800, 31906, 31906, 31906, 31906, 31906, 31906, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 29858, 16800, 16800, 16800, 16800, 20896, 16800, 30946, 30946, 30946, 30946, 30946, 30946, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 28898, 16800, 16800, 16800, 16800, 16392, 8, 8, 8, 8, 8, 648, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 644, 416, 160, 160, 160, 160, 160, 160, 160, 160, 12514, 416, 160, 168, 160, 160, 160, 160, 4256, 4256, 160, 12514, 160, 416, 160, 4256, 12514, 416, 4256, 4256, 4256, 416, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 160, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 160, 12514, 12514, 12514, 12514, 12514, 12514, 12514, 12514};

    protected UnicodeEncoding(String name2, int minLength, int maxLength, int[] EncLen) {
        super(name2, minLength, maxLength, EncLen, null, UNICODE_ISO_8859_1_CTypeTable);
    }

    protected UnicodeEncoding(String name2, int minLength, int maxLength, int[] EncLen, int[][] Trans) {
        super(name2, minLength, maxLength, EncLen, Trans, UNICODE_ISO_8859_1_CTypeTable);
    }

    public String getCharsetName() {
        return new String(this.getName());
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14 && code < 256) {
            return this.isCodeCTypeInternal(code, ctype);
        }
        if (ctype > UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return CodeRange.isInCodeRange(UnicodeProperties.CodeRangeTable[ctype].getRange(), code);
    }

    protected final int[] ctypeCodeRange(int ctype) {
        if (ctype >= UnicodeProperties.CodeRangeTable.length) {
            throw new InternalError("undefined type (bug)");
        }
        return UnicodeProperties.CodeRangeTable[ctype].getRange();
    }

    public int propertyNameToCType(byte[] name2, int p2, int end2) {
        byte[] buf = new byte[20];
        int len = 0;
        for (int p_ = p2; p_ < end2; p_ += this.length(name2, p_, end2)) {
            int code = this.mbcToCode(name2, p_, end2);
            if (code >= 128) {
                throw new CharacterPropertyException("invalid character property name <%n>");
            }
            buf[len++] = (byte)code;
            if (len < 20) continue;
            throw new CharacterPropertyException("invalid character property name <%n>", name2, p2, end2);
        }
        Integer ctype = (Integer)CTypeName.CTypeNameHash.get(buf, 0, len);
        if (ctype == null) {
            throw new CharacterPropertyException("invalid character property name <%n>", name2, p2, end2);
        }
        return ctype;
    }

    public int mbcCaseFold(int flag, byte[] bytes2, IntHolder pp, int end2, byte[] fold) {
        int p2 = pp.value;
        int foldP = 0;
        int code = this.mbcToCode(bytes2, p2, end2);
        int len = this.length(bytes2, p2, end2);
        pp.value += len;
        int[] to = CaseFold.FoldHash.get(code);
        if (to != null) {
            if (to.length == 1) {
                return this.codeToMbc(to[0], fold, foldP);
            }
            int rlen = 0;
            for (int i2 = 0; i2 < to.length; ++i2) {
                len = this.codeToMbc(to[i2], fold, foldP);
                foldP += len;
                rlen += len;
            }
            return rlen;
        }
        for (int i3 = 0; i3 < len; ++i3) {
            fold[foldP++] = bytes2[p2++];
        }
        return len;
    }

    public void applyAllCaseFold(int flag, ApplyAllCaseFoldFunction fun, Object arg2) {
        int k;
        int j;
        int[] to;
        int from;
        int i2;
        int[] code = new int[]{0};
        for (i2 = 0; i2 < CaseFold11.CaseUnfold_11_From.length; ++i2) {
            from = CaseFold11.CaseUnfold_11_From[i2];
            to = CaseFold11.CaseUnfold_11_To[i2];
            for (j = 0; j < to.length; ++j) {
                code[0] = from;
                fun.apply(to[j], code, 1, arg2);
                code[0] = to[j];
                fun.apply(from, code, 1, arg2);
                for (k = 0; k < j; ++k) {
                    code[0] = to[k];
                    fun.apply(to[j], code, 1, arg2);
                    code[0] = to[j];
                    fun.apply(to[k], code, 1, arg2);
                }
            }
        }
        for (i2 = 0; i2 < CaseFold11.CaseUnfold_11_Locale_From.length; ++i2) {
            from = CaseFold11.CaseUnfold_11_Locale_From[i2];
            to = CaseFold11.CaseUnfold_11_Locale_To[i2];
            for (j = 0; j < to.length; ++j) {
                code[0] = from;
                fun.apply(to[j], code, 1, arg2);
                code[0] = to[j];
                fun.apply(from, code, 1, arg2);
                for (k = 0; k < j; ++k) {
                    code[0] = to[k];
                    fun.apply(to[j], code, 1, arg2);
                    code[0] = to[j];
                    fun.apply(to[k], code, 1, arg2);
                }
            }
        }
        if ((flag & 0x40000000) != 0) {
            for (i2 = 0; i2 < CaseFold12.CaseUnfold_12.length; i2 += 2) {
                int[] from2 = CaseFold12.CaseUnfold_12[i2];
                to = CaseFold12.CaseUnfold_12[i2 + 1];
                for (j = 0; j < to.length; ++j) {
                    fun.apply(to[j], from2, 2, arg2);
                    for (k = 0; k < to.length; ++k) {
                        if (k == j) continue;
                        code[0] = to[k];
                        fun.apply(to[j], code, 1, arg2);
                    }
                }
            }
            for (i2 = 0; i2 < CaseFold12.CaseUnfold_12_Locale.length; i2 += 2) {
                int[] from3 = CaseFold12.CaseUnfold_12_Locale[i2];
                to = CaseFold12.CaseUnfold_12_Locale[i2 + 1];
                for (j = 0; j < to.length; ++j) {
                    fun.apply(to[j], from3, 2, arg2);
                    for (k = 0; k < to.length; ++k) {
                        if (k == j) continue;
                        code[0] = to[k];
                        fun.apply(to[j], code, 1, arg2);
                    }
                }
            }
            for (i2 = 0; i2 < CaseFold13.CaseUnfold_13.length; i2 += 2) {
                int[] from4 = CaseFold13.CaseUnfold_13[i2];
                to = CaseFold13.CaseUnfold_13[i2 + 1];
                for (j = 0; j < to.length; ++j) {
                    fun.apply(to[j], from4, 3, arg2);
                    for (k = 0; k < to.length; ++k) {
                        if (k == j) continue;
                        code[0] = to[k];
                        fun.apply(to[j], code, 1, arg2);
                    }
                }
            }
        }
    }

    public CaseFoldCodeItem[] caseFoldCodesByString(int flag, byte[] bytes2, int p2, int end2) {
        int code = this.mbcToCode(bytes2, p2, end2);
        int len = this.length(bytes2, p2, end2);
        int n = 0;
        int fn = 0;
        int[] to = CaseFold.FoldHash.get(code);
        CaseFoldCodeItem[] items = null;
        if (to != null) {
            items = new CaseFoldCodeItem[13];
            if (to.length == 1) {
                int origCode = code;
                items[0] = new CaseFoldCodeItem(len, 1, new int[]{to[0]});
                ++n;
                code = to[0];
                if ((to = CaseFold11.Unfold1Hash.get(code)) != null) {
                    for (int i2 = 0; i2 < to.length; ++i2) {
                        if (to[i2] == origCode) continue;
                        items[n] = new CaseFoldCodeItem(len, 1, new int[]{to[i2]});
                        ++n;
                    }
                }
            } else if ((flag & 0x40000000) != 0) {
                int[] z2;
                int j;
                int i3;
                int[][] cs = new int[3][4];
                int[] ncs = new int[3];
                for (fn = 0; fn < to.length; ++fn) {
                    cs[fn][0] = to[fn];
                    int[] z3 = CaseFold11.Unfold1Hash.get(cs[fn][0]);
                    if (z3 != null) {
                        for (i3 = 0; i3 < z3.length; ++i3) {
                            cs[fn][i3 + 1] = z3[i3];
                        }
                        ncs[fn] = z3.length + 1;
                        continue;
                    }
                    ncs[fn] = 1;
                }
                if (fn == 2) {
                    for (int i4 = 0; i4 < ncs[0]; ++i4) {
                        for (j = 0; j < ncs[1]; ++j) {
                            items[n] = new CaseFoldCodeItem(len, 2, new int[]{cs[0][i4], cs[1][j]});
                            ++n;
                        }
                    }
                    z2 = CaseFold12.Unfold2Hash.get(to);
                    if (z2 != null) {
                        for (i3 = 0; i3 < z2.length; ++i3) {
                            if (z2[i3] == code) continue;
                            items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i3]});
                            ++n;
                        }
                    }
                } else {
                    for (int i5 = 0; i5 < ncs[0]; ++i5) {
                        for (j = 0; j < ncs[1]; ++j) {
                            for (int k = 0; k < ncs[2]; ++k) {
                                items[n] = new CaseFoldCodeItem(len, 3, new int[]{cs[0][i5], cs[1][j], cs[2][k]});
                                ++n;
                            }
                        }
                    }
                    z2 = CaseFold13.Unfold3Hash.get(to);
                    if (z2 != null) {
                        for (i3 = 0; i3 < z2.length; ++i3) {
                            if (z2[i3] == code) continue;
                            items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i3]});
                            ++n;
                        }
                    }
                }
                flag = 0;
            }
        } else {
            to = CaseFold11.Unfold1Hash.get(code);
            if (to != null) {
                items = new CaseFoldCodeItem[13];
                for (int i6 = 0; i6 < to.length; ++i6) {
                    items[n] = new CaseFoldCodeItem(len, 1, new int[]{to[i6]});
                    ++n;
                }
            }
        }
        if ((flag & 0x40000000) != 0) {
            if (items == null) {
                items = new CaseFoldCodeItem[13];
            }
            if ((p2 += len) < end2) {
                int codes0 = code;
                code = this.mbcToCode(bytes2, p2, end2);
                to = CaseFold.FoldHash.get(code);
                int codes1 = to != null && to.length == 1 ? to[0] : code;
                int clen = this.length(bytes2, p2, end2);
                len += clen;
                int[] z2 = CaseFold12.Unfold2Hash.get(codes0, codes1);
                if (z2 != null) {
                    for (int i7 = 0; i7 < z2.length; ++i7) {
                        items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i7]});
                        ++n;
                    }
                }
                if ((p2 += clen) < end2) {
                    code = this.mbcToCode(bytes2, p2, end2);
                    to = CaseFold.FoldHash.get(code);
                    int codes2 = to != null && to.length == 1 ? to[0] : code;
                    clen = this.length(bytes2, p2, end2);
                    len += clen;
                    z2 = CaseFold13.Unfold3Hash.get(codes0, codes1, codes2);
                    if (z2 != null) {
                        for (int i8 = 0; i8 < z2.length; ++i8) {
                            items[n] = new CaseFoldCodeItem(len, 1, new int[]{z2[i8]});
                            ++n;
                        }
                    }
                }
            }
        }
        if (items == null || n == 0) {
            return EMPTY_FOLD_CODES;
        }
        if (n < items.length) {
            CaseFoldCodeItem[] tmp = new CaseFoldCodeItem[n];
            System.arraycopy(items, 0, tmp, 0, n);
            return tmp;
        }
        return items;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseFold13 {
        private static final int[][] CaseUnfold_13 = ArrayReader.readNestedIntArray("CaseUnfold_13");
        static final IntArrayHash<int[]> Unfold3Hash = CaseFold13.initializeUnfold3Hash();

        private CaseFold13() {
        }

        private static IntArrayHash<int[]> initializeUnfold3Hash() {
            IntArrayHash<int[]> unfold3 = new IntArrayHash<int[]>(30);
            for (int i2 = 0; i2 < CaseUnfold_13.length; i2 += 2) {
                unfold3.putDirect(CaseUnfold_13[i2], CaseUnfold_13[i2 + 1]);
            }
            return unfold3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseFold12 {
        private static final int[][] CaseUnfold_12 = ArrayReader.readNestedIntArray("CaseUnfold_12");
        private static final int[][] CaseUnfold_12_Locale = ArrayReader.readNestedIntArray("CaseUnfold_12_Locale");
        static final IntArrayHash<int[]> Unfold2Hash = CaseFold12.initializeUnfold2Hash();

        private CaseFold12() {
        }

        private static IntArrayHash<int[]> initializeUnfold2Hash() {
            int i2;
            IntArrayHash<int[]> unfold2 = new IntArrayHash<int[]>(200);
            for (i2 = 0; i2 < CaseUnfold_12.length; i2 += 2) {
                unfold2.putDirect(CaseUnfold_12[i2], CaseUnfold_12[i2 + 1]);
            }
            for (i2 = 0; i2 < CaseUnfold_12_Locale.length; i2 += 2) {
                unfold2.putDirect(CaseUnfold_12_Locale[i2], CaseUnfold_12_Locale[i2 + 1]);
            }
            return unfold2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseFold11 {
        private static final int[] CaseUnfold_11_From = ArrayReader.readIntArray("CaseUnfold_11_From");
        private static final int[][] CaseUnfold_11_To = ArrayReader.readNestedIntArray("CaseUnfold_11_To");
        private static final int[] CaseUnfold_11_Locale_From = ArrayReader.readIntArray("CaseUnfold_11_Locale_From");
        private static final int[][] CaseUnfold_11_Locale_To = ArrayReader.readNestedIntArray("CaseUnfold_11_Locale_To");
        static final IntHash<int[]> Unfold1Hash = CaseFold11.initializeUnfold1Hash();

        private CaseFold11() {
        }

        private static IntHash<int[]> initializeUnfold1Hash() {
            int i2;
            IntHash<int[]> unfold1 = new IntHash<int[]>(1000);
            for (i2 = 0; i2 < CaseUnfold_11_From.length; ++i2) {
                unfold1.putDirect(CaseUnfold_11_From[i2], CaseUnfold_11_To[i2]);
            }
            for (i2 = 0; i2 < CaseUnfold_11_Locale_From.length; ++i2) {
                unfold1.putDirect(CaseUnfold_11_Locale_From[i2], CaseUnfold_11_Locale_To[i2]);
            }
            return unfold1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CaseFold {
        private static final int[] CaseFold_From = ArrayReader.readIntArray("CaseFold_From");
        private static final int[][] CaseFold_To = ArrayReader.readNestedIntArray("CaseFold_To");
        private static final int[] CaseFold_Locale_From = ArrayReader.readIntArray("CaseFold_Locale_From");
        private static final int[][] CaseFold_Locale_To = ArrayReader.readNestedIntArray("CaseFold_Locale_To");
        static final IntHash<int[]> FoldHash = CaseFold.initializeFoldHash();

        private CaseFold() {
        }

        private static IntHash<int[]> initializeFoldHash() {
            int i2;
            IntHash<int[]> fold = new IntHash<int[]>(1200);
            for (i2 = 0; i2 < CaseFold_From.length; ++i2) {
                fold.putDirect(CaseFold_From[i2], CaseFold_To[i2]);
            }
            for (i2 = 0; i2 < CaseFold_Locale_From.length; ++i2) {
                fold.putDirect(CaseFold_Locale_From[i2], CaseFold_Locale_To[i2]);
            }
            return fold;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CTypeName {
        private static final CaseInsensitiveBytesHash<Integer> CTypeNameHash = CTypeName.initializeCTypeNameTable();

        CTypeName() {
        }

        private static CaseInsensitiveBytesHash<Integer> initializeCTypeNameTable() {
            CaseInsensitiveBytesHash<Integer> table = new CaseInsensitiveBytesHash<Integer>();
            for (int i2 = 0; i2 < UnicodeProperties.CodeRangeTable.length; ++i2) {
                table.putDirect(UnicodeProperties.CodeRangeTable[i2].name, i2);
            }
            return table;
        }
    }

    static final class CodeRangeEntry {
        final String table;
        final byte[] name;
        int[] range;

        CodeRangeEntry(String name2, String table) {
            this.table = table;
            this.name = name2.getBytes();
        }

        public int[] getRange() {
            if (this.range == null) {
                this.range = ArrayReader.readIntArray(this.table);
            }
            return this.range;
        }
    }
}

