/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.PrintStream;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"NativeException"}, parent="RuntimeError")
public class NativeException
extends RubyException {
    private final Throwable cause;
    public static final String CLASS_NAME = "NativeException";
    private final Ruby runtime;
    private static ObjectAllocator NATIVE_EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            NativeException instance = new NativeException(runtime, klazz);
            instance.setMetaClass(klazz);
            return instance;
        }
    };

    public NativeException(Ruby runtime, RubyClass rubyClass, Throwable cause2) {
        super(runtime, rubyClass);
        this.runtime = runtime;
        this.cause = cause2;
        this.message = runtime.newString(cause2.getClass().getName() + ": " + this.searchStackMessage(cause2));
    }

    private NativeException(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
        this.runtime = runtime;
        this.cause = new Throwable();
        this.message = runtime.newString();
    }

    public static RubyClass createClass(Ruby runtime, RubyClass baseClass) {
        RubyClass exceptionClass = runtime.defineClass(CLASS_NAME, baseClass, NATIVE_EXCEPTION_ALLOCATOR);
        exceptionClass.defineAnnotatedMethods(NativeException.class);
        return exceptionClass;
    }

    @JRubyMethod
    public IRubyObject cause(Block unusedBlock) {
        return Java.getInstance(this.getRuntime(), this.cause);
    }

    @Override
    public IRubyObject backtrace() {
        IRubyObject rubyTrace = super.backtrace();
        if (rubyTrace.isNil()) {
            return rubyTrace;
        }
        RubyArray array = (RubyArray)rubyTrace.dup();
        StackTraceElement[] stackTrace = this.cause.getStackTrace();
        for (int i2 = stackTrace.length - 1; i2 >= 0; --i2) {
            String line;
            StackTraceElement element = stackTrace[i2];
            String className = element.getClassName();
            if (element.getFileName() == null) {
                line = className + ':' + element.getLineNumber() + ":in `" + element.getMethodName() + '\'';
            } else {
                int index2 = className.lastIndexOf(46);
                String packageName = index2 == -1 ? "" : className.substring(0, index2) + '/';
                line = packageName.replace('.', '/') + element.getFileName() + ':' + element.getLineNumber() + ":in `" + element.getMethodName() + '\'';
            }
            RubyString string2 = this.runtime.newString(line);
            array.unshift(string2);
        }
        return array;
    }

    public void trimStackTrace(Member target) {
        StackTraceElement b2;
        StackTraceElement a;
        Throwable t = new Throwable();
        StackTraceElement[] origStackTrace = this.cause.getStackTrace();
        StackTraceElement[] currentStackTrace = t.getStackTrace();
        int skip2 = 0;
        for (int i2 = 1; i2 <= origStackTrace.length && i2 <= currentStackTrace.length && (a = origStackTrace[origStackTrace.length - i2]).equals(b2 = currentStackTrace[currentStackTrace.length - i2]); ++i2) {
            ++skip2;
        }
        if (target != null) {
            String className = target.getDeclaringClass().getName();
            String methodName = target.getName();
            for (int i3 = origStackTrace.length - skip2 - 1; i3 >= 0; --i3) {
                StackTraceElement frame = origStackTrace[i3];
                if (!frame.getClassName().equals(className) || !frame.getMethodName().equals(methodName)) continue;
                skip2 = origStackTrace.length - i3 - 1;
                break;
            }
        }
        if (skip2 > 0) {
            int len = origStackTrace.length - skip2;
            StackTraceElement[] newStackTrace = new StackTraceElement[len];
            System.arraycopy(origStackTrace, 0, newStackTrace, 0, len);
            this.cause.setStackTrace(newStackTrace);
        }
    }

    @Override
    public void printBacktrace(PrintStream errorStream) {
        super.printBacktrace(errorStream);
        if (this.getRuntime().getDebug().isTrue()) {
            errorStream.println("Complete Java stackTrace");
            this.cause.printStackTrace(errorStream);
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    private String searchStackMessage(Throwable cause2) {
        String message2 = null;
        do {
            message2 = cause2.getMessage();
            cause2 = cause2.getCause();
        } while (message2 == null && cause2 != null);
        return message2;
    }
}

