/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.RubyRegexp;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class MatchInstr
extends Instr
implements ResultInstr {
    private Variable result;
    private Operand receiver;

    public MatchInstr(Variable result2, Operand receiver2) {
        super(Operation.MATCH);
        assert (result2 != null) : "MatchInstr result is null";
        this.result = result2;
        this.receiver = receiver2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.receiver};
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.receiver + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.receiver = this.receiver.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new MatchInstr((Variable)this.result.cloneForInlining(ii), this.receiver.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        RubyRegexp regexp2 = (RubyRegexp)this.receiver.retrieve(context, self2, currDynScope, temp);
        return context.runtime.is1_9() ? regexp2.op_match2_19(context) : regexp2.op_match2(context);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.MatchInstr(this);
    }
}

