/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.BooleanLiteral;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ToAryInstr
extends Instr
implements ResultInstr {
    private Variable result;
    private final BooleanLiteral dontToAryArrays;
    private Operand array;

    public ToAryInstr(Variable result2, Operand array, BooleanLiteral dontToAryArrays) {
        super(Operation.TO_ARY);
        assert (result2 != null) : "ToArtInstr result is null";
        this.result = result2;
        this.array = array;
        this.dontToAryArrays = dontToAryArrays;
    }

    public Operand getArrayArg() {
        return this.array;
    }

    public boolean dontToAryArrays() {
        return this.dontToAryArrays.isTrue();
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.array};
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.array = this.array.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Operand simplifyAndGetResult(IRScope scope, Map<Operand, Operand> valueMap) {
        this.simplifyOperands(valueMap, false);
        return this.dontToAryArrays.isTrue() && this.array.getValue(valueMap) instanceof Array ? this.array : null;
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new ToAryInstr((Variable)this.result.cloneForInlining(ii), this.array.cloneForInlining(ii), (BooleanLiteral)this.dontToAryArrays.cloneForInlining(ii));
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.array + ", dont_to_ary_arrays: " + this.dontToAryArrays + ")";
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self2, Object[] temp, Block block) {
        Object receiver2 = this.array.retrieve(context, self2, currDynScope, temp);
        return Helpers.irToAry(context, (IRubyObject)receiver2, this.dontToAryArrays.isTrue());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ToAryInstr(this);
    }
}

