/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRClosure;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class ClosureLocalVariable
extends LocalVariable {
    public final IRClosure definingScope;

    public ClosureLocalVariable(IRClosure scope, String name2, int scopeDepth, int location) {
        super(name2, scopeDepth, location);
        this.definingScope = scope;
    }

    @Override
    public String toString() {
        return "<" + this.name + "(" + this.scopeDepth + ":" + this.offset + ")>";
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClosureLocalVariable)) {
            return false;
        }
        return this.name.equals(((LocalVariable)obj).name);
    }

    @Override
    public int compareTo(Object arg0) {
        if (!(arg0 instanceof ClosureLocalVariable)) {
            return 0;
        }
        return this.name.compareTo(((LocalVariable)arg0).name);
    }

    @Override
    public Variable cloneForCloningClosure(InlinerInfo ii) {
        return new ClosureLocalVariable(ii.getClonedClosure(), this.name, this.scopeDepth, this.offset);
    }

    @Override
    public LocalVariable cloneForDepth(int n) {
        return new ClosureLocalVariable(this.definingScope, this.name, n, this.offset);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ClosureLocalVariable(this);
    }
}

