/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.java.util.ArrayUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaArray"}, parent="Java::JavaObject")
public class JavaArray
extends JavaObject {
    private final JavaUtil.JavaConverter javaConverter;

    public JavaArray(Ruby runtime, Object array) {
        super(runtime, runtime.getJavaSupport().getJavaArrayClass(), array);
        assert (array.getClass().isArray());
        this.javaConverter = JavaUtil.getJavaConverter(array.getClass().getComponentType());
    }

    public static RubyClass createJavaArrayClass(Ruby runtime, RubyModule Java2) {
        return JavaArray.createJavaArrayClass(runtime, Java2, Java2.getClass("JavaObject"));
    }

    static RubyClass createJavaArrayClass(Ruby runtime, RubyModule Java2, RubyClass JavaObject2) {
        return Java2.defineClassUnder("JavaArray", JavaObject2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
    }

    public Class getComponentType() {
        return this.getValue().getClass().getComponentType();
    }

    @Override
    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    public int getLength() {
        return Array.getLength(this.getValue());
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaArray && this.getValue() == ((JavaArray)other).getValue();
    }

    public IRubyObject arefDirect(Ruby runtime, int intIndex) {
        return ArrayUtils.arefDirect(runtime, this.getValue(), this.javaConverter, intIndex);
    }

    public IRubyObject aset(IRubyObject index2, IRubyObject value2) {
        if (!(index2 instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(index2, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)index2).getLongValue();
        if (!(value2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value2);
        }
        Object javaObject = ((JavaObject)value2).getValue();
        ArrayUtils.setWithExceptionHandlingDirect(this.getRuntime(), javaObject, intIndex, javaObject);
        return value2;
    }

    public IRubyObject asetDirect(Ruby runtime, int intIndex, IRubyObject value2) {
        return ArrayUtils.asetDirect(runtime, this.getValue(), this.javaConverter, intIndex, value2);
    }

    public void setWithExceptionHandling(int intIndex, Object javaObject) {
        ArrayUtils.setWithExceptionHandlingDirect(this.getRuntime(), this.getValue(), intIndex, javaObject);
    }

    public IRubyObject afill(IRubyObject beginIndex, IRubyObject endIndex, IRubyObject value2) {
        if (!(beginIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(beginIndex, this.getRuntime().getInteger());
        }
        int intIndex = (int)((RubyInteger)beginIndex).getLongValue();
        if (!(endIndex instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError(endIndex, this.getRuntime().getInteger());
        }
        int intEndIndex = (int)((RubyInteger)endIndex).getLongValue();
        if (!(value2 instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value2);
        }
        Object javaObject = ((JavaObject)value2).getValue();
        this.fillWithExceptionHandling(intIndex, intEndIndex, javaObject);
        return value2;
    }

    public void fillWithExceptionHandling(int intIndex, int intEndIndex, Object javaObject) {
        try {
            while (intIndex < intEndIndex) {
                Array.set(this.getValue(), intIndex, javaObject);
                ++intIndex;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw this.getRuntime().newArgumentError("index out of bounds for java array (" + intIndex + " for length " + this.getLength() + ")");
        }
        catch (ArrayStoreException e) {
            throw this.getRuntime().newArgumentError("wrong element type " + javaObject.getClass() + "(array is " + this.getValue().getClass() + ")");
        }
    }
}

