/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaProxyMethods {
    public static RubyModule createJavaProxyMethods(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyModule javaProxyMethods = runtime.defineModule("JavaProxyMethods");
        javaProxyMethods.defineAnnotatedMethods(JavaProxyMethods.class);
        return javaProxyMethods;
    }

    @JRubyMethod
    public static IRubyObject java_class(ThreadContext context, IRubyObject recv2) {
        return recv2.getMetaClass().getRealClass().getInstanceVariable("@java_class");
    }

    @JRubyMethod
    public static IRubyObject java_object(ThreadContext context, IRubyObject recv2) {
        return (IRubyObject)recv2.dataGetStruct();
    }

    @JRubyMethod(name={"java_object="})
    public static IRubyObject java_object_set(ThreadContext context, IRubyObject recv2, IRubyObject obj) {
        recv2.dataWrapStruct(obj);
        return obj;
    }

    @JRubyMethod(name={"=="})
    public static IRubyObject op_equal(IRubyObject recv2, IRubyObject rhs) {
        if (recv2 instanceof JavaProxy) {
            return JavaObject.op_equal((JavaProxy)recv2, rhs);
        }
        return ((JavaObject)recv2.dataGetStruct()).op_equal(rhs);
    }

    @JRubyMethod
    public static IRubyObject to_s(IRubyObject recv2) {
        if (recv2 instanceof JavaProxy) {
            return JavaObject.to_s(recv2.getRuntime(), ((JavaProxy)recv2).getObject());
        }
        if (recv2.dataGetStruct() != null) {
            return ((JavaObject)recv2.dataGetStruct()).to_s();
        }
        return ((RubyObject)recv2).to_s();
    }

    @JRubyMethod
    public static IRubyObject inspect(IRubyObject recv2) {
        if (recv2 instanceof RubyBasicObject) {
            return ((RubyBasicObject)recv2).hashyInspect();
        }
        return recv2.inspect();
    }

    @JRubyMethod(name={"eql?"})
    public static IRubyObject op_eql(IRubyObject recv2, IRubyObject rhs) {
        return JavaProxyMethods.op_equal(recv2, rhs);
    }

    @JRubyMethod
    public static IRubyObject hash(IRubyObject recv2) {
        if (recv2 instanceof JavaProxy) {
            return RubyFixnum.newFixnum(recv2.getRuntime(), ((JavaProxy)recv2).getObject().hashCode());
        }
        return ((JavaObject)recv2.dataGetStruct()).hash();
    }

    @JRubyMethod
    public static IRubyObject to_java_object(IRubyObject recv2) {
        return (JavaObject)recv2.dataGetStruct();
    }

    @JRubyMethod(name={"synchronized"})
    public static IRubyObject rbSynchronized(ThreadContext context, IRubyObject recv2, Block block) {
        if (recv2 instanceof JavaProxy) {
            return JavaObject.ruby_synchronized(context, ((JavaProxy)recv2).getObject(), block);
        }
        return ((JavaObject)recv2.dataGetStruct()).ruby_synchronized(context, block);
    }
}

