/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import jnr.posix.FileStat;
import org.jruby.Ruby;
import org.jruby.util.AbstractFileResource;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.JRubyNonExistentFile;
import org.jruby.util.JarFileStat;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

public class URLResource
extends AbstractFileResource {
    public static String URI = "uri:";
    public static String CLASSLOADER = "classloader:";
    public static String URI_CLASSLOADER = URI + CLASSLOADER;
    private final String uri;
    private final String[] list;
    private final URL url;
    private final String pathname;
    private final JarFileStat fileStat;
    private final ClassLoader cl;

    URLResource(String uri, URL url, String[] files) {
        this(uri, url, null, null, files);
    }

    URLResource(String uri, ClassLoader cl, String pathname2, String[] files) {
        this(uri, null, cl, pathname2, files);
    }

    private URLResource(String uri, URL url, ClassLoader cl, String pathname2, String[] files) {
        this.uri = uri;
        this.list = files;
        this.url = url;
        this.cl = cl;
        this.pathname = pathname2;
        this.fileStat = new JarFileStat(this);
    }

    @Override
    public String absolutePath() {
        return this.uri;
    }

    @Override
    public String canonicalPath() {
        return this.uri;
    }

    @Override
    public boolean exists() {
        return this.url != null || this.pathname != null || this.list != null;
    }

    @Override
    public boolean isDirectory() {
        return this.list != null;
    }

    @Override
    public boolean isFile() {
        return this.list == null && (this.url != null || this.pathname != null);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public String[] list() {
        return this.list;
    }

    @Override
    public boolean isSymLink() {
        return false;
    }

    @Override
    public FileStat stat() {
        return this.fileStat;
    }

    @Override
    public FileStat lstat() {
        return this.stat();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return JRubyNonExistentFile.NOT_EXIST;
    }

    @Override
    InputStream openInputStream() throws IOException {
        if (this.pathname != null) {
            return this.cl.getResourceAsStream(this.pathname);
        }
        return this.url.openStream();
    }

    @Override
    public ChannelDescriptor openDescriptor(ModeFlags flags, int perm) throws ResourceException {
        return new ChannelDescriptor(this.inputStream(), flags);
    }

    public static FileResource create(ClassLoader cl, String pathname2) {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        try {
            pathname2 = new URI(pathname2.replaceFirst("^/*", "/")).normalize().getPath().replaceAll("^/([.][.]/)*", "");
        }
        catch (URISyntaxException e) {
            pathname2 = pathname2.replaceAll("^[.]?/+", "");
        }
        URL url = cl.getResource(pathname2);
        String[] files = URLResource.listClassLoaderFiles(cl, pathname2);
        return new URLResource(URI_CLASSLOADER + "/" + pathname2, cl, url == null ? null : pathname2, files);
    }

    public static FileResource createClassloaderURI(Ruby runtime, String pathname2) {
        ClassLoader cl = runtime != null ? runtime.getJRubyClassLoader() : URLResource.class.getClassLoader();
        return URLResource.create(cl, pathname2);
    }

    public static FileResource create(Ruby runtime, String pathname2) {
        if (!pathname2.startsWith(URI)) {
            return null;
        }
        if ((pathname2 = pathname2.substring(URI.length()).replace("\\", "/")).startsWith(CLASSLOADER)) {
            return URLResource.createClassloaderURI(runtime, pathname2.substring(CLASSLOADER.length()));
        }
        return URLResource.createRegularURI(pathname2);
    }

    private static FileResource createRegularURI(String pathname2) {
        URL url;
        try {
            pathname2 = pathname2.replaceFirst("file:/([^/])", "file:///$1");
            pathname2 = pathname2.replaceFirst(":/([^/])", "://$1");
            url = new URL(pathname2);
            if (url.getProtocol().startsWith("http")) {
                return null;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return new URLResource(URI + pathname2, null, null);
        }
        String[] files = URLResource.listFiles(pathname2);
        if (files != null) {
            return new URLResource(URI + pathname2, null, files);
        }
        try {
            InputStream is = url.openStream();
            if (is != null) {
                is.close();
            } else {
                url = null;
            }
            return new URLResource(URI + pathname2, url, null);
        }
        catch (IOException e) {
            return new URLResource(URI + pathname2, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] listFilesFromInputStream(InputStream is) {
        BufferedReader reader = null;
        try {
            LinkedList<String> files = new LinkedList<String>();
            reader = new BufferedReader(new InputStreamReader(is));
            String line = reader.readLine();
            while (line != null) {
                files.add(line);
                line = reader.readLine();
            }
            String[] stringArray = files.toArray(new String[files.size()]);
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private static String[] listClassLoaderFiles(ClassLoader classloader, String pathname2) {
        if (pathname2.endsWith(".rb") || pathname2.endsWith(".class") || pathname2.endsWith(".jar")) {
            return null;
        }
        try {
            pathname2 = pathname2 + (pathname2.equals("") || pathname2.endsWith("/") ? ".jrubydir" : "/.jrubydir");
            Enumeration<URL> urls = classloader.getResources(pathname2);
            if (!urls.hasMoreElements()) {
                return null;
            }
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                for (String entry : URLResource.listFilesFromInputStream(url.openStream())) {
                    if (result2.contains(entry)) continue;
                    result2.add(entry);
                }
            }
            return result2.toArray(new String[result2.size()]);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String[] listFiles(String pathname2) {
        if (pathname2.endsWith(".rb") || pathname2.endsWith(".class") || pathname2.endsWith(".jar")) {
            return null;
        }
        try {
            InputStream is = new URL(pathname2 + "/.jrubydir").openStream();
            if (is != null) {
                return URLResource.listFilesFromInputStream(is);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResourceURL(Ruby runtime, String location) {
        if (location.startsWith(URI_CLASSLOADER)) {
            return runtime.getJRubyClassLoader().getResource(location.substring(URI_CLASSLOADER.length() + 1));
        }
        try {
            return new URL(location.replaceFirst("^" + URI, ""));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("BUG in " + URLResource.class);
        }
    }
}

