/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.yecht.Parser;
import org.yecht.ParserInput;
import org.yecht.Pointer;
import org.yecht.ruby.RubyBadAnchorHandler;
import org.yecht.ruby.RubyErrHandler;
import org.yecht.ruby.RubyIoStrRead;
import org.yecht.ruby.RubyLoadHandler;
import org.yecht.ruby.YAMLExtra;

public class YParser {
    public static final ObjectAllocator Allocator = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            Parser parser = Parser.newParser();
            parser.bonus = new Extra();
            RubyObject.Data pobj = runtime.newData(klass, parser);
            parser.setRootOnError(runtime.getNil());
            return pobj;
        }
    };

    public static boolean assignIO(Ruby runtime, Parser parser, IRubyObject[] pport) {
        boolean taint2 = true;
        IRubyObject port = pport[0];
        IRubyObject tmp = port.checkStringType();
        if (!tmp.isNil()) {
            taint2 = port.isTaint();
            port = tmp;
            ByteList bl = ((RubyString)port).getByteList();
            parser.str(Pointer.create(bl.bytes, bl.begin), bl.realSize, null);
        } else if (port.respondsTo("read")) {
            if (port.respondsTo("binmode")) {
                port.callMethod(runtime.getCurrentContext(), "binmode");
            }
            parser.str(Pointer.empty(), 0, new RubyIoStrRead(port));
        } else {
            throw runtime.newTypeError("instance of IO needed");
        }
        pport[0] = port;
        return taint2;
    }

    public static void setModel(IRubyObject p2, IRubyObject input, IRubyObject model) {
        Ruby runtime = p2.getRuntime();
        Parser parser = (Parser)p2.dataGetStructChecked();
        parser.handler(new RubyLoadHandler(runtime, (YAMLExtra)runtime.getModule("YAML").dataGetStruct()));
        if (model == runtime.newSymbol("Generic")) {
            p2.callMethod(runtime.getCurrentContext(), "set_resolver", ((RubyModule)runtime.getModule("YAML").getConstant("Yecht")).getConstant("GenericResolver"));
        }
        parser.implicitTyping(true);
        parser.taguriExpansion(true);
        if (input.isNil()) {
            input = ((RubyObject)p2).fastGetInstanceVariable("@input");
        }
        if (input == runtime.newSymbol("bytecode")) {
            parser.setInputType(ParserInput.Bytecode_UTF8);
        } else {
            parser.setInputType(ParserInput.YAML_UTF8);
        }
        parser.errorHandler(new RubyErrHandler(runtime));
        parser.badAnchorHandler(new RubyBadAnchorHandler(runtime));
    }

    @JRubyMethod(optional=1)
    public static IRubyObject initialize(IRubyObject self2, IRubyObject[] args2) {
        RubyHash options2 = null;
        options2 = args2.length == 0 ? RubyHash.newHash(self2.getRuntime()) : args2[0].convertToHash();
        ((RubyObject)self2).fastSetInstanceVariable("@options", options2);
        ((RubyObject)self2).fastSetInstanceVariable("@input", self2.getRuntime().getNil());
        ((RubyObject)self2).fastSetInstanceVariable("@resolver", self2.getRuntime().getNil());
        return self2;
    }

    @JRubyMethod(name={"bufsize="})
    public static IRubyObject bufsize_set(IRubyObject self2, IRubyObject size2) {
        if (size2.respondsTo("to_i")) {
            int n = RubyNumeric.fix2int(size2.callMethod(self2.getRuntime().getCurrentContext(), "to_i"));
            Parser p2 = (Parser)self2.dataGetStructChecked();
            p2.bufsize = n;
        }
        return self2;
    }

    @JRubyMethod
    public static IRubyObject bufsize(IRubyObject self2) {
        Parser p2 = (Parser)self2.dataGetStructChecked();
        return self2.getRuntime().newFixnum(p2.bufsize);
    }

    @JRubyMethod(required=1, optional=1)
    public static IRubyObject load(IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime = self2.getRuntime();
        ThreadContext ctx = runtime.getCurrentContext();
        IRubyObject port = args2[0];
        IRubyObject proc2 = null;
        proc2 = args2.length > 1 ? args2[1] : runtime.getNil();
        IRubyObject input = ((RubyHash)self2.callMethod(ctx, "options")).op_aref(ctx, runtime.newSymbol("input"));
        IRubyObject model = ((RubyHash)self2.callMethod(ctx, "options")).op_aref(ctx, runtime.newSymbol("Model"));
        Parser parser = (Parser)self2.dataGetStructChecked();
        YParser.setModel(self2, input, model);
        Extra bonus = (Extra)parser.bonus;
        bonus.taint = YParser.assignIO(runtime, parser, new IRubyObject[]{port});
        parser.setRootOnError(runtime.getNil());
        bonus.data = RubyHash.newHash(runtime);
        bonus.resolver = self2.callMethod(ctx, "resolver");
        bonus.proc = proc2.isNil() ? null : proc2;
        IRubyObject result2 = (IRubyObject)parser.parse();
        if (result2 == null) {
            result2 = runtime.getFalse();
        }
        return result2;
    }

    @JRubyMethod(frame=true)
    public static IRubyObject load_documents(IRubyObject self2, IRubyObject port, Block proc2) {
        Ruby runtime = self2.getRuntime();
        ThreadContext ctx = runtime.getCurrentContext();
        IRubyObject input = ((RubyHash)self2.callMethod(ctx, "options")).op_aref(ctx, runtime.newSymbol("input"));
        IRubyObject model = ((RubyHash)self2.callMethod(ctx, "options")).op_aref(ctx, runtime.newSymbol("Model"));
        Parser parser = (Parser)self2.dataGetStructChecked();
        YParser.setModel(self2, input, model);
        Extra bonus = (Extra)parser.bonus;
        bonus.taint = YParser.assignIO(runtime, parser, new IRubyObject[]{port});
        parser.setRootOnError(runtime.getNil());
        bonus.resolver = self2.callMethod(ctx, "resolver");
        bonus.proc = null;
        while (true) {
            bonus.data = RubyHash.newHash(runtime);
            IRubyObject v = (IRubyObject)parser.parse();
            if (parser.eof) {
                return runtime.getNil();
            }
            if (v == null) {
                v = runtime.getFalse();
            }
            proc2.yield(ctx, v);
        }
    }

    @JRubyMethod
    public static IRubyObject set_resolver(IRubyObject self2, IRubyObject resolver) {
        ((RubyObject)self2).fastSetInstanceVariable("@resolver", resolver);
        return self2;
    }

    public static class Extra {
        public IRubyObject data;
        public IRubyObject proc;
        public IRubyObject resolver;
        public boolean taint;
    }
}

