/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.greychart.ui.views;

import java.awt.Point;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import se.hirt.greychart.Selection;

final class ChartSelectionListener
extends MouseAdapter
implements MouseMoveListener {
    private final Selection m_selection;
    private boolean m_buttonDown;

    ChartSelectionListener(Selection selection) {
        this.m_selection = selection;
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
            this.m_buttonDown = true;
            this.m_selection.beginSelection();
            this.m_selection.setStart(new Point(e.x, e.y));
            this.m_selection.notifyObservers();
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this.m_buttonDown) {
            this.m_selection.setEnd(new Point(e.x, e.y));
            this.m_selection.notifyObservers();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.m_buttonDown && e.button == 1) {
            this.m_buttonDown = false;
            this.m_selection.setEnd(new Point(e.x, e.y));
            this.m_selection.finishSelection();
            this.m_selection.notifyObservers();
        }
    }
}

