/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.Node;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.gui.Value;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class WidgetNode
extends Node {
    private final XMLTagInstance m_inputElement;
    private final XMLModel m_model;
    private String m_description = "";
    private String m_label = "";

    protected WidgetNode(XMLModel model, XMLTagInstance inputElement) {
        this.m_inputElement = inputElement;
        this.m_model = model;
    }

    protected final XMLTagInstance getInputElement() {
        return this.m_inputElement;
    }

    public abstract void create(FormToolkit var1, Composite var2, int var3);

    public abstract void create(Composite var1, int var2);

    public final String getDescription() {
        return this.m_description;
    }

    public final String getLabel() {
        return this.m_label;
    }

    protected final void markDirty() {
        this.m_model.markDirty();
    }

    final void setDescription(String description) {
        this.m_description = description;
    }

    final void setLabel(String label) {
        this.m_label = label;
    }

    @Override
    public void fireChange() {
        super.fireChange();
    }

    @Override
    Value getValue() {
        return Value.valueOf(this.m_inputElement.getContent());
    }

    protected void setValue(String newValue) {
        String oldValue = this.getValue().toString();
        if (!newValue.equals(oldValue)) {
            this.m_inputElement.setContent(newValue);
            this.fireChange();
            this.markDirty();
        }
    }
}

