/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui;

import java.io.PrintWriter;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.about.ISystemSummarySection;

public class SecurityConfigurationSection
implements ISystemSummarySection {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static final String PROVIDER = "Provider.";

    public void write(PrintWriter writer) {
        Provider[] providers = Security.getProviders();
        writer.println("Providers (" + providers.length + "): ");
        writer.println();
        int i = 0;
        while (i < providers.length) {
            this.appendProvider(writer, providers[i], i);
            ++i;
        }
    }

    private void appendProvider(PrintWriter writer, Provider provider, int index) {
        writer.println(" Provider: " + provider.getName() + ", Version: " + provider.getVersion() + ", Class: " + provider.getClass().getName());
        writer.println("  Description: " + provider.getInfo());
        ProviderService[] services = SecurityConfigurationSection.getServices(provider);
        writer.println("  Services (" + services.length + "):");
        int i = 0;
        while (i < services.length) {
            this.appendService(writer, services[i], i);
            ++i;
        }
        writer.println();
    }

    private void appendService(PrintWriter writer, ProviderService service, int index) {
        Map attributes;
        writer.println("   Service: " + service.getType() + ", Algorithm: " + service.getAlgorithm() + ", Class: " + service.getClassName());
        List aliases = service.getAliases();
        if (aliases != null && aliases.size() > 0) {
            writer.print("    Aliases: ");
            Iterator it = aliases.iterator();
            while (it.hasNext()) {
                writer.print((String)it.next());
                if (!it.hasNext()) continue;
                writer.print(", ");
            }
            writer.println();
        }
        if ((attributes = service.getAttributes()) != null && attributes.size() > 0) {
            writer.println("    Attributes:");
            Set keys = attributes.keySet();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                writer.print("      " + key + ": ");
                writer.println((String)attributes.get(key));
            }
        }
    }

    private static ProviderService[] getServices(Provider provider) {
        Set<Object> providerKeys = provider.keySet();
        Hashtable<String, Object> serviceList = new Hashtable<String, Object>();
        Hashtable<String, Hashtable<String, String>> attributeMap = new Hashtable<String, Hashtable<String, String>>();
        Hashtable<String, ArrayList<String>> aliasMap = new Hashtable<String, ArrayList<String>>();
        Iterator<Object> it = providerKeys.iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.startsWith(PROVIDER)) continue;
            if (key.startsWith(ALG_ALIAS)) {
                String value = key.substring(key.indexOf(ALG_ALIAS) + ALG_ALIAS.length(), key.length());
                String type = (String)provider.get(key);
                String algo = value.substring(0, value.indexOf(46));
                String alias = value.substring(value.indexOf(46) + 1, value.length());
                ArrayList<String> aliasList = (ArrayList<String>)aliasMap.get(String.valueOf(type) + '.' + algo);
                if (aliasList == null) {
                    aliasList = new ArrayList<String>();
                    aliasList.add(alias);
                    aliasMap.put(type, aliasList);
                    continue;
                }
                aliasList.add(alias);
                continue;
            }
            if (key.indexOf(32) > -1) {
                String type = key.substring(0, key.indexOf(46));
                String algorithm = key.substring(key.indexOf(46) + 1, key.indexOf(32));
                String attribute = key.substring(key.indexOf(32) + 1, key.length());
                String value = (String)provider.get(key);
                Hashtable<String, String> attributeTable = (Hashtable<String, String>)attributeMap.get(String.valueOf(type) + '.' + algorithm);
                if (attributeTable == null) {
                    attributeTable = new Hashtable<String, String>();
                    attributeTable.put(attribute, value);
                    attributeMap.put(String.valueOf(type) + '.' + algorithm, attributeTable);
                    continue;
                }
                attributeTable.put(attribute, value);
                continue;
            }
            serviceList.put(key, provider.get(key));
        }
        ProviderService[] serviceArray = new ProviderService[serviceList.size()];
        Set serviceKeys = serviceList.keySet();
        int serviceCount = 0;
        Iterator it2 = serviceKeys.iterator();
        while (it2.hasNext()) {
            String key = (String)it2.next();
            String type = key.substring(0, key.indexOf(46));
            String algo = key.substring(key.indexOf(46) + 1, key.length());
            String className = (String)serviceList.get(key);
            List aliases = (List)aliasMap.get(algo);
            Map attributes = (Map)attributeMap.get(key);
            serviceArray[serviceCount] = new ProviderService(type, algo, className, aliases, attributes);
            ++serviceCount;
        }
        return serviceArray;
    }

    private static class ProviderService {
        private final String type;
        private final String algorithm;
        private final String className;
        private final List aliases;
        private final Map attributes;

        public ProviderService(String type, String algorithm, String className, List aliases, Map attributes) {
            this.type = type;
            this.algorithm = algorithm;
            this.className = className;
            this.aliases = aliases;
            this.attributes = attributes;
        }

        public String getType() {
            return this.type;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public String getClassName() {
            return this.className;
        }

        public List getAliases() {
            return this.aliases;
        }

        public Map getAttributes() {
            return this.attributes;
        }
    }
}

