/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.dial.DialDevice;
import com.jrockit.mc.ui.dial.IDialProvider;
import com.jrockit.mc.ui.dial.ImageDescription;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class DialViewer
extends Composite
implements IRefreshable {
    private static final int TITLE_VERTICAL_PADDING = 3;
    private static final String DRAW_PROPERTY = "com.jrockit.mc.ui.dial.immediatedraw";
    private static final boolean IMMEDIATE_DRAWING;
    private IDialProvider[] m_dials = new IDialProvider[0];
    private final Map<String, Object> m_inputs = new LinkedHashMap<String, Object>();
    private final MCAccessibleListener m_accessibleListener = new MCAccessibleListener();
    private IQuantity m_gradientBegin;
    private IQuantity m_gradientEnd;
    private MCColor m_gradientBeginColor;
    private MCColor m_gradientEndColor;
    private DialDevice m_lastDialDevice;
    private Image m_lastBackGroundImage;
    private int m_lastWidth = 0;
    private int m_lastHeight = 0;
    private String m_title;
    private IUnit<?> m_valueUnit;

    static {
        boolean drawImmediately = System.getProperty(DRAW_PROPERTY) != null ? Boolean.getBoolean(DRAW_PROPERTY) : OS.getType() == OS.Type.MAC;
        IMMEDIATE_DRAWING = drawImmediately;
    }

    public DialViewer(Composite parent, int style) {
        super(parent, 0x20000000);
        this.m_accessibleListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_DIAL);
        this.getAccessible().addAccessibleListener((AccessibleListener)this.m_accessibleListener);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!DialViewer.this.getClientArea().isEmpty()) {
                    DialViewer.this.draw(e.gc, 0, 0, DialViewer.this.getClientArea().width, DialViewer.this.getClientArea().height, false);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DialViewer.this.setCachedBackgroundImage(null);
            }
        });
    }

    private void setCachedBackgroundImage(Image image) {
        if (this.m_lastBackGroundImage != null && !this.m_lastBackGroundImage.isDisposed()) {
            this.m_lastBackGroundImage.dispose();
        }
        this.m_lastBackGroundImage = image;
    }

    public void setTitle(String title) {
        if (!this.isDisposed()) {
            this.m_accessibleListener.setName(title);
            this.m_title = title;
            this.redraw();
        }
    }

    public String getText() {
        return this.m_title;
    }

    public void setUnit(IUnit<?> unit) {
        this.m_valueUnit = unit;
        this.setCachedBackgroundImage(null);
        this.m_lastWidth = -1;
        this.m_lastHeight = -1;
    }

    public IUnit<?> getUnit() {
        return this.m_valueUnit;
    }

    private Point normalizedToDevice(ImageDescription config, int xOffset, int yOffset, double radius, double normalizedValue) {
        double radians = config.imageFunction.toRadians(normalizedValue);
        return new Point(xOffset += config.origin.x + (int)Math.round(radius * Math.cos(radians)), yOffset += config.origin.y - (int)Math.round(radius * Math.sin(radians)));
    }

    public void setGradientRange(IQuantity gradientBegin, IQuantity gradientEnd, MCColor gradientBeginColor, MCColor gradientEndColor) {
        this.m_gradientBegin = gradientBegin;
        this.m_gradientEnd = gradientEnd;
        this.m_gradientBeginColor = gradientBeginColor;
        this.m_gradientEndColor = gradientEndColor;
        this.setCachedBackgroundImage(null);
    }

    public void setProviders(IDialProvider ... providers) {
        this.m_dials = providers;
        this.refresh();
    }

    @Override
    public boolean refresh() {
        if (!this.isDisposed()) {
            if (IMMEDIATE_DRAWING) {
                Rectangle area;
                if (this.isVisible() && !(area = this.getClientArea()).isEmpty()) {
                    GC gc = new GC((Drawable)this);
                    this.draw(gc, 0, 0, area.width, area.height, true);
                    if (this.isFocusControl()) {
                        FocusTracker.drawFocusOn(this, gc);
                    }
                    gc.dispose();
                }
            } else {
                this.redraw();
            }
            return true;
        }
        return false;
    }

    public boolean setInput(String identifier, Object input) {
        Object oldInput = this.getInput(identifier);
        if (oldInput != input) {
            this.m_inputs.put(identifier, input);
            return true;
        }
        return false;
    }

    private void drawGradientBackground(GC gc, DialDevice dialDevice, RGB startRGB, RGB endRGB) {
        double nA = dialDevice.normalizeForDevice(this.m_gradientBegin);
        double nB = dialDevice.normalizeForDevice(this.m_gradientEnd);
        Color oldColor = gc.getBackground();
        double n = 1.0;
        while (n >= 0.0) {
            Color color = this.createColor(gc.getDevice(), startRGB, endRGB, n, Math.min(nA, nB), Math.max(nA, nB));
            gc.setBackground(color);
            this.fillArc(gc, dialDevice.getBackground(), n);
            color.dispose();
            n -= 0.01;
        }
        gc.setBackground(oldColor);
    }

    private Color createColor(Device device, RGB startRGB, RGB endRGB, double n, double start, double end) {
        if (n < start) {
            return new Color(device, startRGB);
        }
        if (n > end) {
            return new Color(device, endRGB);
        }
        return new Color(device, DialViewer.blend(startRGB, endRGB, DialViewer.normalize(start, end, n)));
    }

    private void fillArc(GC gc, ImageDescription config, double n) {
        int r = (int)Math.round(config.gradientRadius);
        int lA = (int)Math.round(Math.toDegrees(config.imageFunction.toRadians(0.0)));
        int rA = (int)Math.round(Math.toDegrees(config.imageFunction.toRadians(n)));
        gc.fillArc(config.origin.x - r, config.origin.y - r, 2 * r, 2 * r, rA, lA - rA);
    }

    private static double normalize(double start, double end, double value) {
        double total = end - start;
        return total != 0.0 ? (value - start) / total : 0.0;
    }

    private static RGB blend(RGB a, RGB b, double p) {
        return new RGB(DialViewer.interpolateRGB(a.red, b.red, p), DialViewer.interpolateRGB(a.green, b.green, p), DialViewer.interpolateRGB(a.blue, b.blue, p));
    }

    private static int interpolateRGB(int startValue, int endValue, double percentage) {
        return (int)((long)startValue + Math.round(percentage * (double)(endValue - startValue)));
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Rectangle imageBounds = DialDevice.getBackgroundSize();
        Point size = this.computeTitleSize();
        size.x = Math.max(size.x, imageBounds.width);
        size.y += imageBounds.height;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    private Point computeTitleSize() {
        if (this.m_title == null) {
            return new Point(0, 0);
        }
        GC gc = new GC((Drawable)this);
        Font oldFont = gc.getFont();
        FontData[] fontData = oldFont.getFontData();
        Font newFont = new Font(gc.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        gc.setFont(newFont);
        Point size = gc.textExtent(this.m_title);
        size.y += 3;
        newFont.dispose();
        gc.dispose();
        return size;
    }

    private void draw(GC gc, int x, int y, int width, int height, boolean drawOptimal) {
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        MCColor[] colors = new MCColor[this.m_dials.length];
        double[] values = new double[this.m_dials.length];
        int n = 0;
        while (n < this.m_dials.length) {
            IDialProvider provider = this.m_dials[n];
            Object input = this.getInput(provider.getId());
            colors[n] = provider.getColor(input);
            values[n] = provider.getValue(input);
            maxValue = Math.max(maxValue, values[n]);
            minValue = Math.min(minValue, values[n]);
            ++n;
        }
        DialDevice dd = DialDevice.buildSuitableDevice(minValue, maxValue, this.getUnit());
        ImageDescription bgConfig = dd.getBackground();
        Rectangle size = bgConfig.image.getBounds();
        int xOffset = (width - size.width) / 2;
        xOffset = Math.max(0, xOffset);
        int yOffset = height - size.height;
        this.updateBackgroundImage(dd, width, height, xOffset, 0);
        if (this.m_lastBackGroundImage != null) {
            gc.drawImage(this.m_lastBackGroundImage, 0, yOffset);
        }
        gc.setAntialias(1);
        if (!drawOptimal && this.m_title != null) {
            this.drawTitle(gc, xOffset, height, bgConfig, this.m_title);
        }
        this.drawDialText(gc, xOffset, yOffset, bgConfig, dd.getTitle());
        Color oldBackground = gc.getBackground();
        int oldAlpha = gc.getAlpha();
        int oldAntiAlias = gc.getAntialias();
        int n2 = 0;
        while (n2 < values.length) {
            if (!Double.isInfinite(values[n2])) {
                double normalizedValue = dd.normalizeForDevice(this.getUnit().quantity(values[n2]));
                this.drawDial(gc, xOffset, yOffset, bgConfig, normalizedValue, colors[n2].getAlpha(), colors[n2]);
            }
            ++n2;
        }
        gc.setAntialias(oldAntiAlias);
        gc.setAlpha(oldAlpha);
        gc.setBackground(oldBackground);
    }

    private Object getInput(String key) {
        return this.m_inputs.get(key);
    }

    private void updateBackgroundImage(DialDevice dialDevice, int width, int height, int xOffset, int yOffset) {
        if (this.m_lastBackGroundImage == null || this.m_lastDialDevice == null || !this.m_lastDialDevice.equals(dialDevice) || this.m_lastWidth != width || this.m_lastHeight != height) {
            this.createBackground(dialDevice, width, height, xOffset, yOffset);
            this.m_lastDialDevice = dialDevice;
            this.m_lastHeight = height;
            this.m_lastWidth = width;
        }
    }

    private void createBackground(DialDevice dialDevice, int width, int height, int xOffset, int yOffset) {
        this.setCachedBackgroundImage(new Image((Device)this.getDisplay(), width, height));
        GC fullBackgroundGC = new GC((Drawable)this.m_lastBackGroundImage);
        Rectangle bgBounds = dialDevice.getBackground().image.getBounds();
        Image panelImage = new Image((Device)this.getDisplay(), bgBounds.width, bgBounds.height);
        GC dialGC = new GC((Drawable)panelImage);
        Image g = UIPlugin.getDefault().getImage("dial-bkgnd.png");
        int i = 0;
        while (i < panelImage.getBounds().width) {
            dialGC.drawImage(g, i, 0);
            i += g.getBounds().width;
        }
        this.drawBackground(dialGC, dialDevice);
        dialGC.dispose();
        i = 0;
        while (i < this.m_lastBackGroundImage.getBounds().width) {
            fullBackgroundGC.drawImage(g, i, yOffset);
            i += g.getBounds().width;
        }
        fullBackgroundGC.drawImage(panelImage, xOffset, yOffset);
        fullBackgroundGC.dispose();
        panelImage.dispose();
    }

    private void drawTitle(GC gc, int xOffset, int height, ImageDescription config, String text) {
        Font oldFont = gc.getFont();
        FontData[] fontData = oldFont.getFontData();
        Font newFont = new Font(gc.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        gc.setFont(newFont);
        Point textExtent = gc.textExtent(text);
        int x = config.dialTextCenter.x - Math.round((float)textExtent.x / 2.0f);
        int y = height - config.image.getBounds().height - 3 - textExtent.y;
        y = Math.max(0, y);
        Color c = UIPlugin.getDefault().getFormColors(this.getDisplay()).getColor("org.eclipse.ui.forms.TITLE");
        gc.setForeground(c);
        gc.setAlpha(192);
        gc.drawString(text, x + xOffset, y, true);
        gc.setAlpha(255);
        gc.setFont(oldFont);
        newFont.dispose();
    }

    private void drawDialText(GC gc, int xOffset, int YOffset, ImageDescription config, String text) {
        Font oldFont = gc.getFont();
        FontData[] fontData = oldFont.getFontData();
        Font newFont = new Font(gc.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        gc.setFont(newFont);
        Point textExtent = gc.textExtent(text);
        int x = config.dialTextCenter.x - textExtent.x / 2 + xOffset;
        int y = config.dialTextCenter.y - textExtent.y / 2 + YOffset;
        Color foreground = new Color(gc.getDevice(), 0, 0, 0);
        gc.setForeground(foreground);
        gc.setAlpha(192);
        gc.drawString(text, x, y, true);
        gc.setAlpha(255);
        foreground.dispose();
        gc.setFont(oldFont);
        newFont.dispose();
    }

    private void drawDial(GC gc, int x, int y, ImageDescription config, double normalizedValue, double transparency, MCColor color) {
        Point gaugeStart = this.normalizedToDevice(config, x, y, config.dialStartRadius, normalizedValue);
        Point gaugeEnd = this.normalizedToDevice(config, x, y, config.dialEndRadius, normalizedValue);
        Point gaugeEdge1 = this.normalizedToDevice(config, x, y, config.dialStartRadius, normalizedValue + 0.02);
        Point gaugeEdge2 = this.normalizedToDevice(config, x, y, config.dialStartRadius, normalizedValue - 0.02);
        int[] edges = new int[]{gaugeEnd.x, gaugeEnd.y, gaugeEdge1.x, gaugeEdge1.y, gaugeEdge2.x, gaugeEdge2.y};
        Color fillColor = color.createSWTColor(gc.getDevice());
        gc.setAlpha(color.getAlpha());
        gc.setBackground(fillColor);
        gc.setForeground(fillColor);
        gc.fillPolygon(edges);
        gc.drawPolygon(edges);
        gc.drawLine(gaugeStart.x, gaugeStart.y, gaugeEnd.x, gaugeEnd.y);
        fillColor.dispose();
    }

    private void drawBackground(GC gc, DialDevice dialDevice) {
        if (this.m_gradientBegin == null || this.m_gradientEnd == null || !this.m_valueUnit.getContentType().equals(this.m_gradientBegin.getUnit().getContentType()) || !this.m_valueUnit.getContentType().equals(this.m_gradientEnd.getUnit().getContentType())) {
            this.drawUnNormalizedbackground(gc, dialDevice, this.m_gradientBeginColor.getRGBColor(), this.m_gradientEndColor.getRGBColor());
        } else {
            this.drawGradientBackground(gc, dialDevice, this.m_gradientBeginColor.getRGBColor(), this.m_gradientEndColor.getRGBColor());
        }
        gc.drawImage(dialDevice.getBackground().image, 0, 0);
    }

    private void drawUnNormalizedbackground(GC gc, DialDevice dialDevice, RGB startRGB, RGB endRGB) {
        double n = 1.0;
        while (n >= 0.0) {
            Color color = new Color(gc.getDevice(), DialViewer.blend(startRGB, endRGB, n));
            gc.setBackground(color);
            this.fillArc(gc, dialDevice.getBackground(), n);
            color.dispose();
            n -= 0.01;
        }
    }
}

