/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import java.awt.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.w3c.dom.Element;

public class MCColor
implements XmlEnabled {
    public static final String XML_TAG = "color";
    public static final String COLOR_COMPONENT_RED = "red";
    public static final String COLOR_COMPONENT_GREEN = "green";
    public static final String COLOR_COMPONENT_BLUE = "blue";
    public static final String COLOR_COMPONENT_ALPHA = "alpha";
    private final Setting m_settings = new Setting("color");
    private Color m_color;

    static {
        PersistenceToolkit.registerFetcher(MCColor.class, (ISettingFetcher)new ISettingFetcher<MCColor>(){

            public Setting getSetting(MCColor color) {
                return color.m_settings;
            }
        });
    }

    public MCColor() {
        this.m_settings.setChildObject(COLOR_COMPONENT_RED, (Object)0);
        this.m_settings.setChildObject(COLOR_COMPONENT_GREEN, (Object)0);
        this.m_settings.setChildObject(COLOR_COMPONENT_BLUE, (Object)0);
        this.m_settings.setChildObject(COLOR_COMPONENT_ALPHA, (Object)255);
    }

    public MCColor(int red, int green, int blue) {
        this.setColor(red, green, blue, 255);
    }

    public MCColor(int red, int green, int blue, int alpha) {
        this.setColor(red, green, blue, alpha);
    }

    public MCColor(Color color) {
        this.setColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public MCColor create() {
        this.initialize();
        return new MCColor(this.m_color);
    }

    public MCColor(RGB rgb) {
        this(rgb.red, rgb.green, rgb.blue);
    }

    public void setRGB(RGB rgb) {
        this.setColor(rgb.red, rgb.green, rgb.blue, this.getAlpha());
    }

    public org.eclipse.swt.graphics.Color createSWTColor(Device device) {
        return new org.eclipse.swt.graphics.Color(device, this.getRed(), this.getGreen(), this.getBlue());
    }

    public Color getAWTColor() {
        this.initialize();
        return this.m_color;
    }

    public int getRed() {
        this.initialize();
        return this.m_color.getRed();
    }

    public int getGreen() {
        this.initialize();
        return this.m_color.getGreen();
    }

    public int getAlpha() {
        this.initialize();
        return this.m_color.getAlpha();
    }

    public int getBlue() {
        this.initialize();
        return this.m_color.getBlue();
    }

    public void setRed(int red) {
        this.setColor(red, this.getGreen(), this.getBlue(), this.getAlpha());
    }

    public void setGreen(int green) {
        this.setColor(this.getRed(), green, this.getBlue(), this.getAlpha());
    }

    public void setBlue(int blue) {
        this.setColor(this.getRed(), this.getGreen(), blue, this.getAlpha());
    }

    public void setAlpha(int alpha) {
        this.setColor(this.getRed(), this.getGreen(), this.getBlue(), alpha);
    }

    public String toString() {
        return "RGBA = {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "} " + System.identityHashCode(this);
    }

    public RGB getRGBColor() {
        this.initialize();
        return new RGB(this.getRed(), this.getGreen(), this.getBlue());
    }

    public void exportToXml(Element parentNode) {
        Element colorNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)colorNode, (String)COLOR_COMPONENT_RED, (String)Integer.toString(this.getRed()));
        XmlToolkit.setSetting((Element)colorNode, (String)COLOR_COMPONENT_GREEN, (String)Integer.toString(this.getGreen()));
        XmlToolkit.setSetting((Element)colorNode, (String)COLOR_COMPONENT_BLUE, (String)Integer.toString(this.getBlue()));
    }

    public String getComponentTag() {
        return XML_TAG;
    }

    public void initializeFromXml(Element node) throws Exception {
        this.setColor(XmlToolkit.getSetting((Element)node, (String)COLOR_COMPONENT_RED, (int)0), XmlToolkit.getSetting((Element)node, (String)COLOR_COMPONENT_GREEN, (int)0), XmlToolkit.getSetting((Element)node, (String)COLOR_COMPONENT_BLUE, (int)0), 255);
    }

    private void initialize() {
        if (this.m_color == null) {
            this.setColor((Integer)this.m_settings.getChildObject(COLOR_COMPONENT_RED, Integer.class), (Integer)this.m_settings.getChildObject(COLOR_COMPONENT_GREEN, Integer.class), (Integer)this.m_settings.getChildObject(COLOR_COMPONENT_BLUE, Integer.class), (Integer)this.m_settings.getChildObject(COLOR_COMPONENT_ALPHA, Integer.class));
        }
    }

    private void setColor(int red, int green, int blue, int alpha) {
        this.m_settings.setChildObject(COLOR_COMPONENT_RED, (Object)red);
        this.m_settings.setChildObject(COLOR_COMPONENT_GREEN, (Object)green);
        this.m_settings.setChildObject(COLOR_COMPONENT_BLUE, (Object)blue);
        this.m_settings.setChildObject(COLOR_COMPONENT_ALPHA, (Object)alpha);
        this.m_color = new Color(red, green, blue, alpha);
    }

    public static MCColor createFromInternetColorString(String string) {
        if (string != null && string.length() > 0) {
            try {
                return new MCColor(Color.decode(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

