/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class TimeField
extends NumberField {
    private static final String SECOND_FORMATTING = "ss";
    private static final String MILLIS_FORMATTING = "SSS";
    private static final String SECOND_MILLIS_SEPARATOR = ".";
    private final DateFormat m_dateFormat = DateFormat.getDateTimeInstance(3, 2);
    private final DateFormat m_dateMSFormat;

    public TimeField(int id) {
        super(id);
        SimpleDateFormat format;
        String pattern;
        int index;
        this.m_dateMSFormat = this.m_dateFormat instanceof SimpleDateFormat ? ((index = (pattern = (format = (SimpleDateFormat)this.m_dateFormat).toPattern()).indexOf(SECOND_FORMATTING)) >= 0 ? new SimpleDateFormat(pattern.replace(SECOND_FORMATTING, "ss.SSS")) : new SimpleDateFormat(String.valueOf(pattern) + SECOND_MILLIS_SEPARATOR + MILLIS_FORMATTING)) : this.m_dateFormat;
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number && TimeField.isValid((Number)object)) {
            if (this.getShowMillis()) {
                if (this.m_dateMSFormat != null) {
                    return this.m_dateMSFormat.format(object);
                }
                return String.valueOf(this.m_dateFormat.format(object)) + SECOND_MILLIS_SEPARATOR + TimeField.zeroPad(((Number)object).longValue() % 1000L);
            }
            return this.m_dateFormat.format(object);
        }
        return super.formatObject(object);
    }

    public boolean getShowMillis() {
        return this.getBoolean("showMillis", true);
    }

    public void setShowMillis(boolean show) {
        this.setProperty("showMillis", Boolean.valueOf(show).toString());
    }

    private static String zeroPad(long value) {
        if (value < 10L) {
            return "00" + Long.toString(value);
        }
        if (value < 100L) {
            return "0" + Long.toString(value);
        }
        return Long.toString(value);
    }

    @Override
    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }

    @Override
    public Object parse(Tokenizer tokenizer) {
        return null;
    }
}

