/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.sections;

import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class MultiSectionPart
extends MCClientSectionPart {
    private Composite m_parent;
    private final List<SectionPart> m_parts = new ArrayList<SectionPart>();

    public MultiSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected abstract void initSectionPart(Composite var1);

    @Override
    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        this.getSection().setLayout(MCLayoutFactory.createMarginFreeFormPageLayout(1));
        this.m_parent = formToolkit.createComposite(section, 0);
        formToolkit.adapt(this.m_parent);
        this.initSectionPart(this.m_parent);
        if (this.m_parent.getLayout() == null) {
            this.update();
        }
        return this.m_parent;
    }

    public final void addSectionPart(SectionPart sp) {
        this.getManagedForm().addPart((IFormPart)sp);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 50;
        gd.heightHint = 150;
        sp.getSection().setLayoutData((Object)gd);
        this.m_parts.add(sp);
        sp.refresh();
    }

    public void clear() {
        SectionPart[] parts;
        SectionPart[] sectionPartArray = parts = this.getChildren().toArray(new SectionPart[this.getChildren().size()]);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            SectionPart part = sectionPartArray[n2];
            this.removeSectionPart(part);
            ++n2;
        }
    }

    public final Composite getSectionParent() {
        return this.m_parent;
    }

    public final List<SectionPart> getChildren() {
        return Collections.unmodifiableList(this.m_parts);
    }

    public final void removeSectionPart(SectionPart sp) {
        this.getManagedForm().removePart((IFormPart)sp);
        this.m_parts.remove(sp);
        sp.dispose();
        sp.getSection().dispose();
        this.update();
    }

    public void update() {
        GridLayout layout = new GridLayout(this.getChildren().size(), false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.getSectionParent().setLayout((Layout)layout);
        this.getSection().layout(true, true);
    }
}

