/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.telnet;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.Socket;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.common.ConsoleInputHandler;
import org.eclipse.equinox.console.common.ConsoleInputScanner;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.telnet.Callback;
import org.eclipse.equinox.console.telnet.NegotiationFinishedCallback;
import org.eclipse.equinox.console.telnet.TelnetInputHandler;
import org.eclipse.equinox.console.telnet.TelnetOutputStream;
import org.osgi.framework.BundleContext;

public class TelnetConnection
extends Thread
implements Closeable {
    private Socket socket;
    private CommandProcessor processor;
    private BundleContext context;
    protected boolean isTelnetNegotiationFinished = false;
    private Callback callback;
    private static final long TIMEOUT = 1000L;
    private static final long NEGOTIATION_TIMEOUT = 60000L;
    private static final String PROMPT = "prompt";
    private static final String OSGI_PROMPT = "osgi> ";
    private static final String SCOPE = "SCOPE";
    private static final String EQUINOX_SCOPE = "equinox:*";
    private static final String CLOSEABLE = "CLOSEABLE";

    public TelnetConnection(Socket socket, CommandProcessor processor, BundleContext context) {
        this.socket = socket;
        this.processor = processor;
        this.context = context;
        this.callback = new NegotiationFinishedCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            ConsoleInputStream in = new ConsoleInputStream();
            TelnetOutputStream out = new TelnetOutputStream(this.socket.getOutputStream());
            out.autoSend();
            TelnetInputHandler telnetInputHandler = new TelnetInputHandler(this.socket.getInputStream(), in, out, this.callback);
            telnetInputHandler.start();
            long start = System.currentTimeMillis();
            TelnetConnection telnetConnection = this;
            synchronized (telnetConnection) {
                while (!this.isTelnetNegotiationFinished && System.currentTimeMillis() - start < 60000L) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            PrintStream output = new PrintStream(out);
            ConsoleInputStream inp = new ConsoleInputStream();
            ConsoleInputHandler consoleInputHandler = new ConsoleInputHandler(in, inp, out);
            consoleInputHandler.getScanner().setBackspace(telnetInputHandler.getScanner().getBackspace());
            consoleInputHandler.getScanner().setDel(telnetInputHandler.getScanner().getDel());
            consoleInputHandler.getScanner().setCurrentEscapesToKey(telnetInputHandler.getScanner().getCurrentEscapesToKey());
            consoleInputHandler.getScanner().setEscapes(telnetInputHandler.getScanner().getEscapes());
            ((ConsoleInputScanner)consoleInputHandler.getScanner()).setContext(this.context);
            consoleInputHandler.start();
            CommandSession session = this.processor.createSession((InputStream)inp, output, output);
            session.put(SCOPE, (Object)EQUINOX_SCOPE);
            session.put(PROMPT, (Object)OSGI_PROMPT);
            session.put(CLOSEABLE, (Object)this);
            ((ConsoleInputScanner)consoleInputHandler.getScanner()).setSession(session);
            try {
                try {
                    session.execute((CharSequence)"gosh --login --noshutdown");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    session.close();
                    try {
                        this.socket.close();
                        return;
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                session.close();
                try {
                    this.socket.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            session.close();
            try {
                this.socket.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.interrupt();
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void telnetNegotiationFinished() {
        this.isTelnetNegotiationFinished = true;
        this.notify();
    }
}

